package com.ejianc.business.tax.service.impl;

import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 设备合同结算单审批操作后
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("invoiceOpen")
public class InvoiceOpenBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IIncomeContractApi incomeContractApwi;
    @Autowired
    private IInvoiceOpenService invoiceOpenService;
    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("提交前回调--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity entity = invoiceOpenService.selectById(billId);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("invoiceNumber", new Parameter(QueryParam.EQ, entity.getInvoiceNumber()));
        List<InvoiceOpenEntity> list = invoiceOpenService.queryList(param, false);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("发票号码已存在!");
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("终审审核前回调--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity entity = invoiceOpenService.selectById(billId);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("invoiceNumber", new Parameter(QueryParam.EQ, entity.getInvoiceNumber()));
        List<InvoiceOpenEntity> list = invoiceOpenService.queryList(param, false);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("发票号码已存在!");
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        //合同是否被其他单据引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("进入收票审批同意后回写--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity invoiceOpenEntity = invoiceOpenService.selectById(billId);
        //总包合同数据回写
        if (null != invoiceOpenEntity.getContractId()) {
            CommonResponse<String> stringCommonResponse = incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), true);
            if (stringCommonResponse.isSuccess()) {
                return CommonResponse.success();
            } else {
                return CommonResponse.error("审批回写异常!");
            }
        }
        return CommonResponse.success();

    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("进入收票撤回后回写--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity invoiceOpenEntity = invoiceOpenService.selectById(billId);
        //总包合同数据回写
        if (null != invoiceOpenEntity.getContractId()){
            CommonResponse<String> stringCommonResponse = incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), false);
            if (stringCommonResponse.isSuccess()) {
                return CommonResponse.success();
            } else {
                return CommonResponse.error("审批回写异常!");
            }
        }
        return CommonResponse.success();
    }

}
