package com.ejianc.business.taxnew.service.impl;

import com.ejianc.business.taxnew.bean.*;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplyService;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplySubService;
import com.ejianc.business.taxnew.service.IInvoiceDeducBillService;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;

@Service("invoiceDeducBill") 
public class InvoiceDeducBillBpmServiceImpl implements ICommonBusinessService {


	@Autowired
	private IInvoiceDeducBillService service;
	@Autowired
	private IInvoiceDeducApplyService applyService;
	@Autowired
	private IInvoiceDeducApplySubService applySubService;
	@Autowired
	private IInvoiceReceivePoolService poolService;

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		InvoiceDeducBillEntity entity = service.selectById(billId);
		if(entity == null ){
			return CommonResponse.error("没有找到该单据！");
		}
		entity.setAlreadyDeduc(true);
		for (InvoiceDeducBillSubEntity sub : entity.getInvoiceDeducBillSubs()) {
			InvoiceDeducApplySubEntity applySubEntity = applySubService.selectById(sub.getApplySubId());
			InvoiceReceivePoolEntity poolEntity = poolService.selectById(sub.getInvoiceId());
			if(applySubEntity!=null){
				applySubEntity.setActualDeducMny(sub.getActualDeducMny());
				applySubEntity.setActualDeducTaxMny(sub.getActualDeducTaxMny());
				applySubEntity.setAlreadyDeduc(true);
				applySubEntity.setDeducDate(sub.getCreateTime());
				applySubService.saveOrUpdateNoES(applySubEntity);
			}
			if(poolEntity!=null){
				poolEntity.setActualDeductionMny(sub.getActualDeducMny());
				poolEntity.setActualDeductionTax(sub.getActualDeducTaxMny());
				poolEntity.setDeductionState(1);
				poolService.saveOrUpdateNoES(poolEntity);
			}
			InvoiceDeducApplyEntity applyEntity = applyService.selectById(entity.getApplyId());
			applyEntity.setAlreadyDeduc(true);
			applyService.saveOrUpdateNoES(applyEntity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		InvoiceDeducBillEntity entity = service.selectById(billId);
		if(entity == null ){
			return CommonResponse.error("没有找到该单据！");
		}
		entity.setAlreadyDeduc(false);
		for (InvoiceDeducBillSubEntity sub : entity.getInvoiceDeducBillSubs()) {
			InvoiceDeducApplySubEntity applySubEntity = applySubService.selectById(sub.getApplySubId());
			InvoiceReceivePoolEntity poolEntity = poolService.selectById(sub.getInvoiceId());
			if(applySubEntity!=null){
				applySubEntity.setActualDeducMny(BigDecimal.ZERO);
				applySubEntity.setActualDeducTaxMny(BigDecimal.ZERO);
				applySubEntity.setAlreadyDeduc(false);
				applySubEntity.setDeducDate(null);
				applySubService.saveOrUpdateNoES(applySubEntity);
			}
			if(poolEntity!=null){
				poolEntity.setActualDeductionMny(BigDecimal.ZERO);
				poolEntity.setActualDeductionTax(BigDecimal.ZERO);
				poolEntity.setDeductionState(0);
				poolService.saveOrUpdateNoES(poolEntity);
			}
			InvoiceDeducApplyEntity applyEntity = applyService.selectById(entity.getApplyId());
			applyEntity.setAlreadyDeduc(false);
			applyService.saveOrUpdateNoES(applyEntity);
		}
		return CommonResponse.success();
	}

}
