package com.ejianc.business.tax.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 有合同开票 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@RestController
@RequestMapping("invoiceReceive")
public class InvoiceReceiveController {
    @Autowired
    private IInvoiceReceiveService invoiceReceiveService;
    @Autowired
    private IOrgApi orgApi;
    /**
     * 新增或者修改
     *
     * @param invoiceReceiveVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceReceiveVO> saveOrUpdate(@RequestBody InvoiceReceiveVO invoiceReceiveVO) {
        CommonResponse<InvoiceReceiveVO> response = invoiceReceiveService.saveOrUpdate(invoiceReceiveVO);
        return response;
    }
    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveVO> queryDetail(@RequestParam Long id) {
        InvoiceReceiveVO invoiceReceiveVo = invoiceReceiveService.queryDetail(id);
        return CommonResponse.success(invoiceReceiveVo);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceiveVO> vos) {
        invoiceReceiveService.deleteInvoiceReceive(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 列表查询
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("invoiceNumber");
        fuzzyFields.add("invoiceCode");
        boolean createFlag = param.getParams().containsKey("createFlag");
        if (createFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            param.getParams().remove("createFlag");
        }
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<InvoiceReceiveEntity> pageData= invoiceReceiveService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), InvoiceOpenVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }
    /**
     * 查询指定组织本下的所有租赁合同信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/invoiceReceiveRef")
    public CommonResponse<IPage<InvoiceReceiveVO>> projectListRefe(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                @RequestParam(defaultValue = "10") Integer pageSize,
                                                                @RequestParam(value = "condition", required = false) String condition,
                                                                @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        queryParam.getParams().put("flag",new Parameter(QueryParam.NE,1));

        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
                queryParam.getParams().put("type", new Parameter(QueryParam.EQ, 1));
            }else {
                queryParam.getParams().put("type", new Parameter(QueryParam.EQ, 2));
            }
            if(null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                queryParam.getParams().put("org_id", new Parameter(QueryParam.EQ, orgId));
            }
        }
        IPage<InvoiceReceiveEntity> pageData = invoiceReceiveService.queryPage(queryParam,false);
        IPage<InvoiceReceiveVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), InvoiceReceiveVO.class));
        return CommonResponse.success("开票登记参照查询成功！", result);
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("invoiceNumber");
        fuzzyFields.add("invoiceCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        boolean createFlag = param.getParams().containsKey("createFlag");
        if (createFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
            param.getParams().remove("createFlag");
        }
        param.setPageIndex(1);
        param.setPageSize(10000);
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("收票查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<InvoiceReceiveEntity> pageData= invoiceReceiveService.queryPage(param,false);
        List<InvoiceReceiveVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), InvoiceReceiveVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("receive.xlsx", beans, response);
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/9/23 根据所给项目ids，查询已收票价税合计总和
     * @Description getTotalInvoiceTaxMnyByProjectIds
     * @Param [projectIds]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     */
    @RequestMapping(value = "getTotalInvoiceTaxMnyByProjectIds", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> getTotalInvoiceTaxMnyByProjectIds(@RequestBody List<Long> projectIds) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));//租户隔离
        queryParam.getParams().put("dependOnProject",new Parameter(QueryParam.EQ,"1"));//属于项目
        queryParam.getParams().put("type",new Parameter(QueryParam.EQ,1));//开票类型:1,有合同
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));//单据状态已提交和审批通过
        if(ListUtil.isNotEmpty(projectIds)){
            queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
        }
        List<InvoiceReceiveEntity> contractEntities = invoiceReceiveService.queryList(queryParam,false);
        BigDecimal invoiceTaxMny = new BigDecimal("0.00");
        if(ListUtil.isNotEmpty(contractEntities)){
            for (InvoiceReceiveEntity p:contractEntities){
                if(p.getInvoiceTaxMny()!=null){
                    invoiceTaxMny = invoiceTaxMny.add(p.getInvoiceTaxMny());
                }
            }
        }
        JSONObject back = new JSONObject();
        back.put("invoiceTaxMny",invoiceTaxMny);
        return CommonResponse.success(back);
    }

}
