/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceOpenPoolMapper;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceOpenRegist")
public class InvoiceOpenRegistBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceOpenPoolService invoiceOpenPoolService;
    @Autowired
    private InvoiceOpenPoolMapper invoiceOpenPoolMapper;
    @Autowired
    private IInvoiceOpenRegistService invoiceOpenRegistService;
    @Autowired
    private IInvoiceOpenApplyService invoiceOpenApplyService;
    @Autowired
    private IIncomeContractApi incomeContractApwi;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"regist_id", (Object)billId);
        updateWrapper.eq((Object)"dr", (Object)0);
        updateWrapper.set((Object)"bill_state", (Object)state);
        updateWrapper.set((Object)"regist", (Object)1);
        this.invoiceOpenPoolService.update((Wrapper)updateWrapper);
        InvoiceOpenRegistEntity invoiceOpenRegistEntity = this.invoiceOpenRegistService.selectByIdAll(billId);
        if (invoiceOpenRegistEntity.getApplyId() != null) {
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.eq((Object)"id", (Object)invoiceOpenRegistEntity.getApplyId());
            wrapper.set((Object)"open_type", (Object)1);
            this.invoiceOpenApplyService.update((Wrapper)wrapper);
        }
        invoiceOpenRegistEntity.setRegistState(1);
        if (invoiceOpenRegistEntity.getContractItemList().size() == 0) {
            List<InvoiceOpenPoolEntity> list = this.invoiceOpenRegistService.generateInvoiceOpenPool(invoiceOpenRegistEntity);
            list.forEach(sub -> {
                sub.setBillState(state);
                sub.setRegist(1);
            });
            invoiceOpenRegistEntity.setContractItemList(list);
            invoiceOpenRegistEntity.setInvoiceAuantity(1);
            this.invoiceOpenPoolService.save((Object)list.get(0));
        }
        this.invoiceOpenRegistService.saveOrUpdateNoES((Object)invoiceOpenRegistEntity);
        if (ListUtil.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())) {
            List<InvoiceOpenPoolEntity> poolEntities = invoiceOpenRegistEntity.getContractItemList();
            for (InvoiceOpenPoolEntity invoiceOpenEntity : poolEntities) {
                CommonResponse stringCommonResponse = this.incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), Boolean.valueOf(true));
                if (stringCommonResponse.isSuccess()) continue;
                this.logger.error("\u5ba1\u6279\u56de\u5199\u5f02\u5e38!{}", (Object)stringCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"regist_id", (Object)billId);
        queryWrapper.eq((Object)"dr", (Object)0);
        List poolEntities = this.invoiceOpenPoolService.list((Wrapper)queryWrapper);
        if (ListUtil.isNotEmpty((List)poolEntities)) {
            for (InvoiceOpenPoolEntity poolEntity : poolEntities) {
                CommonResponse res = this.billTypeApi.checkQuote("BT200605000000001", poolEntity.getId());
                this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
                if (res.isSuccess()) continue;
                return CommonResponse.error((String)res.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"regist_id", (Object)billId);
        updateWrapper.eq((Object)"dr", (Object)0);
        updateWrapper.set((Object)"bill_state", (Object)0);
        updateWrapper.set((Object)"regist", (Object)0);
        this.invoiceOpenPoolService.update((Wrapper)updateWrapper);
        InvoiceOpenRegistEntity invoiceOpenRegistEntity = (InvoiceOpenRegistEntity)((Object)this.invoiceOpenRegistService.getById(billId));
        if (invoiceOpenRegistEntity.getApplyId() != null) {
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.eq((Object)"id", (Object)invoiceOpenRegistEntity.getApplyId());
            wrapper.set((Object)"open_type", (Object)0);
            this.invoiceOpenApplyService.update((Wrapper)wrapper);
        }
        invoiceOpenRegistEntity.setRegistState(0);
        this.invoiceOpenRegistService.saveOrUpdateNoES((Object)invoiceOpenRegistEntity);
        if (ListUtil.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())) {
            List<InvoiceOpenPoolEntity> poolEntities = invoiceOpenRegistEntity.getContractItemList();
            for (InvoiceOpenPoolEntity invoiceOpenEntity : poolEntities) {
                CommonResponse stringCommonResponse = this.incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), Boolean.valueOf(false));
                if (stringCommonResponse.isSuccess()) continue;
                this.logger.error("\u5ba1\u6279\u56de\u5199\u5f02\u5e38!{}", (Object)stringCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }
}

