package com.ejianc.business.tax.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;

@RestController
@RequestMapping("/api/tax/")
public class InvoiceApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IInvoiceOpenService invoiceOpenService;
	@Autowired
	private IInvoiceReceiveService invoiceReceiveService;
	@Autowired
	private IOrgApi orgApi;
	@RequestMapping(value = "getInvoiceOpenMny", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<BigDecimal> getInvoiceOpenMny(@RequestParam Long contractId, @RequestParam Long orgId) {
		try {
			BigDecimal openMny = invoiceOpenService.getOpenMny(contractId, orgId);
			return CommonResponse.success(openMny);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}
	@RequestMapping(value = "getNoContractOpenMny", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<BigDecimal> getNoContractOpenMny(@RequestParam Long projectId, @RequestParam Long customerId) {
		try {
			BigDecimal openMny = invoiceOpenService.getNoContractOpenMny(projectId, customerId);
			return CommonResponse.success(openMny);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}
	@RequestMapping(value = "getInvoiceReceiceMny", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<BigDecimal> getInvoiceReceiceMny(@RequestParam Long contractId, @RequestParam Long orgId) {
		try {
			BigDecimal openMny = invoiceReceiveService.getReceiveMny(contractId, orgId);
			return CommonResponse.success(openMny);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}
	/**
	 *
	 *
	 * @param pageNumber
	 * @param pageSize
	 * @param condition
	 * @param searchText
	 * @return
	 */
	@GetMapping("/invoiceOpenRef")
	public CommonResponse<IPage<InvoiceOpenVO>> invoiceOpenRef(@RequestParam(defaultValue = "1") Integer pageNumber,
																@RequestParam(defaultValue = "10") Integer pageSize,
																@RequestParam(value = "condition", required = false) String condition,
																@RequestParam(value = "searchText", required = false) String searchText) {

		QueryParam queryParam = new QueryParam();
		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
		queryParam.setSearchText(searchText);
		queryParam.getFuzzyFields().add("billCode");
		queryParam.getFuzzyFields().add("contractName");
		List<Integer> billstate = new ArrayList<>();
		billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
		billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
		queryParam.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
		if(StringUtils.isNotBlank(condition)) {
			Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
			if(null != conditionMap.get("orgId")) {
				Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
				queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
			}
			if(null != conditionMap.get("contractId")) {
				Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
				queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
				queryParam.getParams().put("type", new Parameter(QueryParam.EQ, 1));//有合同
			} else {
				queryParam.getParams().put("type", new Parameter(QueryParam.EQ, 2));//无合同
			}
		}
		IPage<InvoiceOpenEntity> pageData = invoiceOpenService.queryPage(queryParam,false);
		IPage<InvoiceOpenVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
		result.setRecords(BeanMapper.mapList(pageData.getRecords(), InvoiceOpenVO.class));
		return CommonResponse.success("开票登记参照查询成功！", result);
	}
	/**
	 *
	 *
	 * @param queryParam
	 * @return
	 */
	@PostMapping("/invoiceReceiveRef")
	public CommonResponse<JSONObject> invoiceReceiveRef(@RequestBody QueryParam queryParam) {
		IPage<InvoiceReceiveEntity> pageData = invoiceReceiveService.queryPage(queryParam,false);
		JSONObject page = new JSONObject();
		page.put("records", BeanMapper.mapList(pageData.getRecords(), InvoiceReceiveVO.class));
		page.put("total", pageData.getTotal());
		page.put("current", pageData.getCurrent());
		page.put("size", pageData.getSize());
		page.put("pages", pageData.getPages());
		return CommonResponse.success("收票登记参照查询成功！", page);
	}
	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/getInvoiceReceiveRecord", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<InvoiceReceiveRecordVO> getInvoiceReceiveRecord(@RequestParam Long id) {
		InvoiceReceiveRecordVO invoiceReceiveRecordVO = invoiceReceiveService.getInvoiceReceiveRecord(id);
		return CommonResponse.success(invoiceReceiveRecordVO);
	}

	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/getInvoiceReceiveRecords", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Map<Long, InvoiceReceiveRecordVO>>  getInvoiceReceiveRecords(@RequestParam List<Long> ids) {
		Map<Long, InvoiceReceiveRecordVO> invoiceReceiveRecords = invoiceReceiveService.getInvoiceReceiveRecords(ids);
		return CommonResponse.success(invoiceReceiveRecords);
	}
	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/getInvoiceOpenRecord", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<InvoiceOpenRecordVO> getInvoiceOpenRecord(@RequestParam Long id) {
		InvoiceOpenRecordVO invoiceOpenRecordVO = invoiceOpenService.getInvoiceOpenRecord(id);
		return CommonResponse.success(invoiceOpenRecordVO);
	}
	/**
	 * 维护占用的收票数据
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/updateUsedInvoiceMny", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> updateUsedInvoiceMny(@RequestBody List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS) {
		return invoiceReceiveService.updateUsedInvoiceMny(invoiceReceiveFlagVOS);
	}

	/**
	 * 维护占用的收票数据
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/updateFlag", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> updateFlag(@RequestBody List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS) {
		return invoiceReceiveService.updateFlag(invoiceReceiveFlagVOS);
	}
	/**
	 * 已生效的有合同开票登记金额（含税）
	 *
	 * @param param
	 * 		tenantId 租户Id
	 * 		projectIds要匹配的项目Id列表
	 * @return
	 */
	@RequestMapping(value = "countInvoiceOpenByProperties", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<BigDecimal> countInvoiceOpenByProperties(@RequestBody Map<String, Object> param) {
		QueryWrapper<InvoiceOpenEntity> queryWrapper = new QueryWrapper<>();
		//本租户下的
		queryWrapper.eq("tenant_id", param.get("tenantId"));
		queryWrapper.eq("dr", 0);
		//匹配的项目范围
		if(null != param.get("projectIds") && CollectionUtils.isNotEmpty((List<Long>)param.get("projectIds"))) {
			queryWrapper.in("project_id", (List<Long>)param.get("projectIds"));
		}
		//有效的单据
		queryWrapper.in("bill_state", Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));
		//查询有合同的收入
		queryWrapper.eq("type", 1);
		queryWrapper.select(" round(ifnull(sum(invoice_tax_mny),0) / 10000, 2) as amt ");
		Map<String, Object> result = invoiceOpenService.getMap(queryWrapper);

		return CommonResponse.success(new BigDecimal(result.get("amt").toString()));
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/9/24 移动端 ---年度经营指标---累计收票 累计开票 查询
	 * @Description getAnnuallyCountData
	 * @Param [projectIds]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
	 */
	@RequestMapping(value = "getAnnuallyCountData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> getAnnuallyCountData(@RequestBody List<Long> projectIds) {
		QueryParam queryParam = new QueryParam();
		Calendar calendar = Calendar.getInstance();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));//租户隔离
		queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));//单据状态已提交和审批通过
		queryParam.getParams().put("invoiceDate", new Parameter(QueryParam.BETWEEN, calendar.get(Calendar.YEAR) + "-01-01," + calendar.get(Calendar.YEAR) + "-12-31"));//
		if (ListUtil.isNotEmpty(projectIds)) {
			queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
		}
		/** 收票 */
		queryParam.getParams().put("dependOnProject", new Parameter(QueryParam.EQ, "1"));//属于项目
		List<InvoiceReceiveEntity> receiveEntities = invoiceReceiveService.queryList(queryParam, false);
		/** 开票 */
		queryParam.getParams().remove("dependOnProject");
		List<InvoiceOpenEntity> openEntities = invoiceOpenService.queryList(queryParam, false);
		BigDecimal totalReceive = new BigDecimal("0.00");
		BigDecimal totalOpen = new BigDecimal("0.00");
		if (ListUtil.isNotEmpty(receiveEntities)) {
			for (InvoiceReceiveEntity entity : receiveEntities) {
				if (entity.getInvoiceTaxMny() != null) {
					totalReceive = totalReceive.add(entity.getInvoiceTaxMny());
				}
			}
		}
		if (ListUtil.isNotEmpty(openEntities)) {
			for (InvoiceOpenEntity entity : openEntities) {
				if (entity.getInvoiceTaxMny() != null) {
					totalOpen = totalOpen.add(entity.getInvoiceTaxMny());
				}
			}
		}

		JSONObject back = new JSONObject();
		back.put("totalReceive", totalReceive);
		back.put("totalOpen", totalOpen);
		return CommonResponse.success(back);
	}

	/**
	 * @Description  根据租户id集合查询收票信息
	 */
	@RequestMapping(value = "getInvoiceMnyByTenantIds", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Map<String, InvoiceMnyWarnVO>> getInvoiceMnyByTenantIds(@RequestBody InvoicePubWarnQueryVO pubWarnQueryVO) {
		logger.error("pubWarnQueryVO is "  + JSONObject.toJSONString(pubWarnQueryVO));
		Map<String, InvoiceMnyWarnVO> map = invoiceReceiveService.getInvoiceMnyByTenantIds(pubWarnQueryVO);
		return CommonResponse.success("查询成功！", map);
	}
	/**
	 * @Description  根据租户id集合查询收票信息(不分集采和自采)
	 */
	@RequestMapping(value = "getWarnInvoiceMny", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Map<String, InvoiceMnyWarnVO>> getWarnInvoiceMny(@RequestBody InvoicePubWarnQueryVO pubWarnQueryVO) {
		logger.error("pubWarnQueryVO is "  + JSONObject.toJSONString(pubWarnQueryVO));
		Map<String, InvoiceMnyWarnVO> map = invoiceReceiveService.getWarnInvoiceMny(pubWarnQueryVO);
		return CommonResponse.success("查询成功！", map);
	}

	@PostMapping(value = "getReceiveListByQueryParam")
	public CommonResponse<JSONObject> getReceiveListByQueryParam(@RequestBody QueryParam queryParam) {
		List<InvoiceReceiveEntity> list = invoiceReceiveService.queryList(queryParam, false);
		JSONObject back = new JSONObject();
		back.put("records", list);
		return CommonResponse.success(back);
	}

	@PostMapping(value = "getOpenListByQueryParam")
	public CommonResponse<JSONObject> getOpenListByQueryParam(@RequestBody QueryParam queryParam) {
		List<InvoiceOpenEntity> list = invoiceOpenService.queryList(queryParam, false);
		JSONObject back = new JSONObject();
		back.put("records", list);
		return CommonResponse.success(back);
	}

	/**
	 * 查询项目下开票金额累计
	 * @param projectId
	 * @return
	 */
	@RequestMapping(value = "/billingContract", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<BigDecimal> sumContractMny(@RequestParam(value = "projectId") Long projectId) {
		return CommonResponse.success("查询列表数据成功！", invoiceOpenService.billingContract(projectId));
	}
	/**
	 * 按照合同类型查询开票金额
	 * @param projectId
	 * @return
	 */
	@RequestMapping(value = "/getTaxReceive", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<InvoiceReceiveVO>> getTaxReceive(@RequestParam(value = "projectId") Long projectId) {
		return CommonResponse.success("查询列表数据成功！", invoiceReceiveService.getTaxReceive(projectId));
	}
}
