package com.ejianc.business.taxnew.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 收票登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_invoice_receive_regist")
public class InvoiceReceiveRegistEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="receive_type")
    private Integer receiveType; // 收票类型：1分包、2设备采购、3设备租赁，4物资采购
    @TableField(value="seller_id")
    private Long sellerId; // 销售方id
    @TableField(value="seller_name")
    private String sellerName; // 销售方名称
    @TableField(value="current_receive_mny_tax")
    private java.math.BigDecimal currentReceiveMnyTax; // 本次收票金额含税
    @TableField(value="current_receive_mny")
    private java.math.BigDecimal currentReceiveMny; // 本次收票金额不含税
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税金
    @TableField(value="money_type")
    private Integer moneyType; // 款项类别，1预付款，2，进度款，3其他
    @TableField(value="type")
    private Integer type; // 合同类型:1,有合同,2,无合同
    @TableField(value="process_person_id")
    private Long processPersonId; // 经办人id
    @TableField(value="process_person_name")
    private String processPersonName; // 经办人名称
    @TableField(value="buyer_id")
    private Long buyerId; // 购方id
    @TableField(value="buyer_name")
    private String buyerName; // 购方名称
    @TableField(value="buyer_tax_no")
    private String buyerTaxNo; // 购方纳税人识别号
    @TableField(value="buyer_bank_account")
    private String buyerBankAccount; // 购方开户行账号
    @TableField(value="buyer_addr_phone")
    private String buyerAddrPhone; // 购方地址电话
    @TableField(value="seller_tax_no")
    private String sellerTaxNo; // 销售方纳税人识别号
    @TableField(value="seller_bank_account")
    private String sellerBankAccount; // 销售方开户行账号
    @TableField(value="seller_addr_phone")
    private String sellerAddrPhone; // 销售方地址电话
    @TableField(value="regist_date")
    private java.util.Date registDate; // 收票登记日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="now_contract_mny")
    private java.math.BigDecimal nowContractMny; // 现合同金额不含税
    @TableField(value="now_contract_mny_tax")
    private java.math.BigDecimal nowContractMnyTax; // 现合同金额含税
    @TableField(value="total_settle_mny")
    private java.math.BigDecimal totalSettleMny; // 累计结算金额不含税
    @TableField(value="total_settle_mny_tax")
    private java.math.BigDecimal totalSettleMnyTax; // 累计结算金额含税
    @TableField(value="total_receive_mny")
    private java.math.BigDecimal totalReceiveMny; // 累计收票金额不含税
    @TableField(value="total_receive_mny_tax")
    private java.math.BigDecimal totalReceiveMnyTax; // 累计收票金额含税
    @TableField(value="depend_on_project")
    private Integer dependOnProject; // 是否属于项目
    @TableField(value="invoice_quantity")
    private Integer invoiceQuantity; // 发票数量
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式：1、集采，2、自采

    @TableField(exist = false)
    @SubEntity(pidName = "receiveBillId",serviceName = "invoiceReceivePoolService")
    List<InvoiceReceivePoolEntity> invoiceReceiveList = new ArrayList<>();

    public List<InvoiceReceivePoolEntity> getInvoiceReceiveList() {
        return invoiceReceiveList;
    }

    public void setInvoiceReceiveList(List<InvoiceReceivePoolEntity> invoiceReceiveList) {
        this.invoiceReceiveList = invoiceReceiveList;
    }

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBuyerTaxNo() {
        return buyerTaxNo;
    }

    public void setBuyerTaxNo(String buyerTaxNo) {
        this.buyerTaxNo = buyerTaxNo;
    }

    public String getBuyerBankAccount() {
        return buyerBankAccount;
    }

    public void setBuyerBankAccount(String buyerBankAccount) {
        this.buyerBankAccount = buyerBankAccount;
    }

    public String getBuyerAddrPhone() {
        return buyerAddrPhone;
    }

    public void setBuyerAddrPhone(String buyerAddrPhone) {
        this.buyerAddrPhone = buyerAddrPhone;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 收票类型：1分包收票、2采购售票、3租赁收票，4其他收票
     */
    public Integer getReceiveType() {
        return receiveType;
    }

    /**
     * 收票类型：1分包收票、2采购售票、3租赁收票，4其他收票
     */
    public void setReceiveType(Integer receiveType) {
        this.receiveType = receiveType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 销售方id
     */
    public Long getSellerId() {
        return sellerId;
    }

    /**
     * 销售方id
     */
    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
    /**
     * 销售方名称
     */
    public String getSellerName() {
        return sellerName;
    }

    /**
     * 销售方名称
     */
    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }
    /**
     * 本次收票金额含税
     */
    public java.math.BigDecimal getCurrentReceiveMnyTax() {
        return currentReceiveMnyTax;
    }

    /**
     * 本次收票金额含税
     */
    public void setCurrentReceiveMnyTax(java.math.BigDecimal currentReceiveMnyTax) {
        this.currentReceiveMnyTax = currentReceiveMnyTax;
    }
    /**
     * 本次收票金额不含税
     */
    public java.math.BigDecimal getCurrentReceiveMny() {
        return currentReceiveMny;
    }

    /**
     * 本次收票金额不含税
     */
    public void setCurrentReceiveMny(java.math.BigDecimal currentReceiveMny) {
        this.currentReceiveMny = currentReceiveMny;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 款项类别，1预付款，2，进度款，3其他
     */
    public Integer getMoneyType() {
        return moneyType;
    }

    /**
     * 款项类别，1预付款，2，进度款，3其他
     */
    public void setMoneyType(Integer moneyType) {
        this.moneyType = moneyType;
    }
    /**
     * 经办人id
     */
    public Long getProcessPersonId() {
        return processPersonId;
    }

    /**
     * 经办人id
     */
    public void setProcessPersonId(Long processPersonId) {
        this.processPersonId = processPersonId;
    }
    /**
     * 经办人名称
     */
    public String getProcessPersonName() {
        return processPersonName;
    }

    /**
     * 经办人名称
     */
    public void setProcessPersonName(String processPersonName) {
        this.processPersonName = processPersonName;
    }
    /**
     * 购方id
     */
    public Long getBuyerId() {
        return buyerId;
    }

    /**
     * 购方id
     */
    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }
    /**
     * 购方名称
     */
    public String getBuyerName() {
        return buyerName;
    }

    /**
     * 购方名称
     */
    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }
    /**
     * 销售方纳税人识别号
     */
    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    /**
     * 销售方纳税人识别号
     */
    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }
    /**
     * 销售方开户行账号
     */
    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    /**
     * 销售方开户行账号
     */
    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }
    /**
     * 销售方地址电话
     */
    public String getSellerAddrPhone() {
        return sellerAddrPhone;
    }

    /**
     * 销售方地址电话
     */
    public void setSellerAddrPhone(String sellerAddrPhone) {
        this.sellerAddrPhone = sellerAddrPhone;
    }
    /**
     * 收票登记日期
     */
    public java.util.Date getRegistDate() {
        return registDate;
    }

    /**
     * 收票登记日期
     */
    public void setRegistDate(java.util.Date registDate) {
        this.registDate = registDate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 现合同金额不含税
     */
    public java.math.BigDecimal getNowContractMny() {
        return nowContractMny;
    }

    /**
     * 现合同金额不含税
     */
    public void setNowContractMny(java.math.BigDecimal nowContractMny) {
        this.nowContractMny = nowContractMny;
    }
    /**
     * 现合同金额含税
     */
    public java.math.BigDecimal getNowContractMnyTax() {
        return nowContractMnyTax;
    }

    /**
     * 现合同金额含税
     */
    public void setNowContractMnyTax(java.math.BigDecimal nowContractMnyTax) {
        this.nowContractMnyTax = nowContractMnyTax;
    }
    /**
     * 累计结算金额不含税
     */
    public java.math.BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    /**
     * 累计结算金额不含税
     */
    public void setTotalSettleMny(java.math.BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }
    /**
     * 累计结算金额含税
     */
    public java.math.BigDecimal getTotalSettleMnyTax() {
        return totalSettleMnyTax;
    }

    /**
     * 累计结算金额含税
     */
    public void setTotalSettleMnyTax(java.math.BigDecimal totalSettleMnyTax) {
        this.totalSettleMnyTax = totalSettleMnyTax;
    }
    /**
     * 累计收票金额不含税
     */
    public java.math.BigDecimal getTotalReceiveMny() {
        return totalReceiveMny;
    }

    /**
     * 累计收票金额不含税
     */
    public void setTotalReceiveMny(java.math.BigDecimal totalReceiveMny) {
        this.totalReceiveMny = totalReceiveMny;
    }
    /**
     * 累计收票金额含税
     */
    public java.math.BigDecimal getTotalReceiveMnyTax() {
        return totalReceiveMnyTax;
    }

    /**
     * 累计收票金额含税
     */
    public void setTotalReceiveMnyTax(java.math.BigDecimal totalReceiveMnyTax) {
        this.totalReceiveMnyTax = totalReceiveMnyTax;
    }

    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Integer getInvoiceQuantity() {
        return invoiceQuantity;
    }

    public void setInvoiceQuantity(Integer invoiceQuantity) {
        this.invoiceQuantity = invoiceQuantity;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
}
