package com.ejianc.business.taxnew.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 开票登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_invoice_open_regist")
public class InvoiceOpenRegistEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private String code; // 开票登记单号
    @TableField(value="apply_code")
    private String applyCode; // 申请单号
    @TableField(value="apply_id")
    private Long applyId; // 申请单id
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_type")
    private String contractType; // 合同类型
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id

    @TableField(value="org_name")
    private String orgName; // 组织名称

    @TableField(value="buyer_id")
    private Long buyerId; // 购方id（客户档案）
    @TableField(value="buyer")
    private String buyer; // 购方名称
    @TableField(value="buyer_tax_id")
    private String buyerTaxId; // 购方纳税人识别号
    @TableField(value="buyer_bank_account")
    private String buyerBankAccount; // 购方开户银行及账号
    @TableField(value="buyer_addr_phone")
    private String buyerAddrPhone; // 购方地址及电话
    @TableField(value="seller_id")
    private Long sellerId; // 销售方id(供方档案)
    @TableField(value="seller")
    private String seller; // 销售方名称
    @TableField(value="money_type_id")
    private Long moneyTypeId; // 款项类别id
    @TableField(value="money_type")
    private String moneyType; // 款项类别名称
    @TableField(value="applyer_id")
    private Long applyerId; // 申请人id
    @TableField(value="applyer")
    private String applyer; // 申请人名称
    @TableField(value="apply_date")
    private java.util.Date applyDate; // 申请日期
    @TableField(value="invoice_type")
    private Long invoiceType; // 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
    @TableField(value="apply_mny")
    private java.math.BigDecimal applyMny; // 申请金额（不含税）
    @TableField(value="apply_mny_tax")
    private java.math.BigDecimal applyMnyTax; // 申请金额 含税
    @TableField(value="tax")
    private java.math.BigDecimal tax; // 税金
    @TableField(value="apply_mny_tax_chn")
    private String applyMnyTaxChn; // 申请金额 含税大写
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="now_contract_mny_tax")
    private java.math.BigDecimal nowContractMnyTax; // 现合同金额(含税)
    @TableField(value="now_contract_mny")
    private java.math.BigDecimal nowContractMny; // 现合同金额(不含税)
    @TableField(value="total_quote_mny")
    private java.math.BigDecimal totalQuoteMny; // 累计报量金额
    @TableField(value="total_apply_mny_tax")
    private java.math.BigDecimal totalApplyMnyTax; // 累计已开票申请金额
    @TableField(value="total_open_apply_mny")
    private java.math.BigDecimal totalOpenApplyMny; // 累计已开票申请金额(不含税)
    @TableField(value="total_open_apply_mny_tax")
    private java.math.BigDecimal totalOpenApplyMnyTax; // 累计已开票申请金额(含税)
    @TableField(value="total_open_mny")
    private java.math.BigDecimal totalOpenMny; // 累计已开票金额(不含税)
    @TableField(value="total_open_mny_tax")
    private java.math.BigDecimal totalOpenMnyTax; // 累计已开票金额(含税)
    @TableField(value="total_back_mny")
    private java.math.BigDecimal totalBackMny; // 累计已回款金额(不含税)
    @TableField(value="total_back_mny_tax")
    private java.math.BigDecimal totalBackMnyTax; // 累计回款金额(含税)
    @TableField(value="regist_state")
    private Integer registState;

    @TableField(value="seller_tax_code")
    private String sellerTaxCode; // 销方纳税人识别号
    @TableField(value="seller_bank_account")
    private String sellerBankAccount; // 销售方开户行账号
    @TableField(value="seller_addr_phone")
    private String sellerAddrPhone; // 销售方地址电话

    @TableField(value="regist_date")
    private java.util.Date registDate; // 登记日期

    @TableField(value="regist_user_id")
    private Long registUserId;
    @TableField(value="regist_user_name")
    private String registUserName;
    @TableField(value="regist_dept_name")
    private String registDeptName;
    @TableField(value="invoice_mny")
    private java.math.BigDecimal invoiceMny; // 发票金额（不含税）
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税金
    @TableField(value="invoice_tax_mny")
    private java.math.BigDecimal invoiceTaxMny; // 价税合计
    @TableField(value="regist_open_type")
    private Integer registOpenType;//登记类型 1--有申请0--无登记
    @TableField(value="has_contract")
    private Integer hasContract; // 是否有合同 1--有 2--没有
    @TableField(value="invoice_auantity")
    private Integer invoiceAuantity;//发票数量
    @TableField(value="project_address")
    private String projectAddress; // 项目地址
    @TableField(exist=false)
    private List<InvoiceOpenPoolEntity> contractItemList = new ArrayList<>();

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 开票登记单号
     */
    public String getCode() {
        return code;
    }

    /**
     * 开票登记单号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 申请单号
     */
    public String getApplyCode() {
        return applyCode;
    }

    /**
     * 申请单号
     */
    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }
    /**
     * 申请单id
     */
    public Long getApplyId() {
        return applyId;
    }

    /**
     * 申请单id
     */
    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同类型
     */
    public String getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 购方id（客户档案）
     */
    public Long getBuyerId() {
        return buyerId;
    }

    /**
     * 购方id（客户档案）
     */
    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }
    /**
     * 购方名称
     */
    public String getBuyer() {
        return buyer;
    }

    /**
     * 购方名称
     */
    public void setBuyer(String buyer) {
        this.buyer = buyer;
    }
    /**
     * 购方纳税人识别号
     */
    public String getBuyerTaxId() {
        return buyerTaxId;
    }

    /**
     * 购方纳税人识别号
     */
    public void setBuyerTaxId(String buyerTaxId) {
        this.buyerTaxId = buyerTaxId;
    }
    /**
     * 购方开户银行及账号
     */
    public String getBuyerBankAccount() {
        return buyerBankAccount;
    }

    /**
     * 购方开户银行及账号
     */
    public void setBuyerBankAccount(String buyerBankAccount) {
        this.buyerBankAccount = buyerBankAccount;
    }
    /**
     * 购方地址及电话
     */
    public String getBuyerAddrPhone() {
        return buyerAddrPhone;
    }

    /**
     * 购方地址及电话
     */
    public void setBuyerAddrPhone(String buyerAddrPhone) {
        this.buyerAddrPhone = buyerAddrPhone;
    }
    /**
     * 销售方id(供方档案)
     */
    public Long getSellerId() {
        return sellerId;
    }

    /**
     * 销售方id(供方档案)
     */
    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
    /**
     * 销售方名称
     */
    public String getSeller() {
        return seller;
    }

    /**
     * 销售方名称
     */
    public void setSeller(String seller) {
        this.seller = seller;
    }
    /**
     * 款项类别id
     */
    public Long getMoneyTypeId() {
        return moneyTypeId;
    }

    /**
     * 款项类别id
     */
    public void setMoneyTypeId(Long moneyTypeId) {
        this.moneyTypeId = moneyTypeId;
    }
    /**
     * 款项类别名称
     */
    public String getMoneyType() {
        return moneyType;
    }

    /**
     * 款项类别名称
     */
    public void setMoneyType(String moneyType) {
        this.moneyType = moneyType;
    }
    /**
     * 申请人id
     */
    public Long getApplyerId() {
        return applyerId;
    }

    /**
     * 申请人id
     */
    public void setApplyerId(Long applyerId) {
        this.applyerId = applyerId;
    }
    /**
     * 申请人名称
     */
    public String getApplyer() {
        return applyer;
    }

    /**
     * 申请人名称
     */
    public void setApplyer(String applyer) {
        this.applyer = applyer;
    }
    /**
     * 申请日期
     */
    public java.util.Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(java.util.Date applyDate) {
        this.applyDate = applyDate;
    }

    /**
     * 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public Long getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    /**
     * 申请金额（不含税）
     */
    public java.math.BigDecimal getApplyMny() {
        return applyMny;
    }

    /**
     * 申请金额（不含税）
     */
    public void setApplyMny(java.math.BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    /**
     * 申请金额 含税
     */
    public java.math.BigDecimal getApplyMnyTax() {
        return applyMnyTax;
    }

    /**
     * 申请金额 含税
     */
    public void setApplyMnyTax(java.math.BigDecimal applyMnyTax) {
        this.applyMnyTax = applyMnyTax;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTax() {
        return tax;
    }

    /**
     * 税金
     */
    public void setTax(java.math.BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 申请金额 含税大写
     */
    public String getApplyMnyTaxChn() {
        return applyMnyTaxChn;
    }

    /**
     * 申请金额 含税大写
     */
    public void setApplyMnyTaxChn(String applyMnyTaxChn) {
        this.applyMnyTaxChn = applyMnyTaxChn;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 现合同金额(含税)
     */
    public java.math.BigDecimal getNowContractMnyTax() {
        return nowContractMnyTax;
    }

    /**
     * 现合同金额(含税)
     */
    public void setNowContractMnyTax(java.math.BigDecimal nowContractMnyTax) {
        this.nowContractMnyTax = nowContractMnyTax;
    }
    /**
     * 现合同金额(不含税)
     */
    public java.math.BigDecimal getNowContractMny() {
        return nowContractMny;
    }

    /**
     * 现合同金额(不含税)
     */
    public void setNowContractMny(java.math.BigDecimal nowContractMny) {
        this.nowContractMny = nowContractMny;
    }

    public BigDecimal getTotalQuoteMny() {
        return totalQuoteMny;
    }

    public void setTotalQuoteMny(BigDecimal totalQuoteMny) {
        this.totalQuoteMny = totalQuoteMny;
    }

    public BigDecimal getTotalApplyMnyTax() {
        return totalApplyMnyTax;
    }

    public void setTotalApplyMnyTax(BigDecimal totalApplyMnyTax) {
        this.totalApplyMnyTax = totalApplyMnyTax;
    }

    /**
     * 累计已开票申请金额(不含税)
     */
    public java.math.BigDecimal getTotalOpenApplyMny() {
        return totalOpenApplyMny;
    }

    /**
     * 累计已开票申请金额(不含税)
     */
    public void setTotalOpenApplyMny(java.math.BigDecimal totalOpenApplyMny) {
        this.totalOpenApplyMny = totalOpenApplyMny;
    }
    /**
     * 累计已开票申请金额(含税)
     */
    public java.math.BigDecimal getTotalOpenApplyMnyTax() {
        return totalOpenApplyMnyTax;
    }

    /**
     * 累计已开票申请金额(含税)
     */
    public void setTotalOpenApplyMnyTax(java.math.BigDecimal totalOpenApplyMnyTax) {
        this.totalOpenApplyMnyTax = totalOpenApplyMnyTax;
    }
    /**
     * 累计已开票金额(不含税)
     */
    public java.math.BigDecimal getTotalOpenMny() {
        return totalOpenMny;
    }

    /**
     * 累计已开票金额(不含税)
     */
    public void setTotalOpenMny(java.math.BigDecimal totalOpenMny) {
        this.totalOpenMny = totalOpenMny;
    }
    /**
     * 累计已开票金额(含税)
     */
    public java.math.BigDecimal getTotalOpenMnyTax() {
        return totalOpenMnyTax;
    }

    /**
     * 累计已开票金额(含税)
     */
    public void setTotalOpenMnyTax(java.math.BigDecimal totalOpenMnyTax) {
        this.totalOpenMnyTax = totalOpenMnyTax;
    }
    /**
     * 累计已回款金额(不含税)
     */
    public java.math.BigDecimal getTotalBackMny() {
        return totalBackMny;
    }

    /**
     * 累计已回款金额(不含税)
     */
    public void setTotalBackMny(java.math.BigDecimal totalBackMny) {
        this.totalBackMny = totalBackMny;
    }
    /**
     * 累计回款金额(含税)
     */
    public java.math.BigDecimal getTotalBackMnyTax() {
        return totalBackMnyTax;
    }

    /**
     * 累计回款金额(含税)
     */
    public void setTotalBackMnyTax(java.math.BigDecimal totalBackMnyTax) {
        this.totalBackMnyTax = totalBackMnyTax;
    }

    public Integer getRegistState() {
        return registState;
    }

    public void setRegistState(Integer registState) {
        this.registState = registState;
    }

    public String getSellerTaxCode() {
        return sellerTaxCode;
    }

    public void setSellerTaxCode(String sellerTaxCode) {
        this.sellerTaxCode = sellerTaxCode;
    }

    public Date getRegistDate() {
        return registDate;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }

    public Long getRegistUserId() {
        return registUserId;
    }

    public void setRegistUserId(Long registUserId) {
        this.registUserId = registUserId;
    }

    public String getRegistUserName() {
        return registUserName;
    }

    public void setRegistUserName(String registUserName) {
        this.registUserName = registUserName;
    }

    public List<InvoiceOpenPoolEntity> getContractItemList() {
        return contractItemList;
    }

    public void setContractItemList(List<InvoiceOpenPoolEntity> contractItemList) {
        this.contractItemList = contractItemList;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }

    public Integer getRegistOpenType() {
        return registOpenType;
    }

    public void setRegistOpenType(Integer registOpenType) {
        this.registOpenType = registOpenType;
    }

    public Integer getHasContract() {
        return hasContract;
    }

    public void setHasContract(Integer hasContract) {
        this.hasContract = hasContract;
    }

    public Integer getInvoiceAuantity() {
        return invoiceAuantity;
    }

    public void setInvoiceAuantity(Integer invoiceAuantity) {
        this.invoiceAuantity = invoiceAuantity;
    }

    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }

    public String getSellerAddrPhone() {
        return sellerAddrPhone;
    }

    public void setSellerAddrPhone(String sellerAddrPhone) {
        this.sellerAddrPhone = sellerAddrPhone;
    }

    public String getRegistDeptName() {
        return registDeptName;
    }

    public void setRegistDeptName(String registDeptName) {
        this.registDeptName = registDeptName;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
}
