package com.ejianc.business.taxnew.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.PayInvoiceUseVO;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.taxnew.vo.InvoiceReceivePoolVO;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 进项发票池
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("invoiceReceivePool")
public class InvoiceReceivePoolController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "tax-receive-pool-001";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IInvoiceReceivePoolService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IInvoiceReceiveRegistService registService;


    @Autowired
    private IPayContractApi payContractApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceReceivePoolVO> saveOrUpdate(@RequestBody InvoiceReceivePoolVO saveorUpdateVO) {
        InvoiceReceivePoolEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceReceivePoolEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdateNoES(entity);
        InvoiceReceivePoolVO vo = BeanMapper.map(entity, InvoiceReceivePoolVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceivePoolVO> queryDetail(Long id) {
        InvoiceReceivePoolEntity entity = service.selectById(id);
        InvoiceReceivePoolVO vo = BeanMapper.map(entity, InvoiceReceivePoolVO.class);
        if (vo.getReceiveBillId() != null) {
            InvoiceReceiveRegistVO info = BeanMapper.map(registService.selectById(vo.getReceiveBillId()), InvoiceReceiveRegistVO.class);
            vo.setReceiveRegistInfo(info);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceivePoolVO> vos) {
        service.removeByIds(vos.stream().map(InvoiceReceivePoolVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("invoiceCode");

        param.getFuzzyFields().add("invoiceNumber");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("receiveBillCode");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("customerName");


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 收票单不为空 */
        param.getParams().put("receiveBillId", new Parameter(QueryParam.NE, null));
        /** 数据隔离 本下 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if (param.getParams().get("hasMyRegist") != null) {
            if (param.getParams().get("hasMyRegist").getValue().equals("1")) {
                param.getParams().put("employeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            } else if (param.getParams().get("hasMyRegist").getValue().equals("0")) {
                param.getParams().put("employeeId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");

        }
        IPage<InvoiceReceivePoolEntity> page = service.queryPage(param, false);
        IPage<InvoiceReceivePoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<InvoiceReceivePoolVO> invoiceReceivePoolVOS = BeanMapper.mapList(page.getRecords(), InvoiceReceivePoolVO.class);
        if (CollectionUtils.isNotEmpty(invoiceReceivePoolVOS)) {
            List<Long> invoiceIds = invoiceReceivePoolVOS.stream().map(InvoiceReceivePoolVO::getId).collect(Collectors.toList());
            PayInvoiceUseVO payInvoiceUseVO = new PayInvoiceUseVO();
            payInvoiceUseVO.setInvoiceIds(invoiceIds);
            CommonResponse<List<PayInvoiceUseVO>> listCommonResponse = payContractApi.countUseNum(payInvoiceUseVO);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
                List<PayInvoiceUseVO> payInvoiceUseVOList = listCommonResponse.getData();
                Map<Long, Integer> map = payInvoiceUseVOList.stream().collect(Collectors.toMap(PayInvoiceUseVO::getInvoiceId, PayInvoiceUseVO::getInvoiceBillNum));
                invoiceReceivePoolVOS.forEach(t -> t.setInvoiceBillNum(map.get(t.getId())));
            }
        }
        pageData.setRecords(invoiceReceivePoolVOS);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description queryList 查询列表()
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryAlreadyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> queryAlreadyList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("invoiceCode");
        param.getFuzzyFields().add("invoiceNumber");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("receiveBillCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 收票单不为空 */
        param.getParams().put("receiveBillId", new Parameter(QueryParam.NE, null));
        /** 数据隔离 本下 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if (param.getParams().get("authState") == null) {
            param.getParams().put("authState", new Parameter(QueryParam.IN, "1,2"));
        }
        IPage<InvoiceReceivePoolEntity> page = service.queryPage(param, false);
        IPage<InvoiceReceivePoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceivePoolVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "/refInvoiceReceivePoolData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> refInvoiceReceivePoolData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 收票单不为空 */
        param.getParams().put("receiveBillId", new Parameter(QueryParam.NE, null));


        if (StringUtils.isNotEmpty(condition)) {
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.getLong("projectId") != null) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.getLong("projectId")));
            }
            if (_con.getLong("invoiceType") != null) {
                param.getParams().put("invoiceType", new Parameter(QueryParam.EQ, _con.getLong("invoiceType")));
            }
            if (_con.getBoolean("regist") != null) {
                param.getParams().put("regist", new Parameter(QueryParam.EQ, _con.getBoolean("regist")));
            }
            if (_con.getLong("flag") != null) {
                param.getParams().put("flag", new Parameter(QueryParam.EQ, _con.getLong("flag")));
            }
            if (_con.getLong("deductionBillId") != null) {
                ComplexParam complexParam = new ComplexParam();
                complexParam.setLogic(ComplexParam.OR);
                complexParam.getParams().put("deductionBillId", new Parameter(QueryParam.EQ, _con.getLong("deductionBillId")));
                param.getComplexParams().add(complexParam);
            }
        } else {
            /** 数据隔离 本下 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<InvoiceReceivePoolEntity> page = service.queryPage(param);
        IPage<InvoiceReceivePoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceivePoolVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description authBatch 发票批量手动认证
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/authBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> authBatch(@RequestBody JSONObject info) {
        if (info == null || info.getJSONArray("ids") == null
                || info.getString("periodOfTax") == null
                || info.getString("authDate") == null
                || info.getString("authState") == null
                || info.getString("authPerson") == null) {
            return CommonResponse.error("非法参数");
        }
        List<Long> ids = Arrays.stream(info.getJSONArray("ids").toArray()).map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
        String periodOfTax = info.getString("periodOfTax");
        String authDate = info.getString("authDate");
        Integer authState = info.getInteger("authState");
        String authPerson = info.getString("authPerson");
        service.authBatch(ids, periodOfTax + "-01", authDate, authState, authPerson);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description authBatch 发票批量手动取消认证
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/noAuthBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> noAuthBatch(@RequestBody List<Long> ids) {
        if (ListUtil.isEmpty(ids)) {
            return CommonResponse.error("参数不能为空！");
        }
        service.noAuthBatch(ids);
        return CommonResponse.success("操作成功！");
    }

    /**
     * 导出
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {

        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("receiveBillCode");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<InvoiceReceivePoolEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceReceivePoolVO> voList = new ArrayList<InvoiceReceivePoolVO>();

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceivePoolVO r = BeanMapper.map(pool, InvoiceReceivePoolVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                if (r.getAuthState() != null) {
                    switch (r.getAuthState()) {
                        case 0:
                            r.setAuthStateName("未认证");
                            break;
                        case 1:
                            r.setAuthStateName("认证成功");
                            break;
                        case 2:
                            r.setAuthStateName("认证失败");
                            break;
                        default:
                            break;
                    }
                }

                if (r.getDeductionState() != null) {
                    switch (r.getDeductionState()) {
                        case 0:
                            r.setDeductionStateName("未抵扣");
                            break;
                        case 1:
                            r.setDeductionStateName("已抵扣");
                            break;
                        default:
                            break;
                    }
                }
                voList.add(r);
            });
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceReceivePool-export.xlsx", beans, response);
    }

    /**
     * 导出（认证发票）
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelAuthExport")
    public void excelAuthExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {

        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("receiveBillCode");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<InvoiceReceivePoolEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceReceivePoolVO> voList = new ArrayList<InvoiceReceivePoolVO>();

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceivePoolVO r = BeanMapper.map(pool, InvoiceReceivePoolVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());

                voList.add(r);
            });
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceReceivePool-auth-export.xlsx", beans, response);
    }

    /**
     * 导出（未认证发票）
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelNotAuthExport")
    public void excelNotAuthExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {

        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("receiveBillCode");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<InvoiceReceivePoolEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceReceivePoolVO> voList = new ArrayList<InvoiceReceivePoolVO>();

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceivePoolVO r = BeanMapper.map(pool, InvoiceReceivePoolVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                if (r.getAuthState() != null) {
                    switch (r.getAuthState()) {
                        case 0:
                            r.setAuthStateName("未认证");
                            break;
                        case 1:
                            r.setAuthStateName("认证成功");
                            break;
                        case 2:
                            r.setAuthStateName("认证失败");
                            break;
                        default:
                            break;
                    }
                }

                if (r.getDeductionState() != null) {
                    switch (r.getDeductionState()) {
                        case 0:
                            r.setDeductionStateName("未抵扣");
                            break;
                        case 1:
                            r.setDeductionStateName("已抵扣");
                            break;
                        default:
                            break;
                    }
                }

                voList.add(r);
            });
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceReceivePool-not-auth-export.xlsx", beans, response);
    }

    /**
     * 统计合同本次申请金额
     * @return
     */
    @RequestMapping(value = "/querySumMnyTax", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> querySumMnyTax(Long contractId) {
        Map<String, BigDecimal> map = service.querySumMnyTax(contractId);
        return CommonResponse.success("查询累发票金额成功！", map);
    }


    /**
     * 导出(报表)
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelReportExport")
    public void excelReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {

        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("receiveBillCode");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("receiveBillId", new Parameter(QueryParam.NE, null));
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<InvoiceReceivePoolEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceReceivePoolVO> voList = new ArrayList<InvoiceReceivePoolVO>();

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceReceivePoolVO r = BeanMapper.map(pool, InvoiceReceivePoolVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                if (r.getAuthState() != null) {
                    switch (r.getAuthState()) {
                        case 0:
                            r.setAuthStateName("未认证");
                            break;
                        case 1:
                            r.setAuthStateName("认证成功");
                            break;
                        case 2:
                            r.setAuthStateName("认证失败");
                            break;
                        default:
                            break;
                    }
                }
                if (r.getDeductionState() != null) {
                    switch (r.getDeductionState()) {
                        case 0:
                            r.setDeductionStateName("未抵扣");
                            break;
                        case 1:
                            r.setDeductionStateName("已抵扣");
                            break;
                        default:
                            break;
                    }
                }

                voList.add(r);
            });
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("reportReceivePool-export.xlsx", beans, response);
    }
}
