package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.tax.mapper.InvoiceOpenMapper;
import com.ejianc.business.tax.utils.ConvertUpMoney;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceOpenRegistMapper;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

/**
 * 开票登记
 *
 * @author generator
 *
 */
@Service("invoiceOpenRegistService")
public class InvoiceOpenRegistServiceImpl extends BaseServiceImpl<InvoiceOpenRegistMapper, InvoiceOpenRegistEntity> implements IInvoiceOpenRegistService {
    @Autowired
    private IInvoiceOpenPoolService invoiceOpenPoolService;
    @Autowired
    private IInvoiceOpenApplyService invoiceOpenApplyService;
    @Autowired
    private IBillCodeApi billCodeApi;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Lock lock = new ReentrantLock(true);
    private static final String BILL_CODE = "tax-open-regist-001";
    private static final String BILL_POOL_CODE = "tax-open-pool-001";

    // 开票登记 管控参数
    private static final String CHEC_INVOICE_OPEN_CODE = "P-jyh01v35";

    //收票登记 发票代码
    private static final String configCodeDm = "TAX_FPDM";
    //收票登记 发票号码
    private static final String configCodeHm = "TAX_FPHM";

    @Autowired
    private InvoiceOpenRegistMapper invoiceOpenRegistMapper;

    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IIncomeContractApi iIncomeContractApi;
    @Autowired
    private InvoiceOpenMapper invoiceOpenMapper;

    /**
     * 根据开票申请保存到开票登记
     * @param invoiceOpenApplyEntity
     */
    @Transactional
    public void save(InvoiceOpenApplyEntity invoiceOpenApplyEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("dr", "0");
        queryWrapper.eq("apply_id", invoiceOpenApplyEntity.getId());
        List<InvoiceOpenApplyEntity> invoiceOpenApplyList = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(invoiceOpenApplyList)) {
            throw new BusinessException("不可以重复提交");
        }
        InvoiceOpenRegistEntity registEntity = new InvoiceOpenRegistEntity();
        registEntity.setApplyCode(invoiceOpenApplyEntity.getCode());
        registEntity.setApplyDate(invoiceOpenApplyEntity.getApplyDate());
        registEntity.setApplyer(invoiceOpenApplyEntity.getApplyer());
        registEntity.setApplyerId(invoiceOpenApplyEntity.getApplyerId());
        registEntity.setApplyMny(invoiceOpenApplyEntity.getApplyMny());
        registEntity.setApplyMnyTaxChn(invoiceOpenApplyEntity.getApplyMnyTaxChn());
        registEntity.setApplyMnyTax(invoiceOpenApplyEntity.getApplyMnyTax());
        registEntity.setBuyerAddrPhone(invoiceOpenApplyEntity.getBuyerAddrPhone());
        registEntity.setBuyerBankAccount(invoiceOpenApplyEntity.getBuyerBankAccount());
        registEntity.setBuyerId(invoiceOpenApplyEntity.getBuyerId());
        registEntity.setBuyer(invoiceOpenApplyEntity.getBuyer());
        registEntity.setApplyId(invoiceOpenApplyEntity.getId());
        registEntity.setBuyerTaxId(invoiceOpenApplyEntity.getBuyerTaxId());
        registEntity.setContractId(invoiceOpenApplyEntity.getContractId());
        registEntity.setContractName(invoiceOpenApplyEntity.getContractName());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        //registEntity.setInvoiceType(Integer.valueOf(invoiceOpenApplyEntity.getInvoiceTypes()));
        registEntity.setMoneyType(invoiceOpenApplyEntity.getMoneyType());
        registEntity.setMoneyTypeId(invoiceOpenApplyEntity.getMoneyTypeId());
        registEntity.setOrgId(invoiceOpenApplyEntity.getOrgId());
        registEntity.setOrgName(invoiceOpenApplyEntity.getOrgName());
        registEntity.setProjectId(invoiceOpenApplyEntity.getProjectId());
        registEntity.setProjectName(invoiceOpenApplyEntity.getProjectName());
        registEntity.setSellerId(invoiceOpenApplyEntity.getSellerId());
        registEntity.setSeller(invoiceOpenApplyEntity.getSeller());
        registEntity.setSellerTaxCode(invoiceOpenApplyEntity.getSellerTaxCode());
        registEntity.setSellerAddrPhone(invoiceOpenApplyEntity.getSellerAddrPhone());
        registEntity.setSellerBankAccount(invoiceOpenApplyEntity.getSellerBankAccount());
        registEntity.setTax(invoiceOpenApplyEntity.getTax());
        registEntity.setRegistOpenType(1);//有申请
        registEntity.setRegistState(0);//待登记
        registEntity.setHasContract(invoiceOpenApplyEntity.getHasContract()); //是否有合同
        registEntity.setNowContractMny(invoiceOpenApplyEntity.getNowContractMny());
        registEntity.setTotalQuoteMny(invoiceOpenApplyEntity.getTotalQuoteMny());
        registEntity.setTotalOpenApplyMnyTax(invoiceOpenApplyEntity.getTotalOpenApplyMnyTax());
        registEntity.setTotalOpenMny(invoiceOpenApplyEntity.getTotalOpenMny());
        registEntity.setTotalBackMnyTax(invoiceOpenApplyEntity.getTotalBackMnyTax());
        registEntity.setContractType(invoiceOpenApplyEntity.getContractType());
        // 初始化申请金额 税额 等数据
        registEntity.setTaxMny(invoiceOpenApplyEntity.getTaxAmount() == null ? BigDecimal.ZERO : invoiceOpenApplyEntity.getTaxAmount());
        registEntity.setInvoiceTaxMny(invoiceOpenApplyEntity.getApplyMnyTax() == null ? BigDecimal.ZERO : invoiceOpenApplyEntity.getApplyMnyTax());
        registEntity.setInvoiceMny(registEntity.getInvoiceTaxMny().subtract(registEntity.getTaxMny()));

        // 初始化登记人 登记时间，部门
        registEntity.setRegistDate(invoiceOpenApplyEntity.getApplyDate());
        registEntity.setRegistUserId(invoiceOpenApplyEntity.getApplyerId());
        registEntity.setRegistUserName(invoiceOpenApplyEntity.getApplyer());
        registEntity.setRegistDeptName(invoiceOpenApplyEntity.getAppDeptName());
        //项目地址
        registEntity.setProjectAddress(invoiceOpenApplyEntity.getProjectAddress());

        String billCode = getBillCode(BILL_CODE);
        registEntity.setCode(billCode);
        super.save(registEntity);
        invoiceOpenPoolService.createSave(invoiceOpenApplyEntity);
    }

    /**
     * 保存（同时添加到发票池中）
     * @param invoiceOpenRegistEntity
     */
    @Transactional
    public InvoiceOpenRegistEntity saveOrUpdatePool(InvoiceOpenRegistEntity invoiceOpenRegistEntity) {
        lock.lock();
        try {
            List<InvoiceOpenPoolEntity> invoiceOpenPoolEntities = new ArrayList<InvoiceOpenPoolEntity>();
            if (CollectionUtils.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())) {

                CommonResponse<List<DefdocDetailVO>> defList = defdocApi.getDefDocByDefCode("tax-invoice-type");
                Map<String, String> defMap = getDefMap(defList.getData());
                List<InvoiceOpenPoolEntity> invoiceOpenPoolList = invoiceOpenRegistEntity.getContractItemList();
                checkPool(invoiceOpenPoolList);
                int invoiceAuantity = invoiceOpenPoolList.size();

                for (InvoiceOpenPoolEntity entity : invoiceOpenPoolList) {
                    if ("del".equals(entity.getRowState())) {
                        invoiceAuantity--;
                    }
                }

                if (invoiceOpenRegistEntity.getRegistDate() == null) {
                    invoiceOpenRegistEntity.setRegistDate(new Date());
                }

                invoiceOpenRegistEntity.setInvoiceAuantity(invoiceAuantity);
                invoiceOpenRegistEntity.setRegistState(0);

                //后期加参数在控制
                if (invoiceOpenRegistEntity.getId() != null) {
                    //有开票申请
                    super.saveOrUpdate(invoiceOpenRegistEntity);

                } else {

                    String billCode = getBillCode(BILL_CODE);
                    invoiceOpenRegistEntity.setCode(billCode);
                    //无开票申请直接保存
                    super.saveOrUpdate(invoiceOpenRegistEntity);
                }

                for (InvoiceOpenPoolEntity pool : invoiceOpenPoolList) {
                    if (invoiceOpenRegistEntity.getApplyId() != null) {
                        pool.setOpenApplyType(1);//有申请
                        pool.setApplyCode(invoiceOpenRegistEntity.getApplyCode());
                        pool.setApplyId(invoiceOpenRegistEntity.getApplyId());
                        pool.setApplyMnyTax(invoiceOpenRegistEntity.getApplyMnyTax());
                    }

                    pool.setType(invoiceOpenRegistEntity.getHasContract());
                    pool.setOpenApplyType(invoiceOpenRegistEntity.getRegistOpenType());
                    pool.setContractId(invoiceOpenRegistEntity.getContractId());
                    pool.setContractName(invoiceOpenRegistEntity.getContractName());
                    pool.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
                    pool.setCustomerName(invoiceOpenRegistEntity.getBuyer());
                    pool.setCustomerCreditCode(invoiceOpenRegistEntity.getBuyerTaxId());
                    pool.setEmployeeId(invoiceOpenRegistEntity.getRegistUserId());
                    pool.setEmployeeName(invoiceOpenRegistEntity.getRegistUserName());
                    pool.setOrgId(invoiceOpenRegistEntity.getOrgId());
                    pool.setOrgName(invoiceOpenRegistEntity.getOrgName());
                    pool.setProjectId(invoiceOpenRegistEntity.getProjectId());
                    pool.setProjectName(invoiceOpenRegistEntity.getProjectName());
                    pool.setRegistId(invoiceOpenRegistEntity.getId());
                    pool.setRegistCode(invoiceOpenRegistEntity.getCode());
                    pool.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
                    pool.setSupplierName(invoiceOpenRegistEntity.getSeller());
                    pool.setSupplierId(invoiceOpenRegistEntity.getSellerId());
                    pool.setType(invoiceOpenRegistEntity.getHasContract());
                    pool.setMoneyTypeId(invoiceOpenRegistEntity.getMoneyTypeId());
                    pool.setBuyerAddrPhone(invoiceOpenRegistEntity.getBuyerAddrPhone());
                    pool.setBuyerBankAccount(invoiceOpenRegistEntity.getBuyerBankAccount());
                    pool.setSellerAddrPhone(invoiceOpenRegistEntity.getSellerAddrPhone());
                    pool.setSellerBankAccount(invoiceOpenRegistEntity.getSellerBankAccount());
                    pool.setInvoiceTypeName(defMap.get(pool.getInvoiceType() + ""));
                    pool.setRegist(0); //未生效
                    if (StringUtils.isNotEmpty(pool.getRowState()) && "del".equals(pool.getRowState())) {
                        invoiceOpenPoolService.removeById(pool.getId());
                    } else if (StringUtils.isEmpty(pool.getRowState()) || "edit".equals(pool.getRowState())) {
                        invoiceOpenPoolService.saveOrUpdate(pool);
                        invoiceOpenPoolEntities.add(pool);
                    } else if (StringUtils.isNotEmpty(pool.getRowState()) && "add".equals(pool.getRowState())) {
                        String billCode = getBillCode(BILL_POOL_CODE);
                        pool.setBillCode(billCode);
                        invoiceOpenPoolService.saveOrUpdate(pool);
                        invoiceOpenPoolEntities.add(pool);
                    }
                }

                invoiceOpenRegistEntity.setContractItemList(invoiceOpenPoolEntities);

            } else {
                //throw new BusinessException("发票信息不能为空");

                String billCode = getBillCode(BILL_CODE);
                invoiceOpenRegistEntity.setCode(billCode);
                if (invoiceOpenRegistEntity.getRegistDate() == null) {
                    invoiceOpenRegistEntity.setRegistDate(new Date());
                }
                invoiceOpenRegistEntity.setRegistState(0);
                invoiceOpenRegistEntity.setInvoiceAuantity(0);
                super.saveOrUpdate(invoiceOpenRegistEntity);
            }

        } finally {
            lock.unlock(); //释放锁
        }

        return invoiceOpenRegistEntity;
    }

    public List<InvoiceOpenPoolEntity> generateInvoiceOpenPool(InvoiceOpenRegistEntity invoiceOpenRegistEntity) {
        InvoiceOpenPoolEntity poolEntity = new InvoiceOpenPoolEntity();


        poolEntity.setId(null);
        poolEntity.setRegistId(invoiceOpenRegistEntity.getId());
        poolEntity.setRegistCode(invoiceOpenRegistEntity.getCode());
        //originType为0 是默认生成
        poolEntity.setOriginType(0);
        poolEntity.setBillCode(invoiceOpenRegistEntity.getCode());
        CommonResponse<List<DefdocDetailVO>> defList = defdocApi.getDefDocByDefCode("tax-invoice-type");
        Map<String, String> defMap = getDefMapName(defList.getData());

        poolEntity.setInvoiceCode(getBillCode(configCodeDm));
        poolEntity.setInvoiceNumber(getBillCode(configCodeHm));
        poolEntity.setInvoiceDate(new Date());
        poolEntity.setInvoiceMny(invoiceOpenRegistEntity.getInvoiceMny());
        poolEntity.setTaxMny(invoiceOpenRegistEntity.getTaxMny());
        poolEntity.setInvoiceTaxMny(ComputeUtil.safeAdd(poolEntity.getInvoiceMny(), poolEntity.getTaxMny()));
        //金额转中文大写
        //整数
        if (new BigDecimal(poolEntity.getInvoiceTaxMny().intValue()).compareTo(poolEntity.getInvoiceTaxMny()) == 0) {
            poolEntity.setInvoiceTaxMnyChn(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString()) + "整");
        } else {
            poolEntity.setInvoiceTaxMnyChn(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString()));
        }

        poolEntity.setType(invoiceOpenRegistEntity.getHasContract());
        poolEntity.setOpenApplyType(invoiceOpenRegistEntity.getRegistOpenType());
        poolEntity.setContractId(invoiceOpenRegistEntity.getContractId());
        poolEntity.setContractName(invoiceOpenRegistEntity.getContractName());
        poolEntity.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
        poolEntity.setCustomerName(invoiceOpenRegistEntity.getBuyer());
        poolEntity.setCustomerCreditCode(invoiceOpenRegistEntity.getBuyerTaxId());
        poolEntity.setEmployeeId(invoiceOpenRegistEntity.getRegistUserId());
        poolEntity.setEmployeeName(invoiceOpenRegistEntity.getRegistUserName());
        poolEntity.setOrgId(invoiceOpenRegistEntity.getOrgId());
        poolEntity.setOrgName(invoiceOpenRegistEntity.getOrgName());
        poolEntity.setProjectId(invoiceOpenRegistEntity.getProjectId());
        poolEntity.setProjectName(invoiceOpenRegistEntity.getProjectName());
        poolEntity.setRegistId(invoiceOpenRegistEntity.getId());
        poolEntity.setRegistCode(invoiceOpenRegistEntity.getCode());
        poolEntity.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
        poolEntity.setSupplierName(invoiceOpenRegistEntity.getSeller());
        poolEntity.setSupplierId(invoiceOpenRegistEntity.getSellerId());
        poolEntity.setType(invoiceOpenRegistEntity.getHasContract());
        poolEntity.setMoneyTypeId(invoiceOpenRegistEntity.getMoneyTypeId());
        poolEntity.setBuyerAddrPhone(invoiceOpenRegistEntity.getBuyerAddrPhone());
        poolEntity.setBuyerBankAccount(invoiceOpenRegistEntity.getBuyerBankAccount());
        poolEntity.setSellerAddrPhone(invoiceOpenRegistEntity.getSellerAddrPhone());
        poolEntity.setSellerBankAccount(invoiceOpenRegistEntity.getSellerBankAccount());

        String invoiceType = defMap.get("其他");
        if (net.logstash.logback.encoder.org.apache.commons.lang.StringUtils.isNotEmpty(invoiceType)) {
            poolEntity.setInvoiceType(Long.valueOf(invoiceType));
            poolEntity.setInvoiceTypeName("其他");
        } else {
            throw new BusinessException("网络异常， 发票类型获取失败");
        }
        poolEntity.setRegist(0); //未生效
        List<InvoiceOpenPoolEntity> list = new ArrayList<>();
        list.add(poolEntity);
        //校验重复
        checkPool(list);
        return list;
    }

    /**
     * 获取billCode
     * @return
     */
    public String getBillCode(String code) {
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            return billCode.getData();
        } else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }

    /**
     * 根据id查询带出 发票池数据
     * @param id
     * @return
     */
    public InvoiceOpenRegistEntity selectByIdAll(Long id) {
        InvoiceOpenRegistEntity entity = this.getById(id);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("regist_id", id);
        queryWrapper.eq("dr", 0);
        List<InvoiceOpenPoolEntity> list = invoiceOpenPoolService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            entity.setContractItemList(list);
        }
        return entity;
    }

    /**
     * 根据申请id查询一条数据
     * @param applyId
     * @return
     */
    public InvoiceOpenRegistEntity selectOpenRegistByApplyId(Long applyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("apply_id", applyId);
        queryWrapper.in("bill_state", 1, 3);
        InvoiceOpenRegistEntity entity = invoiceOpenRegistMapper.selectOne(queryWrapper);
        if (entity != null) {
            QueryParam param = new QueryParam();
            param.getParams().put("registId", new Parameter(QueryParam.EQ, entity.getId()));
            List<InvoiceOpenPoolEntity> list = invoiceOpenPoolService.queryList(param);
            if (CollectionUtils.isNotEmpty(list)) {
                entity.setContractItemList(list);
            }
        }
        return entity;
    }

    /**
     * 处理Excel日期格式问题
     * @param date
     * @return
     */
    public String excelDoubleToDate(String date) {
        if (date.length() == 5) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date tDate = DoubleToDate(Double.parseDouble(date));
                return sdf.format(tDate);
            } catch (Exception e) {
                e.printStackTrace();
                return date;
            }
        }
        return date;
    }

    /**
     * 根据合同id统计发票金额
     * @param contractId
     * @return
     */
    public Map<String, BigDecimal> selectSumInvoiceMny(Long contractId) {
        Map<String, BigDecimal> resp = new HashMap<>();
        QueryWrapper<InvoiceOpenRegistEntity> query = new QueryWrapper<InvoiceOpenRegistEntity>();
        query.select("  sum(invoice_mny) as totalInvoiceMny ");
        query.eq("contract_id", contractId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
        Map<String, Object> data = super.getMap(query);
        if (null != data) {
            resp.put("totalInvoiceMny", null != data.get("totalInvoiceMny") ? new BigDecimal(data.get("totalInvoiceMny").toString()) : BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("totalInvoiceMny", BigDecimal.ZERO);
        }
        return resp;
    }

    //解析Excel日期格式
    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000; //系统时区偏移 1900/1/1 到 1970/1/1 的 25569 天
        tDate.setTime((long) ((dVal - 25569) * 24 * 3600 * 1000 + localOffset));
        return tDate;
    }

    /**
     * 验证发票是否重复
     * @param poolList
     * @return
     */
    public void checkPool(List<InvoiceOpenPoolEntity> poolList) {
        List<String> invoiceNumberParamList = new ArrayList<>();
        for (int i = 0; i < poolList.size(); i++) {
            InvoiceOpenPoolEntity vo = poolList.get(i);
            if ("add".equals(vo.getRowState()) || "edit".equals(vo.getRowState())) {
                invoiceNumberParamList.add(vo.getInvoiceNumber());
                for (int j = i + 1; j < poolList.size(); j++) {
                    InvoiceOpenPoolEntity poolVo = poolList.get(j);
                    if (vo.getInvoiceNumber().equals(poolVo.getInvoiceNumber())) {
                        throw new BusinessException("发票号码第" + (i + 1) + "行和第" + (j + 1) + "重复");
                    }
                }
            }
        }

        if (CollectionUtils.isNotEmpty(invoiceNumberParamList)) {
            checkInvoiceNumber(poolList, invoiceNumberParamList);
        }
    }

    /**
     * 删除
     * @param vos
     * @return
     */
    @Transactional
    public CommonResponse<String> delete(List<InvoiceOpenRegistVO> vos) {
        List<Long> ids = vos.stream().map(InvoiceOpenRegistVO::getId).collect(Collectors.toList());
        QueryWrapper<InvoiceOpenPoolEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("dr", 1, 3);
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        queryWrapper.in("regist_id", ids);
        List<InvoiceOpenPoolVO> list = invoiceOpenPoolService.queryList(queryWrapper);
        if (list != null && list.size() > 0) {
            String message = "";
            List<InvoiceOpenRegistEntity> entitys = (List<InvoiceOpenRegistEntity>) this.listByIds(list.stream().map(InvoiceOpenPoolVO::getRegistId).collect(Collectors.toList()));
            for (InvoiceOpenRegistEntity entity : entitys) {
                if (message.length() > 0) {
                    message += ("、" + entity.getCode());
                } else {
                    message += entity.getCode();
                }
            }
            if (message.length() > 0) {
                return CommonResponse.error("以下登记：" + message + "存在发票数据，不能删除！！！");
            }
        }

        QueryWrapper<InvoiceOpenRegistEntity> query = new QueryWrapper<>();
        query.eq("dr", 0);
        query.in("id", ids);
        List<InvoiceOpenRegistEntity> registList = super.list(query);
        List<Long> applyIds = registList.stream().map(InvoiceOpenRegistEntity::getApplyId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(registList)) {
            UpdateWrapper<InvoiceOpenApplyEntity> wrapper = new UpdateWrapper<>();
            wrapper.in("id", applyIds);
            wrapper.set("open_type", 0);//改成为登记状态
            invoiceOpenApplyService.update(wrapper);


        }

        if (CollectionUtils.isNotEmpty(ids)) {
            UpdateWrapper<InvoiceOpenRegistEntity> wrapper = new UpdateWrapper<InvoiceOpenRegistEntity>();
            wrapper.in("id", ids);
            wrapper.set("regist_state", 0);
            this.update(wrapper);
        }

        invoiceOpenPoolService.deleteBatchRegistId(ids);
        removeByIds(ids);
        return CommonResponse.success("删除登记成功");
    }

    @Override
    public List<InvoiceOpenRegistVO> querylist(QueryWrapper<InvoiceOpenRegistEntity> queryWrapper) {
        List<InvoiceOpenRegistEntity> list = this.list(queryWrapper);
        return BeanMapper.mapList(list, InvoiceOpenRegistVO.class);
    }


    /**
     * 查询发票号码
     * @param poolList
     * @param invoiceNumberParamList
     */
    public void checkInvoiceNumber(List<InvoiceOpenPoolEntity> poolList, List<String> invoiceNumberParamList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in("invoice_number", invoiceNumberParamList);
        queryWrapper.eq("dr", 0);
        queryWrapper.in("org_id", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        List<InvoiceOpenPoolEntity> openPoolEntityList = invoiceOpenPoolService.list(queryWrapper);
        Map<String, InvoiceOpenPoolEntity> poolMap = new HashMap<>();

        for (InvoiceOpenPoolEntity entity : poolList) {
            if ("add".equals(entity.getRowState()) || "edit".equals(entity.getRowState())) {
                poolMap.put(entity.getInvoiceNumber(), entity);
            }
        }

        List<InvoiceOpenPoolEntity> restList = new LinkedList<>();
        for (InvoiceOpenPoolEntity poolEntity : openPoolEntityList) {
            if (poolMap.containsKey(poolEntity.getInvoiceNumber())) {
                restList.add(poolEntity);
            }
        }

        if (CollectionUtils.isNotEmpty(restList)) {
            for (InvoiceOpenPoolEntity e : restList) {
                InvoiceOpenPoolEntity v = poolMap.get(e.getInvoiceNumber());
                if (v.getId() != null) {
                    if (!v.getId().equals(e.getId())) {
                        throw new BusinessException("发票号码" + e.getInvoiceNumber() + "已经存在");
                    }
                } else {
                    throw new BusinessException("发票号码" + e.getInvoiceNumber() + "已经存在");
                }
            }
        }

    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    public Map<String, String> getDefMapName(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    @Override
    public ParamsCheckVO checkParams(Long contractId, BigDecimal appMoney) {

        CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(CHEC_INVOICE_OPEN_CODE, InvocationInfoProxy.getOrgId());
        if (!response.isSuccess()) {
            throw new BusinessException("【施工合同金额】控制【开票金额】，获取控制参数失败，失败原因：" + response.getMsg());
        }

        List<BillParamVO> billParamVOS = response.getData();

        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());

        // 初始化返回参数
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        String[] paramsArray = {"none", "warn", "alert"};
        Integer controlType = 0;
        paramsCheckVO.setWarnType(paramsArray[controlType]);
        // 累计金额
        BigDecimal oldSumMoney = BigDecimal.ZERO;
        // 合同总金额
        BigDecimal contractTaxMny = BigDecimal.ZERO;

        // 获取合同信息
        CommonResponse<ContractVo> contractVoCommonResponse = iIncomeContractApi.queryDetail(contractId);
        if (contractVoCommonResponse.isSuccess() && null != contractVoCommonResponse.getData() && null != contractVoCommonResponse.getData().getContractTaxMny()) {
            contractTaxMny = contractVoCommonResponse.getData().getContractTaxMny();
        }
        // 累计金额
        BigDecimal sumMoneyByContractId = invoiceOpenMapper.getSumMoneyByContractId(contractId);
        if (null != sumMoneyByContractId) {
            oldSumMoney = sumMoneyByContractId;
        }

        if (CollectionUtils.isNotEmpty(billParamVOS)) {
            for (BillParamVO billParamVO : billParamVOS) {
                if (0 != billParamVO.getControlType()) {
                    BigDecimal sumMoney = ComputeUtil.safeAdd(oldSumMoney, appMoney);
                    BigDecimal roleValue = ComputeUtil.scaleTwo(billParamVO.getRoleValue());
                    BigDecimal _contractTaxMny = ComputeUtil.safeMultiply(contractTaxMny, roleValue, ComputeUtil.toBigDecimal("0.01"));
                    BigDecimal subMoney = ComputeUtil.safeSub(sumMoney, _contractTaxMny);
                    if (ComputeUtil.isGreaterThan(subMoney, BigDecimal.ZERO)) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("销项发票超开");
                        paramsCheckDsVO.setWarnName("开票金额大于施工合同金额");
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setContent("本次开票金额：" + appMoney.setScale(2, BigDecimal.ROUND_HALF_UP) + "，施工合同金额*" + ComputeUtil.scaleTwo(roleValue) + "%：" + ComputeUtil.scaleTwo(_contractTaxMny) +
                                "。超出金额：" + subMoney.setScale(2, BigDecimal.ROUND_HALF_UP));
                        checkDsVOS.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(checkDsVOS);
                        updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                }
            }
        }
        paramsCheckVO.setWarnType(paramsArray[controlType]);

        //处理刚性、柔性预警
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }

        return pc;
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}
