/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"invoiceOpenRegist"})
public class InvoiceOpenRegistController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceOpenRegistService service;
    @Autowired
    private IInvoiceOpenPoolService iInvoiceOpenPoolService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceOpenRegistVO> saveOrUpdate(@RequestBody InvoiceOpenRegistVO saveorUpdateVO) {
        InvoiceOpenRegistEntity entity = (InvoiceOpenRegistEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InvoiceOpenRegistEntity.class));
        InvoiceOpenRegistEntity registEntity = this.service.saveOrUpdatePool(entity);
        InvoiceOpenRegistVO vo = (InvoiceOpenRegistVO)BeanMapper.map((Object)((Object)registEntity), InvoiceOpenRegistVO.class);
        List list = vo.getContractItemList();
        ArrayList<InvoiceOpenPoolVO> allList = new ArrayList<InvoiceOpenPoolVO>();
        for (InvoiceOpenPoolVO v : list) {
            v.setRowState(null);
            allList.add(v);
        }
        vo.setContractItemList(allList);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceOpenRegistVO> queryDetail(Long id) {
        InvoiceOpenRegistEntity entity = this.service.selectByIdAll(id);
        InvoiceOpenRegistVO vo = (InvoiceOpenRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceOpenRegistVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceOpenRegistVO> vos) {
        return this.service.delete(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenRegistVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("applyCode");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("buyer");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("seller");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("registUserName");
        param.getFuzzyFields().add("applyer");
        if (param.getParams().get("hasMyRegist") != null) {
            if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("1")) {
                param.getParams().put("registUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("0")) {
                param.getParams().put("registUserId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceOpenRegistVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryRegistPool"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceOpenRegistVO> queryPoolList(Long id) {
        InvoiceOpenRegistEntity entity = this.service.selectOpenRegistByApplyId(id);
        InvoiceOpenRegistVO vo = new InvoiceOpenRegistVO();
        if (entity != null) {
            vo = (InvoiceOpenRegistVO)BeanMapper.map((Object)((Object)entity), InvoiceOpenRegistVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"registPool-import.xlsx", (String)"\u5f00\u7968\u767b\u8bb0\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<InvoiceOpenPoolVO> successList = new ArrayList<InvoiceOpenPoolVO>();
        ArrayList<InvoiceOpenPoolVO> errorList = new ArrayList<InvoiceOpenPoolVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 8) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String, String> defMap = this.getDefMap((List)defList.getData());
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                InvoiceOpenPoolVO invoiceOpenPoolVO = new InvoiceOpenPoolVO();
                if (StringUtils.isBlank((String)((String)datas.get(0)))) {
                    invoiceOpenPoolVO.setErrorMessage("\u53d1\u7968\u7c7b\u578b\u80fd\u4e0d\u4e3a\u7a7a");
                } else {
                    String invoiceTypeCall = (String)datas.get(0);
                    String invoiceType = defMap.get(invoiceTypeCall);
                    if (StringUtils.isNotEmpty((String)invoiceType)) {
                        invoiceOpenPoolVO.setInvoiceType(Long.valueOf(invoiceType));
                        invoiceOpenPoolVO.setInvoiceTypeName(invoiceTypeCall);
                    } else {
                        invoiceOpenPoolVO.setErrorMessage("\u53d1\u7968\u7c7b\u578b\u53ef\u80fd\u4e0d\u6b63\u786e");
                    }
                }
                if (StringUtils.isBlank((String)((String)datas.get(1)))) {
                    invoiceOpenPoolVO.setErrorMessage("\u53d1\u7968\u4ee3\u7801\u4e0d\u4e3a\u7a7a");
                } else {
                    invoiceOpenPoolVO.setInvoiceCode((String)datas.get(1));
                }
                if (StringUtils.isBlank((String)((String)datas.get(2)))) {
                    invoiceOpenPoolVO.setErrorMessage("\u53d1\u7968\u53f7\u7801\u4e0d\u4e3a\u7a7a");
                } else {
                    invoiceOpenPoolVO.setInvoiceNumber((String)datas.get(2));
                }
                if (StringUtils.isBlank((String)((String)datas.get(3)))) {
                    invoiceOpenPoolVO.setErrorMessage("\u5f00\u7968\u65e5\u671f\u4e0d\u4e3a\u7a7a");
                } else {
                    try {
                        String strDate = this.service.excelDoubleToDate((String)datas.get(3));
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = simpleDateFormat.parse(strDate);
                        invoiceOpenPoolVO.setInvoiceDate(date);
                    }
                    catch (Exception e) {
                        invoiceOpenPoolVO.setErrorMessage("\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
                        e.printStackTrace();
                    }
                }
                if (StringUtils.isBlank((String)((String)datas.get(4)))) {
                    invoiceOpenPoolVO.setErrorMessage("\u53d1\u7968\u91d1\u989d\u4e0d\u4e3a\u7a7a");
                } else {
                    try {
                        invoiceOpenPoolVO.setInvoiceMny(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        invoiceOpenPoolVO.setErrorMessage("\u53d1\u7968\u91d1\u989d\u5fc5\u987b\u662f\u6570\u5b57");
                    }
                }
                if (StringUtils.isBlank((String)((String)datas.get(5)))) {
                    invoiceOpenPoolVO.setTaxMny(new BigDecimal(0));
                } else {
                    try {
                        invoiceOpenPoolVO.setTaxMny(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        invoiceOpenPoolVO.setErrorMessage("\u7a0e\u91d1\u5fc5\u987b\u662f\u6570\u5b57");
                    }
                }
                invoiceOpenPoolVO.setInvoiceContent((String)datas.get(6));
                invoiceOpenPoolVO.setMemo((String)datas.get(7));
                invoiceOpenPoolVO.setInvoiceTaxMny(invoiceOpenPoolVO.getInvoiceMny().add(invoiceOpenPoolVO.getTaxMny()));
                if (StringUtils.isNotBlank((String)invoiceOpenPoolVO.getErrorMessage())) {
                    errorList.add(invoiceOpenPoolVO);
                    continue;
                }
                successList.add(invoiceOpenPoolVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/queryApplyRegistList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenPoolVO>> queryApplyRegistList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("invoiceCode");
        param.getFuzzyFields().add("invoiceNumber");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("customerName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("applyCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("regist", new Parameter("eq", (Object)1));
        IPage page = this.iInvoiceOpenPoolService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceOpenPoolVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("applyCode");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("buyer");
        queryParam.getFuzzyFields().add("code");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceOpenRegistVO r = (InvoiceOpenRegistVO)BeanMapper.map((Object)pool, InvoiceOpenRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        String titel = "";
        if (queryParam.getParams().get("registState") != null) {
            if (((Parameter)queryParam.getParams().get("registState")).getValue().equals(0)) {
                titel = "\u5f85\u767b\u8bb0";
            }
        } else {
            titel = "";
        }
        beans.put("titel", titel);
        ExcelExport.getInstance().export("invoiceOpenRegistStaye-export.xlsx", beans, response);
    }

    @PostMapping(value={"alreadyExcelExport"})
    public void alreadyExcelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("applyCode");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("buyer");
        queryParam.getFuzzyFields().add("code");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceOpenRegistVO r = (InvoiceOpenRegistVO)BeanMapper.map((Object)pool, InvoiceOpenRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceOpenRegist-Apply-export.xlsx", beans, response);
    }

    @PostMapping(value={"notExcelExport"})
    public void notExcelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("applyCode");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("buyer");
        queryParam.getFuzzyFields().add("code");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceOpenRegistVO r = (InvoiceOpenRegistVO)BeanMapper.map((Object)pool, InvoiceOpenRegistVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceOpenRegist-export.xlsx", beans, response);
    }

    @PostMapping(value={"excelApplyRegistExport"})
    public void excelApplyRegistExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("regist", new Parameter("eq", (Object)1));
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage pageData = this.iInvoiceOpenPoolService.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                InvoiceOpenPoolVO r = (InvoiceOpenPoolVO)BeanMapper.map((Object)pool, InvoiceOpenPoolVO.class);
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("applyRegistPool-export.xlsx", beans, response);
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(Long contractId, BigDecimal appMoney) {
        ParamsCheckVO paramsCheckVO = this.service.checkParams(contractId, appMoney);
        return CommonResponse.success((String)"\u67e5\u8be2\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d\u3011\u63a7\u5236\u3010\u5f00\u7968\u91d1\u989d\u3011\u6210\u529f\uff01", (Object)paramsCheckVO);
    }
}

