/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.PayInvoiceUseVO;
import com.ejianc.business.finance.vo.ReceiveInvoiceVO;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invoiceOpenPool"})
public class InvoiceOpenPoolController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IInvoiceOpenPoolService service;
    @Autowired
    private IReceiveManageApi receiveManageApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceOpenPoolVO> saveOrUpdate(@RequestBody InvoiceOpenPoolVO saveorUpdateVO) {
        InvoiceOpenPoolEntity entity = (InvoiceOpenPoolEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InvoiceOpenPoolEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        InvoiceOpenPoolVO vo = (InvoiceOpenPoolVO)BeanMapper.map((Object)((Object)entity), InvoiceOpenPoolVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceOpenPoolVO> queryDetail(Long id) {
        InvoiceOpenPoolEntity entity = (InvoiceOpenPoolEntity)((Object)this.service.selectById(id));
        InvoiceOpenPoolVO vo = (InvoiceOpenPoolVO)BeanMapper.map((Object)((Object)entity), InvoiceOpenPoolVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceOpenPoolVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenPoolVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("invoiceCode");
        param.getFuzzyFields().add("invoiceNumber");
        param.getFuzzyFields().add("customerName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("registCode");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("regist", new Parameter("eq", (Object)1));
        if (param.getParams().get("hasMyRegist") != null) {
            if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("1")) {
                param.getParams().put("employeeId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if (((Parameter)param.getParams().get("hasMyRegist")).getValue().equals("0")) {
                param.getParams().put("employeeId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List invoiceOpenPoolVOS = BeanMapper.mapList((Iterable)page.getRecords(), InvoiceOpenPoolVO.class);
        if (CollectionUtils.isNotEmpty((Collection)invoiceOpenPoolVOS)) {
            List invoiceIds = invoiceOpenPoolVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            PayInvoiceUseVO payInvoiceUseVO = new PayInvoiceUseVO();
            payInvoiceUseVO.setInvoiceIds(invoiceIds);
            CommonResponse listCommonResponse = this.receiveManageApi.countOpenUseNum(payInvoiceUseVO);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                List payInvoiceUseVOList = (List)listCommonResponse.getData();
                Map<Long, Integer> map = payInvoiceUseVOList.stream().collect(Collectors.toMap(PayInvoiceUseVO::getInvoiceId, PayInvoiceUseVO::getInvoiceBillNum));
                invoiceOpenPoolVOS.forEach(t -> t.setInvoiceBillNum((Integer)map.get(t.getId())));
            }
        }
        pageData.setRecords(invoiceOpenPoolVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListByRegistId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryListByRegistId(Long registId) {
        JSONObject data = new JSONObject();
        List list = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"regist_id", (Object)registId);
        List invoiceOpenPoolEntityList = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)invoiceOpenPoolEntityList)) {
            list = BeanMapper.mapList((Iterable)invoiceOpenPoolEntityList, InvoiceOpenPoolVO.class);
        }
        data.put("contractItemList", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5df2\u767b\u8bb0\u53d1\u7968\u6210\u529f\uff01", (Object)data);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("regist", new Parameter("eq", (Object)1));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(invoiceOpenPoolEntity -> {
                InvoiceOpenPoolVO r = (InvoiceOpenPoolVO)BeanMapper.map((Object)invoiceOpenPoolEntity, InvoiceOpenPoolVO.class);
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceOpenRegistPool-export.xlsx", beans, response);
    }

    @PostMapping(value={"excelReportExport"})
    public void excelReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("regist", new Parameter("eq", (Object)1));
        IPage pageData = this.service.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(invoiceOpenPoolEntity -> {
                InvoiceOpenPoolVO r = (InvoiceOpenPoolVO)BeanMapper.map((Object)invoiceOpenPoolEntity, InvoiceOpenPoolVO.class);
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("reportRegistPool-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryInvoiceOpenPoolVOInfo"}, method={RequestMethod.GET})
    @ResponseBody
    CommonResponse<ReceiveVO> queryInvoiceOpenPoolVOInfo(@RequestParam(value="registId") Long registId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"regist_id", (Object)registId);
        List list = this.service.list((Wrapper)queryWrapper);
        InvoiceOpenPoolEntity invoiceOpenPoolEntity = (InvoiceOpenPoolEntity)((Object)list.get(0));
        ReceiveVO receiveVO = new ReceiveVO();
        receiveVO.setOrgId(invoiceOpenPoolEntity.getOrgId());
        receiveVO.setOrgName(invoiceOpenPoolEntity.getOrgName());
        receiveVO.setProjectId(invoiceOpenPoolEntity.getProjectId());
        receiveVO.setProjectName(invoiceOpenPoolEntity.getProjectName());
        if (invoiceOpenPoolEntity.getContractId() != null) {
            receiveVO.setReceiveType(Long.valueOf(1275321308270993409L));
        } else {
            receiveVO.setReceiveType(Long.valueOf(1275321354706132993L));
        }
        receiveVO.setContractId(invoiceOpenPoolEntity.getContractId());
        receiveVO.setContractName(invoiceOpenPoolEntity.getContractName());
        receiveVO.setContractCode(invoiceOpenPoolEntity.getContractCode());
        receiveVO.setContractCode(invoiceOpenPoolEntity.getContractCode());
        receiveVO.setReceiveUnitId(invoiceOpenPoolEntity.getCustomerId());
        receiveVO.setReceiveUnitName(invoiceOpenPoolEntity.getContractName());
        ArrayList<ReceiveInvoiceVO> invoiceVOList = new ArrayList<ReceiveInvoiceVO>();
        List invoiceOpenPoolVOS = BeanMapper.mapList((Iterable)list, InvoiceOpenPoolVO.class);
        for (InvoiceOpenPoolVO vo : invoiceOpenPoolVOS) {
            ReceiveInvoiceVO receiveInvoiceVO = new ReceiveInvoiceVO();
            receiveInvoiceVO.setId(Long.valueOf(IdWorker.getId()));
            receiveInvoiceVO.setInvoiceId(vo.getId());
            receiveInvoiceVO.setInvoiceNumber(vo.getInvoiceNumber());
            receiveInvoiceVO.setInvoiceCode(vo.getInvoiceCode());
            receiveInvoiceVO.setInvoiceMny(vo.getInvoiceMny());
            receiveInvoiceVO.setTaxMny(vo.getTaxMny());
            receiveInvoiceVO.setCreateUserName(vo.getCreateUserName());
            receiveInvoiceVO.setInvoiceTaxMny(vo.getInvoiceTaxMny());
            receiveInvoiceVO.setCreateUserCode(vo.getCreateUserCode());
            receiveInvoiceVO.setCreateTime(vo.getCreateTime());
            receiveInvoiceVO.setInvoiceVersion(vo.getVersion());
            receiveInvoiceVO.setSurplusInvoiceTaxMny(ComputeUtil.safeSub((BigDecimal)vo.getInvoiceTaxMny(), (BigDecimal)vo.getUseInvoiceTaxMny()));
            invoiceVOList.add(receiveInvoiceVO);
        }
        receiveVO.setInvoiceVOList(invoiceVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)receiveVO);
    }
}

