/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.taxnew.bean.InvoiceDeducApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceDeducApplySubEntity;
import com.ejianc.business.taxnew.bean.InvoiceDeducBillEntity;
import com.ejianc.business.taxnew.bean.InvoiceDeducBillSubEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplyService;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplySubService;
import com.ejianc.business.taxnew.service.IInvoiceDeducBillService;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceDeducBill")
public class InvoiceDeducBillBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceDeducBillService service;
    @Autowired
    private IInvoiceDeducApplyService applyService;
    @Autowired
    private IInvoiceDeducApplySubService applySubService;
    @Autowired
    private IInvoiceReceivePoolService poolService;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u8eab\u5ba1\u6838\u56de\u8c03\u5f00\u59cb");
        InvoiceDeducBillEntity entity = (InvoiceDeducBillEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        this.logger.info("InvoiceDeducBillEntity entity = {}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        entity.setAlreadyDeduc(true);
        for (InvoiceDeducBillSubEntity sub : entity.getInvoiceDeducBillSubs()) {
            InvoiceDeducApplySubEntity applySubEntity = (InvoiceDeducApplySubEntity)((Object)this.applySubService.selectById(sub.getApplySubId()));
            InvoiceReceivePoolEntity poolEntity = (InvoiceReceivePoolEntity)((Object)this.poolService.selectById(sub.getInvoiceId()));
            if (applySubEntity != null) {
                applySubEntity.setActualDeducMny(sub.getActualDeducMny());
                applySubEntity.setActualDeducTaxMny(sub.getActualDeducTaxMny());
                applySubEntity.setAlreadyDeduc(true);
                applySubEntity.setDeducDate(sub.getCreateTime());
                this.logger.info("\u5f00\u59cb\u4fdd\u5b58\u7533\u8bf7\u5b50\u8868 {}", (Object)JSONObject.toJSONString((Object)((Object)applySubEntity)));
                this.applySubService.saveOrUpdate((Object)applySubEntity, false);
            }
            if (poolEntity == null) continue;
            poolEntity.setActualDeductionMny(sub.getActualDeducMny());
            poolEntity.setActualDeductionTax(sub.getActualDeducTaxMny());
            poolEntity.setDeductionState(1);
            this.poolService.saveOrUpdate((Object)poolEntity, false);
        }
        InvoiceDeducApplyEntity applyEntity = (InvoiceDeducApplyEntity)((Object)this.applyService.selectById(entity.getApplyId()));
        applyEntity.setAlreadyDeduc(true);
        applyEntity.setActualDeducMny(entity.getActualDeducMny());
        applyEntity.setActualDeducTaxMny(entity.getActualDeducTaxMny());
        this.applyService.saveOrUpdate((Object)applyEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        InvoiceDeducBillEntity entity = (InvoiceDeducBillEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setAlreadyDeduc(false);
        for (InvoiceDeducBillSubEntity sub : entity.getInvoiceDeducBillSubs()) {
            InvoiceDeducApplySubEntity applySubEntity = (InvoiceDeducApplySubEntity)((Object)this.applySubService.selectById(sub.getApplySubId()));
            InvoiceReceivePoolEntity poolEntity = (InvoiceReceivePoolEntity)((Object)this.poolService.selectById(sub.getInvoiceId()));
            if (applySubEntity != null) {
                applySubEntity.setActualDeducMny(BigDecimal.ZERO);
                applySubEntity.setActualDeducTaxMny(BigDecimal.ZERO);
                applySubEntity.setAlreadyDeduc(false);
                applySubEntity.setDeducDate(null);
                this.applySubService.saveOrUpdateNoES((Object)applySubEntity);
            }
            if (poolEntity != null) {
                poolEntity.setActualDeductionMny(BigDecimal.ZERO);
                poolEntity.setActualDeductionTax(BigDecimal.ZERO);
                poolEntity.setDeductionState(0);
                this.poolService.saveOrUpdateNoES((Object)poolEntity);
            }
            InvoiceDeducApplyEntity applyEntity = (InvoiceDeducApplyEntity)((Object)this.applyService.selectById(entity.getApplyId()));
            applyEntity.setAlreadyDeduc(false);
            applyEntity.setActualDeducMny(null);
            applyEntity.setActualDeducTaxMny(null);
            this.applyService.saveOrUpdateNoES((Object)applyEntity);
        }
        return CommonResponse.success();
    }
}

