package com.ejianc.business.techmanagement.service.impl;

import com.ejianc.business.techmanagement.bean.ConstrutOrgDesignEntity;
import com.ejianc.business.techmanagement.service.IConstrutOrgDesignService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("construtOrgDesign") 
public class ConstrutOrgDesignBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IConstrutOrgDesignService service;

	@Autowired
	private SessionManager sessionManager;

	/**
	 * 有审批流的提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ConstrutOrgDesignEntity entity = service.selectById(billId);
		UserContext user = sessionManager.getUserContext();

		entity.setCommitDate(new Date());
		entity.setCommitUserCode(InvocationInfoProxy.getUsercode());
		entity.setCommitUserName(user.getUserName());

		service.saveOrUpdate(entity, false);
		return CommonResponse.success("提交回调成功！");
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ConstrutOrgDesignEntity entity = service.selectById(billId);

		entity.setEffectiveDate(new Date());
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			UserContext user = sessionManager.getUserContext();

			entity.setCommitDate(new Date());
			entity.setCommitUserCode(InvocationInfoProxy.getUsercode());
			entity.setCommitUserName(user.getUserName());
		}

		service.saveOrUpdate(entity, false);

		return CommonResponse.success("审批通过回调处理成功！");
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		updateBillBack(billId);
		return CommonResponse.success("撤回处理成功！");
	}

	private void updateBillBack(Long billId) {
		ConstrutOrgDesignEntity entity = service.selectById(billId);
		entity.setCommitDate(null);
		entity.setCommitUserCode(null);
		entity.setCommitUserName(null);
		entity.setEffectiveDate(null);
		service.saveOrUpdate(entity, false);
	}

	;

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		updateBillBack(billId);
		return CommonResponse.success("弃审回调处理成功！");
	}

}
