/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.techmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.techmanagement.bean.DrawingRegistrationEntity;
import com.ejianc.business.techmanagement.service.IDrawingRegistrationService;
import com.ejianc.business.techmanagement.vo.DrawingRegistrationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"drawingRegistration"})
public class DrawingRegistrationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "TECHMANAGEMENT-DRAWING-REGISTRATION";
    @Autowired
    private IDrawingRegistrationService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DrawingRegistrationVO> saveOrUpdate(@RequestBody DrawingRegistrationVO saveOrUpdateVO) {
        DrawingRegistrationEntity entity;
        if (null != saveOrUpdateVO.getDrawingCode()) {
            List billCodeEntityList;
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"drawing_code", (Object)saveOrUpdateVO.getDrawingCode());
            if (null != saveOrUpdateVO.getId()) {
                query.ne((Object)"id", (Object)saveOrUpdateVO.getId());
            }
            if (CollectionUtils.isNotEmpty((Collection)(billCodeEntityList = this.service.list((Wrapper)query)))) {
                return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u76f8\u540c\u56fe\u7eb8\u53f7\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e\uff01");
            }
        }
        if ((entity = (DrawingRegistrationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DrawingRegistrationEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DrawingRegistrationVO vo = (DrawingRegistrationVO)BeanMapper.map((Object)((Object)entity), DrawingRegistrationVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DrawingRegistrationVO> queryDetail(Long id) {
        DrawingRegistrationEntity entity = (DrawingRegistrationEntity)((Object)this.service.selectById(id));
        DrawingRegistrationVO vo = (DrawingRegistrationVO)BeanMapper.map((Object)((Object)entity), DrawingRegistrationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DrawingRegistrationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DrawingRegistrationVO drawingRegistrationVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DrawingRegistrationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("secondaryUnits");
        fuzzyFields.add("name");
        fuzzyFields.add("operatingDepartment");
        fuzzyFields.add("operatorName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DrawingRegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.service.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), DrawingRegistrationVO.class);
            if (list != null) {
                list.forEach(vo -> {
                    BillStateEnum billStateEnum;
                    Integer billState = vo.getBillState();
                    if (billState != null && (billStateEnum = BillStateEnum.getEnumByStateCode((Integer)billState)) != null) {
                        vo.setBillStateName(billStateEnum.getDescription());
                    }
                });
            }
            beans.put("records", list);
            ExcelExport.getInstance().export("DrawingRegistration-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refDrawingRegistrationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DrawingRegistrationVO>> refDrawingRegistrationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (condition.contains("projectId")) {
                param.getParams().put("projectId", new Parameter("eq", (Object)_con.getString("projectId")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DrawingRegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

