package com.ejianc.business.techmanagement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.techmanagement.bean.*;
import com.ejianc.business.techmanagement.service.ITecReviewContentService;
import com.ejianc.business.techmanagement.service.ITechnologyReviewService;
import com.ejianc.business.techmanagement.vo.ReviewPointsContentVO;
import com.ejianc.business.techmanagement.vo.TecReviewContentVO;
import com.ejianc.business.techmanagement.vo.TechnologyReviewVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.models.auth.In;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.techmanagement.service.ITechnicalReviewPointsService;
import com.ejianc.business.techmanagement.vo.TechnicalReviewPointsVO;

/**
 * 技术复核点编制 
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("technicalReviewPoints")
public class TechnicalReviewPointsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITecReviewContentService tecReviewContentService;

    @Autowired
    private ITechnologyReviewService technologyReviewService;

    private static final String BILL_CODE = "TECHNICAL-REVIEW-POINTS";//此处需要根据实际修改

    @Autowired
    private ITechnicalReviewPointsService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     *
     *
     * kjjllllaaaaa
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TechnicalReviewPointsVO> saveOrUpdate(@RequestBody TechnicalReviewPointsVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getBillCode()==null){
            Long projectId = saveOrUpdateVO.getProjectId();
            if (projectId!= null){
                LambdaQueryWrapper<TechnicalReviewPointsEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(TechnicalReviewPointsEntity::getProjectId,projectId);
                queryWrapper.eq(TechnicalReviewPointsEntity::getDr,0);
                int count = service.count(queryWrapper);
                if (count > 0){
                    return CommonResponse.error("该项目已存在技术复核点编制单据，不可重复新增！");
                }
            }


        }
        TechnicalReviewPointsEntity entity = BeanMapper.map(saveOrUpdateVO, TechnicalReviewPointsEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.getReviewPointsContentList().forEach(reviewPointsContentVO -> {
                    reviewPointsContentVO.setCode(billCode.getData());
                });
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	TechnicalReviewPointsVO vo = BeanMapper.map(entity, TechnicalReviewPointsVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TechnicalReviewPointsVO> queryDetail(Long id) {
    	TechnicalReviewPointsEntity entity = service.selectById(id);
        TechnicalReviewPointsVO vo = BeanMapper.map(entity, TechnicalReviewPointsVO.class);
        Integer billState = entity.getBillState();
        BillStateEnum enumByStateCode = BillStateEnum.getEnumByStateCode(billState);
        if (enumByStateCode != BillStateEnum.COMMITED_STATE && enumByStateCode != BillStateEnum.PASSED_STATE){
            return CommonResponse.success("查询详情数据成功！",vo);
        }

        //复核情况
        Long projectId = entity.getProjectId();
        if (projectId==null){
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        LambdaQueryWrapper<TechnologyReviewEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TechnologyReviewEntity::getProjectId,projectId);
        queryWrapper.in(TechnologyReviewEntity::getBillState,Arrays.asList(1,3));
        queryWrapper.orderByDesc(TechnologyReviewEntity::getReviewDate,TechnologyReviewEntity::getCreateTime);


        List<TechnologyReviewEntity> list = technologyReviewService.list(queryWrapper);
        List<TechnologyReviewVO> technologyReviewVOS = BeanMapper.mapList(list, TechnologyReviewVO.class);
        if (CollectionUtils.isEmpty(list)){
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        vo.setTechnologyList(technologyReviewVOS);

        //查询复核点的复核结果
        List<ReviewPointsContentEntity> reviewPointsContentList = entity.getReviewPointsContentList();
        if (CollectionUtils.isEmpty(reviewPointsContentList)){
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        //已生效的技术复核主表id
        List<Long>technologyIds=list.stream().map(TechnologyReviewEntity::getId).collect(Collectors.toList());
        //技术复核点编制子表id
        List<Long>ids=reviewPointsContentList.stream().map(ReviewPointsContentEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<TecReviewContentEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(TecReviewContentEntity::getEstablishContentId,ids);
        wrapper.in(TecReviewContentEntity::getTecReviewId,technologyIds);
        wrapper.eq(TecReviewContentEntity::getEstablishId,entity.getId());
        List<TecReviewContentEntity> tecReviewContentEntities = tecReviewContentService.list(wrapper);
        List<TecReviewContentVO> tecReviewContentVOS = BeanMapper.mapList(tecReviewContentEntities, TecReviewContentVO.class);
        Map<Long,TecReviewContentVO> map=new HashMap<>();
        //technologyIds的排名
        Map<Long,Integer> score=new HashMap<>();
        for (int i = 0; i <technologyIds.size() ; i++) {
            score.put(technologyIds.get(i),i);
        }
        for (TecReviewContentVO tecReviewContentVO : tecReviewContentVOS) {
            Long establishContentId = tecReviewContentVO.getEstablishContentId();
            Long tecReviewId = tecReviewContentVO.getTecReviewId();
            if (!map.containsKey(establishContentId)){
                map.put(establishContentId,tecReviewContentVO);
                continue;
            }
            //只有复核日期比目前更新的才替换更新
            TecReviewContentVO reviewContentVO = map.get(establishContentId);
            if (score.get(tecReviewId) < score.get(reviewContentVO.getTecReviewId())){
                map.put(establishContentId,tecReviewContentVO);
            }
        }


        List<ReviewPointsContentVO> reviewPointsContentVOS = BeanMapper.mapList(reviewPointsContentList, ReviewPointsContentVO.class);
        for (ReviewPointsContentVO reviewPointsContentVO : reviewPointsContentVOS) {
            Long reviewPointsContentVOId = reviewPointsContentVO.getId();
            if (map.containsKey(reviewPointsContentVOId)){
                TecReviewContentVO tecReviewContentVO = map.get(reviewPointsContentVOId);
                reviewPointsContentVO.setReviewResult(tecReviewContentVO.getReviewResult());
            }
        }
        vo.setReviewPointsContentList(reviewPointsContentVOS);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TechnicalReviewPointsVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TechnicalReviewPointsVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TechnicalReviewPointsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TechnicalReviewPointsVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","unitName","employeeName","departmentName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//
//        UserContext userContext = sessionManager.getUserContext();
//        String authOrgIds = userContext.getAuthOrgIds();
//        if (StringUtils.isNotEmpty(authOrgIds)) {
//            CommonResponse<List<OrgVO>> authResponse = iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
//                    collect(Collectors.toList()));
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        } else {
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));




        IPage<TechnicalReviewPointsEntity> page = service.queryPage(param,false);
        IPage<TechnicalReviewPointsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TechnicalReviewPointsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","unitName","employeeName","departmentName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TechnicalReviewPointsEntity> list = service.queryList(param);
        //todo:字段翻译等等

        list.forEach(item->{
            Integer billState = item.getBillState();
            String description = BillStateEnum.getEnumByStateCode(billState).getDescription();
            item.setBillStateName(description);

        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TechnicalReviewPoints-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTechnicalReviewPointsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TechnicalReviewPointsVO>> refTechnicalReviewPointsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TechnicalReviewPointsEntity> page = service.queryPage(param,false);
        IPage<TechnicalReviewPointsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TechnicalReviewPointsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
