package com.ejianc.business.techmanagement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.techmanagement.bean.*;
import com.ejianc.business.techmanagement.service.IProfitTrackContentService;
import com.ejianc.business.techmanagement.service.IProfitTrackService;
import com.ejianc.business.techmanagement.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.techmanagement.service.IProfitPointService;

/**
 * 创效点制定
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("profitPoint")
public class ProfitPointController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROFIT-POINT-MAKE";//此处需要根据实际修改

    @Autowired
    private IProfitPointService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProfitTrackService profitTrackService;
    @Autowired
    private IProfitTrackContentService profitTrackContentService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProfitPointVO> saveOrUpdate(@RequestBody ProfitPointVO saveOrUpdateVO) {

        if(saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
            CommonResponse<ProfitPointVO> error = getCommonResponse(saveOrUpdateVO);
            if (error != null) return error;
        }else{
            Long id = saveOrUpdateVO.getId();
            ProfitPointEntity tecRegisterEntity = service.selectById(id);
            if (!tecRegisterEntity.getProjectId().equals(saveOrUpdateVO.getProjectId())){
                CommonResponse<ProfitPointVO> error = getCommonResponse(saveOrUpdateVO);
                if (error != null) return error;
            }
        }
//        Long projectId = saveOrUpdateVO.getProjectId();
//        if (projectId!= null){
//            LambdaQueryWrapper<ProfitPointEntity> queryWrapper = new LambdaQueryWrapper<>();
//            queryWrapper.eq(ProfitPointEntity::getProjectId,projectId);
//            queryWrapper.eq(ProfitPointEntity::getDr,0);
//            int count = service.count(queryWrapper);
//            if (count > 0){
//                return CommonResponse.error("该项目已存在创效点制定单据，不可重复新增！");
//            }
//        }
    	ProfitPointEntity entity = BeanMapper.map(saveOrUpdateVO, ProfitPointEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.getProfitPointContentList().forEach(profitPointContentVO -> {
                    profitPointContentVO.setCode(billCode.getData());
                });
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ProfitPointVO vo = BeanMapper.map(entity, ProfitPointVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    private CommonResponse<ProfitPointVO> getCommonResponse(ProfitPointVO saveOrUpdateVO) {
        Long projectId = saveOrUpdateVO.getProjectId();
        if (projectId!= null){
            LambdaQueryWrapper<ProfitPointEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ProfitPointEntity::getProjectId,projectId);
            queryWrapper.eq(ProfitPointEntity::getDr,0);
            int count = service.count(queryWrapper);
            if (count > 0){
                return CommonResponse.error("该项目已存在创效点制定单据，不可重复新增！");
            }
        }
        return null;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProfitPointVO> queryDetail(Long id) {
    	ProfitPointEntity entity = service.selectById(id);
    	ProfitPointVO vo = BeanMapper.map(entity, ProfitPointVO.class);
        Integer billState = entity.getBillState();
        BillStateEnum enumByStateCode = BillStateEnum.getEnumByStateCode(billState);
        if (enumByStateCode != BillStateEnum.COMMITED_STATE && enumByStateCode != BillStateEnum.PASSED_STATE){
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        Long projectId = entity.getProjectId();
        if (projectId == null){
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        LambdaQueryWrapper<ProfitTrackEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProfitTrackEntity::getProjectId,projectId);
        queryWrapper.in(ProfitTrackEntity::getBillState,Arrays.asList(1,3));
        queryWrapper.orderByDesc(ProfitTrackEntity::getTrackDate,ProfitTrackEntity::getCreateTime);

        List<ProfitTrackEntity> list = profitTrackService.list(queryWrapper);
        List<ProfitTrackVO> profitTrackVOS = BeanMapper.mapList(list, ProfitTrackVO.class);
        if (CollectionUtils.isEmpty(list)){
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        vo.setReviewStatus(profitTrackVOS);
        List<ProfitPointContentEntity> profitPointContentList = entity.getProfitPointContentList();
        if (CollectionUtils.isEmpty(profitPointContentList)){
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        List<Long>trackIds=list.stream().map(ProfitTrackEntity::getId).collect(Collectors.toList());
        List<Long>ids=profitPointContentList.stream().map(ProfitPointContentEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<ProfitTrackContentEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(ProfitTrackContentEntity::getPointContentId,ids);
        wrapper.in(ProfitTrackContentEntity::getTrackId,trackIds);
        wrapper.eq(ProfitTrackContentEntity::getPointId,entity.getId());
        List<ProfitTrackContentEntity> profitTrackContentEntities = profitTrackContentService.list(wrapper);
        List<ProfitTrackContentVO> profitTrackContentVOS = BeanMapper.mapList(profitTrackContentEntities, ProfitTrackContentVO.class);
        Map<Long, ProfitTrackContentVO> map=new HashMap<>();
        //trackIds的排名
        Map<Long,Integer> score=new HashMap<>();
        for (int i = 0; i <trackIds.size() ; i++) {
            score.put(trackIds.get(i),i);
        }
        for (ProfitTrackContentVO profitTrackContentVO : profitTrackContentVOS) {
            Long pointContentId = profitTrackContentVO.getPointContentId();
            Long trackId = profitTrackContentVO.getTrackId();
            if (!map.containsKey(pointContentId)){
                map.put(pointContentId,profitTrackContentVO);
            }
            ProfitTrackContentVO profitTrackContentVO1 = map.get(pointContentId);
            if (score.get(trackId)<score.get(profitTrackContentVO1.getTrackId())){
                map.put(pointContentId,profitTrackContentVO);
            }
        }
        List<ProfitPointContentVO> profitPointContentVOS = BeanMapper.mapList(profitPointContentList, ProfitPointContentVO.class);
        for (ProfitPointContentVO profitPointContentVO : profitPointContentVOS) {
            Long pointContentVOId = profitPointContentVO.getId();
            if (map.containsKey(pointContentVOId)){
                ProfitTrackContentVO profitTrackContentVO = map.get(pointContentVOId);
                profitPointContentVO.setReviewResult(profitTrackContentVO.getCompleteSituation());
                profitPointContentVO.setStatus(profitTrackContentVO.getState());
                profitPointContentVO.setActualTime(profitTrackContentVO.getActualCompleteTime());
            }
        }
        vo.setProfitPointContentList(profitPointContentVOS);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProfitPointVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProfitPointVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProfitPointVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProfitPointVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("unitName","projectName","employeeName","departmentName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        IPage<ProfitPointEntity> page = service.queryPage(param,false);
        IPage<ProfitPointVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProfitPointVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("unitName","projectName","employeeName","departmentName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProfitPointEntity> list = service.queryList(param);
        List<ProfitPointVO> profitPointVOS = BeanMapper.mapList(list, ProfitPointVO.class);
        //todo:字段翻译等等
        profitPointVOS.forEach(item->{
            Integer billState = item.getBillState();
            String description = BillStateEnum.getEnumByStateCode(billState).getDescription();
            item.setBillStateName(description);

        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", profitPointVOS);
        ExcelExport.getInstance().export("ProfitPoint-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProfitPointData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProfitPointVO>> refProfitPointData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProfitPointEntity> page = service.queryPage(param,false);
        IPage<ProfitPointVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProfitPointVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
