package com.ejianc.business.techmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.techmanagement.bean.ConstructionDisclosureDetailEntity;
/**
 * 施工方案交底
 * 
 * @author generator
 * 
 */
 @TableName("ejc_techmanagement_construction_disclosure")
public class ConstructionDisclosureEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父组织编码
    @TableField(value="build_unit_id")
    private Long buildUnitId; // 二级单位ID
    @TableField(value="build_unit_name")
    private String buildUnitName; // 二级单位
    @TableField(value="engineering_type_id")
    private Long engineeringTypeId; // 工程类型ID
    @TableField(value="engineering_type")
    private String engineeringType; // 工程类型
    @TableField(value="measure")
    private String measure; // 工程规模
    @TableField(value="scheme_id")
    private Long schemeId; // 方案ID
    @TableField(value="scheme_name")
    private String schemeName; // 方案名称
    @TableField(value="scheme_code")
    private String schemeCode; // 方案编码
    @TableField(value="scheme_code_plan")
    private String schemeCodePlan; // 方案分类
    @TableField(value="disclosure_time")
    private Date disclosureTime; // 交底日期
    @TableField(value="employee_id")
    private String employeeId; // 交底人ID
    @TableField(value="employee_name")
    private String employeeName; // 交底人名称
    @TableField(value="witness_id")
    private Long witnessId; // 见证人ID
    @TableField(value="witness_name")
    private String witnessName; // 见证人名称
    @TableField(value="memo")
    private String memo; // 交底内容及结果说明
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="constructionDisclosureDetailService")
    private List<ConstructionDisclosureDetailEntity> detailList = new ArrayList<>(); // 施工方案子实体
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getBuildUnitId() {
        return buildUnitId;
    }

    public void setBuildUnitId(Long buildUnitId) {
        this.buildUnitId = buildUnitId;
    }
    public String getBuildUnitName() {
        return buildUnitName;
    }

    public void setBuildUnitName(String buildUnitName) {
        this.buildUnitName = buildUnitName;
    }
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    public String getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(String engineeringType) {
        this.engineeringType = engineeringType;
    }
    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }
    public Long getSchemeId() {
        return schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }
    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }
    public String getSchemeCode() {
        return schemeCode;
    }

    public void setSchemeCode(String schemeCode) {
        this.schemeCode = schemeCode;
    }
    public String getSchemeCodePlan() {
        return schemeCodePlan;
    }

    public void setSchemeCodePlan(String schemeCodePlan) {
        this.schemeCodePlan = schemeCodePlan;
    }
    public Date getDisclosureTime() {
        return disclosureTime;
    }

    public void setDisclosureTime(Date disclosureTime) {
        this.disclosureTime = disclosureTime;
    }

    public String getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getWitnessId() {
        return witnessId;
    }

    public void setWitnessId(Long witnessId) {
        this.witnessId = witnessId;
    }
    public String getWitnessName() {
        return witnessName;
    }

    public void setWitnessName(String witnessName) {
        this.witnessName = witnessName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }


    public List<ConstructionDisclosureDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ConstructionDisclosureDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
