package com.ejianc.business.techmanagement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.techmanagement.bean.SchemeEntity;
import com.ejianc.business.techmanagement.service.ISchemeService;
import com.ejianc.business.techmanagement.vo.SchemeVO;

/**
 * 方案字典
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("scheme")
public class SchemeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SCHEME";//此处需要根据实际修改

    @Autowired
    private ISchemeService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SchemeVO> saveOrUpdate(@RequestBody SchemeVO saveOrUpdateVO) {
        SchemeEntity entity = BeanMapper.map(saveOrUpdateVO, SchemeEntity.class);
        if(StringUtils.isNoneBlank(entity.getCode())){
            List<SchemeEntity> codeData = service.queryByCode(entity.getCode(), entity.getId());
            if(codeData!=null && codeData.size()>0){
                throw new BusinessException("编码已存在,请重新填写");
            }
        }
        if(entity.getId() == null || entity.getId() == 0){
            if (null == entity.getCode()){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity.setId(IdWorker.getId());
            if(entity.getParentId() != null && entity.getParentId() > 0) {
                SchemeEntity uniqueBean = service.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
        }else {
            SchemeEntity schemeEntity = service.selectById(entity.getId());
            schemeEntity.setName(saveOrUpdateVO.getName());
            schemeEntity.setCode(saveOrUpdateVO.getCode());
            schemeEntity.setDescription(saveOrUpdateVO.getDescription());
            schemeEntity.setCodePlan(saveOrUpdateVO.getCodePlan());
            schemeEntity.setSequence(saveOrUpdateVO.getSequence());
            entity = schemeEntity;
            service.update(new UpdateWrapper<SchemeEntity>().like("inner_code", entity.getInnerCode()).set("code_plan", entity.getCodePlan()));
        }
        service.saveOrUpdate(entity, false);
        SchemeVO vo = BeanMapper.map(service.selectById(entity.getId()), SchemeVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeVO> queryDetail(Long id) {
    	SchemeEntity entity = service.selectById(id);
    	SchemeVO vo = BeanMapper.map(entity, SchemeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                //如果分类有子节点并且所有子节点也包含在删除项内，允许删除
                List<SchemeVO> children = service.queryListByPid(id);
                if(children != null && children.size() > 0) {
                    for (SchemeVO child : children) {
                        if(!ids.contains(child.getId())){
                            return CommonResponse.error("方案【" + child.getName() + "】下有子方案，不允许删除");
                        }
                    }
                }
            }
        } else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        List<SchemeEntity> dataList = service.querySchemeList(queryParam);

        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("isLeaf").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));

        return CommonResponse.success(jsonObject);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("name","code"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SchemeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Scheme-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSchemeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SchemeVO>> refSchemeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("name","code"));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SchemeEntity> page = service.queryPage(param,false);
        IPage<SchemeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * 方案字典参照
     *
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/querySchemeTree", method = RequestMethod.GET)
    @ResponseBody
    public List<SchemeVO> querySchemeTree(@RequestParam(required=false) String condition,
                                              @RequestParam(required=false) Long pid, @RequestParam(required = false) String searchText) {
        List<SchemeVO> dataList = null;
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(searchText)) {
                params.put("name", searchText);
            }
            if(pid!=null){
                params.put("parentId", pid);
            }else {
                if(StringUtils.isNotEmpty(condition)){
                    /** 处理condition */
                    Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
                    if (null != conditionMap.get("pid")) {
                        params.put("parentId", conditionMap.get("pid").toString());
                    }else {
                        params.put("noParentId", true);
                    }
                }else {
                    params.put("noParentId", true);
                }
            }


            dataList = service.queryListEntityTree(params);

            dataList.forEach(l-> {
                if(!l.getIsLeaf()){
                    l.setChildren(new ArrayList<>());
                    l.setIsParent(true);
                }else{
                    l.setIsParent(false);
                }
            });
            if(StringUtils.isNotBlank(searchText)){
                return dataList;
            }
            return createTreeDataVO(dataList);
        } catch (Exception e) {
            logger.error("查询所有模块树异常: ", e);
            return null;
        }
    }


    public static List<SchemeVO> createTreeDataVO(List<SchemeVO> list) {
        List<SchemeVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        Map<String, SchemeVO> listMap = new HashMap<>();
        for(SchemeVO orgEntity:list) {
            listMap.put(orgEntity.getId().toString(), orgEntity);
        }

        for(int i =0; i<list.size(); i++) {
            SchemeVO orgEntity = list.get(i);
            String parentId = (orgEntity.getParentId() != null && orgEntity.getParentId() > 0) ? orgEntity.getParentId().toString():"";
            SchemeVO parent = listMap.get(parentId);
            if(parent != null) {
                List<SchemeVO> child = parent.getChildren();
                if(child != null) {
                    child.add(orgEntity);
                }else{
                    List<SchemeVO> children = new ArrayList<SchemeVO>();
                    children.add(orgEntity);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(orgEntity.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }


    /**
     * 列表查询
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryListNewTree", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryListNewTree(@RequestBody QueryParam queryParam) {

        List<SchemeVO> dataList = null;
        Map<String, Parameter> paramMap = queryParam.getParams();
        Map<String,Object> params = new HashMap<>();
        if (paramMap.containsKey("name")){
            params.put("name", paramMap.get("name").getValue());
        }
        if (paramMap.containsKey("code")){
            params.put("code", paramMap.get("code").getValue());
        }
        if (paramMap.containsKey("parentId")){
            params.put("parentId", paramMap.get("parentId").getValue());
        }
        dataList = service.queryListEntityTree(params);

        dataList.forEach(l-> {
            if(!l.getIsLeaf()){
                l.setChildren(new ArrayList<>());
                l.setIsParent(true);
            }else{
                l.setIsParent(false);
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", createTreeDataVO(dataList));
        return CommonResponse.success(jsonObject);
    }
}
