package com.ejianc.business.techmanagement.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.techmanagement.bean.TecMeterContentEntity;
import com.ejianc.business.techmanagement.service.ITecMeterContentService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.techmanagement.bean.TecMeterEntity;
import com.ejianc.business.techmanagement.service.ITecMeterService;
import com.ejianc.business.techmanagement.vo.TecMeterVO;

/**
 * 计量器具
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("tecMeter")
public class TecMeterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITecMeterContentService tecMeterContentService;

    private static final String BILL_CODE = "TECHNOLOGY-MEASUREMENT-INSTRUMENT";//此处需要根据实际修改

    @Autowired
    private ITecMeterService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TecMeterVO> saveOrUpdate(@RequestBody TecMeterVO saveOrUpdateVO) {
    	TecMeterEntity entity = BeanMapper.map(saveOrUpdateVO, TecMeterEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	TecMeterVO vo = BeanMapper.map(entity, TecMeterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TecMeterVO> queryDetail(Long id) {
    	TecMeterEntity entity = service.selectById(id);
    	TecMeterVO vo = BeanMapper.map(entity, TecMeterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TecMeterVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TecMeterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TecMeterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TecMeterVO>> queryList(@RequestBody QueryParam param) {
        Parameter state = param.getParams().get("state");
        if (state != null){
            if (state.getValue().equals("0")){
                param.getParams().put("validDate",new Parameter(QueryParam.GT, new Date()));
            }else{
                param.getParams().put("validDate",new Parameter(QueryParam.LE, new Date()));
            }
            param.getParams().remove("state");
            if (!param.getParams().containsKey("billState")){
                param.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(1,3)));
            }
        }

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","unitName","instrumentName","instrumentCode"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<TecMeterEntity> page = service.queryPage(param,false);
        List<TecMeterEntity> records = page.getRecords();
        records.forEach(tecMeterEntity -> {
            computeAndSetState(tecMeterEntity);

        });
        IPage<TecMeterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TecMeterVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /*
    * 计算仪器状态
    * */
    private void computeAndSetState(TecMeterEntity tecMeterEntity) {
        Integer billState = tecMeterEntity.getBillState();
        if (!Objects.equals(billState, BillStateEnum.COMMITED_STATE.getBillStateCode()) && !Objects.equals(billState, BillStateEnum.PASSED_STATE.getBillStateCode())){
            tecMeterEntity.setState(null);
            tecMeterEntity.setStateCode(0);
            return;
        }
        java.sql.Date validDate = new java.sql.Date(tecMeterEntity.getValidDate().getTime());

//        java.sql.Date validDate = (java.sql.Date) tecMeterEntity.getValidDate();
        LocalDate validLocalDate = validDate.toLocalDate();
        LocalDate now = LocalDate.now();

        /*
        * 如果【当前日期】<【有效截止日期】，【仪器状态】=未到期；
          如果【有效截止日期】-【当前日期】<=30 天，【仪器状态】=未到期（剩余n天）；
          如果【当前日期】>=【有效截止日期】，【仪器状态】=已到期（已过n天），n=当前日期-截止日期；
          * 只比较日期
        */
        long daysBetween = ChronoUnit.DAYS.between(now, validLocalDate);
        if (daysBetween>=0){
            if (daysBetween<=30){
                tecMeterEntity.setState("未到期（剩余"+daysBetween+"天）");
                tecMeterEntity.setStateCode(1);
            }else{
                tecMeterEntity.setState("未到期");
                tecMeterEntity.setStateCode(2);
            }
        }else{
            tecMeterEntity.setState("已到期（已过"+(-daysBetween)+"天）");
            tecMeterEntity.setStateCode(3);
        }

    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Parameter state = param.getParams().get("state");
        if (state != null){
            if (state.getValue().equals("0")){
                param.getParams().put("validDate",new Parameter(QueryParam.GT, new Date()));
            }else{
                param.getParams().put("validDate",new Parameter(QueryParam.LE, new Date()));
            }
            param.getParams().remove("state");
            if (!param.getParams().containsKey("billState")){
                param.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(1,3)));
            }

        }


        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","unitName","instrumentName","instrumentCode"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TecMeterEntity> list = service.queryList(param);
        list.forEach(this::computeAndSetState);
        List<TecMeterVO> tecMeterVOS = BeanMapper.mapList(list, TecMeterVO.class);
        tecMeterVOS.forEach(item->{
            Integer billState = item.getBillState();
            String description = BillStateEnum.getEnumByStateCode(billState).getDescription();
            item.setBillStateName(description);
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", tecMeterVOS);
        ExcelExport.getInstance().export("TecMeter-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTecMeterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TecMeterVO>> refTecMeterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TecMeterEntity> page = service.queryPage(param,false);
        IPage<TecMeterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TecMeterVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
