package com.ejianc.business.techmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.techmanagement.bean.ConstructionDisclosureEntity;
import com.ejianc.business.techmanagement.bean.QualityDisclosureEntity;
import com.ejianc.business.techmanagement.bean.SafetyDisclosureEntity;
import com.ejianc.business.techmanagement.service.IConstructionDisclosureService;
import com.ejianc.business.techmanagement.service.IConstructionSchemeService;
import com.ejianc.business.techmanagement.service.IQualityDisclosureService;
import com.ejianc.business.techmanagement.service.ISafetyDisclosureService;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("constructionScheme") 
public class ConstructionSchemeBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IConstructionDisclosureService disclosureService;
	@Autowired
	private IConstructionSchemeService schemeService;
	@Autowired
	private ISafetyDisclosureService safetyDisclosureService;
	@Autowired
	private IQualityDisclosureService qualityDisclosureService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		List<ConstructionDisclosureEntity> constructionList = disclosureService.list(new QueryWrapper<ConstructionDisclosureEntity>().eq("scheme_id", billId));
		if (CollectionUtils.isNotEmpty(constructionList) && constructionList.size() > 0){
			throw new BusinessException("该单据存在下游单据-施工方案交底，不能弃审！");
		}
		List<SafetyDisclosureEntity> safetyList = safetyDisclosureService.list(new QueryWrapper<SafetyDisclosureEntity>().eq("scheme_id", billId));
		if (CollectionUtils.isNotEmpty(safetyList) && safetyList.size() > 0){
			throw new BusinessException("该单据存在下游单据-分项工程安全技术交底，不能弃审！");
		}
		List<QualityDisclosureEntity> qualityList = qualityDisclosureService.list(new QueryWrapper<QualityDisclosureEntity>().eq("scheme_id", billId));
		if (CollectionUtils.isNotEmpty(qualityList) && qualityList.size() > 0){
			throw new BusinessException("该单据存在下游单据-分项工程质量技术交底，不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
