package com.ejianc.business.techmanagement.service.impl;


import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.techmanagement.bean.ConstructionDisclosureEntity;
import com.ejianc.business.techmanagement.bean.ConstructionSchemeEntity;
import com.ejianc.business.techmanagement.bean.DesignChangeDisclosureEntity;
import com.ejianc.business.techmanagement.bean.DesignChangeEntity;
import com.ejianc.business.techmanagement.service.IDesignChangeDisclosureService;
import com.ejianc.business.techmanagement.service.IDesignChangeService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("designChangeDisclosure")
public class DesignChangeDisclosureBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IDesignChangeService designChangeService;
	@Autowired
	private IDesignChangeDisclosureService disclosureService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		DesignChangeDisclosureEntity disclosureEntity = disclosureService.selectById(billId);
		//回写交底信息
		designChangeService.update(new UpdateWrapper<DesignChangeEntity>()
				.eq("id", disclosureEntity.getDesignChangeId())
				.set("disclosure_content", disclosureEntity.getDisclosureContent())
				.set("disclosure_time", disclosureEntity.getDisclosureTime())
				.set("disclosure_state", 1)
				.set("disclosure_id", disclosureEntity.getId())
		);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		DesignChangeDisclosureEntity disclosureEntity = disclosureService.selectById(billId);
		//回写交底信息
		designChangeService.update(new UpdateWrapper<DesignChangeEntity>()
				.eq("id", disclosureEntity.getDesignChangeId())
				.set("disclosure_content",null)
				.set("disclosure_time",null)
				.set("disclosure_state",0)
				.set("disclosure_id", null)
		);
		return CommonResponse.success();
	}

}
