package com.ejianc.business.techmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.techmanagement.bean.ConstructionSchemeEntity;
import com.ejianc.business.techmanagement.bean.QualityDisclosureEntity;
import com.ejianc.business.techmanagement.bean.SafetyDisclosureEntity;
import com.ejianc.business.techmanagement.service.IConstructionSchemeService;
import com.ejianc.business.techmanagement.service.IQualityDisclosureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("qualityDisclosure") 
public class QualityDisclosureBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IQualityDisclosureService qualityDisclosureService;
	@Autowired
	private IConstructionSchemeService schemeService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		QualityDisclosureEntity safetyDisclosureEntity = qualityDisclosureService.selectById(billId);
		//回写交底信息
		schemeService.update(new UpdateWrapper<ConstructionSchemeEntity>()
				.eq("id", safetyDisclosureEntity.getSchemeId())
				.set("disclosure_time", safetyDisclosureEntity.getDisclosureTime())
				.set("disclosure_content", safetyDisclosureEntity.getMemo())
				.set("disclosure_state", 1)
				.set("disclosure_type", 2)
				.set("disclosure_id", billId));
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		QualityDisclosureEntity qualityDisclosureEntity = qualityDisclosureService.selectById(billId);
		//回写交底信息
		schemeService.update(new UpdateWrapper<ConstructionSchemeEntity>()
				.eq("id", qualityDisclosureEntity.getSchemeId())
				.set("disclosure_time", null)
				.set("disclosure_content", null)
				.set("disclosure_state", 0)
				.set("disclosure_type", null)
				.set("disclosure_id", null));
		return CommonResponse.success();
	}

}
