/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.techmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.techmanagement.bean.ProfitPointContentEntity;
import com.ejianc.business.techmanagement.bean.ProfitPointEntity;
import com.ejianc.business.techmanagement.bean.ProfitTrackContentEntity;
import com.ejianc.business.techmanagement.bean.ProfitTrackEntity;
import com.ejianc.business.techmanagement.service.IProfitPointService;
import com.ejianc.business.techmanagement.service.IProfitTrackContentService;
import com.ejianc.business.techmanagement.service.IProfitTrackService;
import com.ejianc.business.techmanagement.vo.ProfitPointContentVO;
import com.ejianc.business.techmanagement.vo.ProfitPointVO;
import com.ejianc.business.techmanagement.vo.ProfitTrackContentVO;
import com.ejianc.business.techmanagement.vo.ProfitTrackVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"profitPoint"})
public class ProfitPointController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PROFIT-POINT-MAKE";
    @Autowired
    private IProfitPointService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProfitTrackService profitTrackService;
    @Autowired
    private IProfitTrackContentService profitTrackContentService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProfitPointVO> saveOrUpdate(@RequestBody ProfitPointVO saveOrUpdateVO) {
        ProfitPointEntity entity;
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0L) {
            CommonResponse<ProfitPointVO> error = this.getCommonResponse(saveOrUpdateVO);
            if (error != null) {
                return error;
            }
        } else {
            CommonResponse<ProfitPointVO> error;
            Long id = saveOrUpdateVO.getId();
            ProfitPointEntity tecRegisterEntity = (ProfitPointEntity)((Object)this.service.selectById(id));
            if (!tecRegisterEntity.getProjectId().equals(saveOrUpdateVO.getProjectId()) && (error = this.getCommonResponse(saveOrUpdateVO)) != null) {
                return error;
            }
        }
        if ((entity = (ProfitPointEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProfitPointEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.getProfitPointContentList().forEach(profitPointContentVO -> profitPointContentVO.setCode((String)billCode.getData()));
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProfitPointVO vo = (ProfitPointVO)BeanMapper.map((Object)((Object)entity), ProfitPointVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private CommonResponse<ProfitPointVO> getCommonResponse(ProfitPointVO saveOrUpdateVO) {
        Long projectId = saveOrUpdateVO.getProjectId();
        if (projectId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ProfitPointEntity::getProjectId, (Object)projectId);
            queryWrapper.eq(BaseEntity::getDr, (Object)0);
            int count = this.service.count((Wrapper)queryWrapper);
            if (count > 0) {
                return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u521b\u6548\u70b9\u5236\u5b9a\u5355\u636e\uff0c\u4e0d\u53ef\u91cd\u590d\u65b0\u589e\uff01");
            }
        }
        return null;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProfitPointVO> queryDetail(Long id) {
        ProfitPointEntity entity = (ProfitPointEntity)((Object)this.service.selectById(id));
        ProfitPointVO vo = (ProfitPointVO)BeanMapper.map((Object)((Object)entity), ProfitPointVO.class);
        Integer billState = entity.getBillState();
        BillStateEnum enumByStateCode = BillStateEnum.getEnumByStateCode((Integer)billState);
        if (enumByStateCode != BillStateEnum.COMMITED_STATE && enumByStateCode != BillStateEnum.PASSED_STATE) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        Long projectId = entity.getProjectId();
        if (projectId == null) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ProfitTrackEntity::getProjectId, (Object)projectId);
        queryWrapper.in(ProfitTrackEntity::getBillState, Arrays.asList(1, 3));
        queryWrapper.orderByDesc((Object[])new SFunction[]{ProfitTrackEntity::getTrackDate, BaseEntity::getCreateTime});
        List list = this.profitTrackService.list((Wrapper)queryWrapper);
        List profitTrackVOS = BeanMapper.mapList((Iterable)list, ProfitTrackVO.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        vo.setReviewStatus(profitTrackVOS);
        List<ProfitPointContentEntity> profitPointContentList = entity.getProfitPointContentList();
        if (CollectionUtils.isEmpty(profitPointContentList)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        List trackIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List ids = profitPointContentList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ProfitTrackContentEntity::getPointContentId, ids);
        wrapper.in(ProfitTrackContentEntity::getTrackId, trackIds);
        wrapper.eq(ProfitTrackContentEntity::getPointId, (Object)entity.getId());
        List profitTrackContentEntities = this.profitTrackContentService.list((Wrapper)wrapper);
        List profitTrackContentVOS = BeanMapper.mapList((Iterable)profitTrackContentEntities, ProfitTrackContentVO.class);
        HashMap<Long, ProfitTrackContentVO> map = new HashMap<Long, ProfitTrackContentVO>();
        HashMap score = new HashMap();
        for (int i = 0; i < trackIds.size(); ++i) {
            score.put(trackIds.get(i), i);
        }
        for (ProfitTrackContentVO profitTrackContentVO : profitTrackContentVOS) {
            Long pointContentId = profitTrackContentVO.getPointContentId();
            Long trackId = profitTrackContentVO.getTrackId();
            if (!map.containsKey(pointContentId)) {
                map.put(pointContentId, profitTrackContentVO);
            }
            ProfitTrackContentVO profitTrackContentVO1 = (ProfitTrackContentVO)map.get(pointContentId);
            if ((Integer)score.get(trackId) >= (Integer)score.get(profitTrackContentVO1.getTrackId())) continue;
            map.put(pointContentId, profitTrackContentVO);
        }
        List profitPointContentVOS = BeanMapper.mapList(profitPointContentList, ProfitPointContentVO.class);
        for (ProfitPointContentVO profitPointContentVO : profitPointContentVOS) {
            Long pointContentVOId = profitPointContentVO.getId();
            if (!map.containsKey(pointContentVOId)) continue;
            ProfitTrackContentVO profitTrackContentVO = (ProfitTrackContentVO)map.get(pointContentVOId);
            profitPointContentVO.setReviewResult(profitTrackContentVO.getCompleteSituation());
            profitPointContentVO.setStatus(profitTrackContentVO.getState());
            profitPointContentVO.setActualTime(profitTrackContentVO.getActualCompleteTime());
        }
        vo.setProfitPointContentList(profitPointContentVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProfitPointVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProfitPointVO profitPointVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProfitPointVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("unitName", "projectName", "employeeName", "departmentName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProfitPointVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("unitName", "projectName", "employeeName", "departmentName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List profitPointVOS = BeanMapper.mapList((Iterable)list, ProfitPointVO.class);
        profitPointVOS.forEach(item -> {
            Integer billState = item.getBillState();
            String description = BillStateEnum.getEnumByStateCode((Integer)billState).getDescription();
            item.setBillStateName(description);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", profitPointVOS);
        ExcelExport.getInstance().export("ProfitPoint-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProfitPointData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProfitPointVO>> refProfitPointData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProfitPointVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

