package com.ejianc.business.techmanagement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.techmanagement.bean.*;
import com.ejianc.business.techmanagement.service.IProfitPointService;
import com.ejianc.business.techmanagement.service.IProfitTrackContentService;
import com.ejianc.business.techmanagement.service.IProfitTrackService;
import com.ejianc.business.techmanagement.vo.TecRegisterContentVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.techmanagement.service.IProfitPointContentService;
import com.ejianc.business.techmanagement.vo.ProfitPointContentVO;

/**
 * 创效点制定子表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("profitPointContent")
public class ProfitPointContentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private IProfitPointContentService service;

    @Autowired
    private IProfitPointService profitPointService;
    @Autowired
    private IProfitTrackContentService profitTrackContentService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProfitTrackService profitTrackService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProfitPointContentVO> saveOrUpdate(@RequestBody ProfitPointContentVO saveOrUpdateVO) {
    	ProfitPointContentEntity entity = BeanMapper.map(saveOrUpdateVO, ProfitPointContentEntity.class);
    	service.saveOrUpdate(entity, false);
    	ProfitPointContentVO vo = BeanMapper.map(entity, ProfitPointContentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProfitPointContentVO> queryDetail(Long id) {
    	ProfitPointContentEntity entity = service.selectById(id);
    	ProfitPointContentVO vo = BeanMapper.map(entity, ProfitPointContentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProfitPointContentVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProfitPointContentVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProfitPointContentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProfitPointContentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        IPage<ProfitPointContentEntity> page = service.queryPage(param,false);
        IPage<ProfitPointContentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProfitPointContentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProfitPointContentEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProfitPointContent-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProfitPointContentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProfitPointContentVO>> refProfitPointContentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long>profitTrackIds=new ArrayList<>();
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            Long projectId = _con.getLongValue("projectId");
            LambdaQueryWrapper<ProfitPointEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ProfitPointEntity::getProjectId,projectId);
            queryWrapper.eq(ProfitPointEntity::getDr,0);
            List<ProfitPointEntity> list = profitPointService.list(queryWrapper);
            if (CollectionUtils.isEmpty(list)){
                //返回零条数据直接
                IPage<ProfitPointContentVO> pageData = new Page<>(pageNumber, pageSize, 0);
                pageData.setRecords(new ArrayList<>());
                return CommonResponse.success("查询参照数据成功！",pageData);
            }
            ProfitPointEntity profitPointEntity = list.get(0);
            Integer billState = profitPointEntity.getBillState();
            if (BillStateEnum.getEnumByStateCode(billState)!=BillStateEnum.COMMITED_STATE &&
                    BillStateEnum.getEnumByStateCode(billState)!=BillStateEnum.PASSED_STATE){
                IPage<ProfitPointContentVO> pageData = new Page<>(pageNumber, pageSize, 0);
                pageData.setRecords(new ArrayList<>());
                return CommonResponse.success("查询参照数据成功！",pageData);
            }
            param.getParams().put("pointId", new Parameter(QueryParam.EQ, profitPointEntity.getId()));
            LambdaQueryWrapper<ProfitTrackEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ProfitTrackEntity::getProjectId,projectId);
            wrapper.in(ProfitTrackEntity::getBillState,Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            List<ProfitTrackEntity> profitTrackEntities = profitTrackService.list(wrapper);
            profitTrackIds = profitTrackEntities.stream().map(ProfitTrackEntity::getId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(profitTrackIds)){
            IPage<ProfitPointContentEntity> page = service.queryPage(param,false);
            IPage<ProfitPointContentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProfitPointContentVO.class));

            return CommonResponse.success("查询参照数据成功！",pageData);
        }


        IPage<ProfitPointContentEntity> page = service.queryPage(param,false);
        List<ProfitPointContentEntity> records = page.getRecords();
        List<Long>ids=records.stream().map(ProfitPointContentEntity::getId).collect(Collectors.toList());

        LambdaQueryWrapper<ProfitTrackContentEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(ProfitTrackContentEntity::getPointContentId,ids);
        queryWrapper.in(ProfitTrackContentEntity::getTrackId,profitTrackIds);
        List<ProfitTrackContentEntity> list = profitTrackContentService.list(queryWrapper);
        list.forEach(profitTrackContentEntity -> {
            if (profitTrackContentEntity.getState().equals("已完成")){
                Long pointContentId = profitTrackContentEntity.getPointContentId();
                //records中移除id为pointContentId的实体
                records.removeIf(record -> record.getId().equals(pointContentId));
            }
        });
        IPage<ProfitPointContentVO> pageData = new Page<>(pageNumber, pageSize, records.size());
        pageData.setRecords(BeanMapper.mapList(records, ProfitPointContentVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);

//        IPage<ProfitPointContentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(BeanMapper.mapList(records, ProfitPointContentVO.class));
//
//        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
