package com.ejianc.business.techmanagement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.techmanagement.bean.*;
import com.ejianc.business.techmanagement.service.ITecRegisterContentService;
import com.ejianc.business.techmanagement.service.ITecTrackContentService;
import com.ejianc.business.techmanagement.service.ITecTrackService;
import com.ejianc.business.techmanagement.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.techmanagement.service.ITecRegisterService;

/**
 * 新技术登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("tecRegister")
public class TecRegisterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITecTrackService tecTrackService;
    @Autowired
    private ITecTrackContentService tecTrackContentService;
    @Autowired
    private ITecRegisterContentService tecRegisterContentService;

    private static final String BILL_CODE = "NEW-TECHNOLOGY-REGISTER";//此处需要根据实际修改

    @Autowired
    private ITecRegisterService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TecRegisterVO> saveOrUpdate(@RequestBody TecRegisterVO saveOrUpdateVO) {
        if(saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
            CommonResponse<TecRegisterVO> error = getCommonResponse(saveOrUpdateVO);
            if (error != null) return error;
        }else{
            Long id = saveOrUpdateVO.getId();
            TecRegisterEntity tecRegisterEntity = service.selectById(id);
            if (!tecRegisterEntity.getProjectId().equals(saveOrUpdateVO.getProjectId())){
                CommonResponse<TecRegisterVO> error = getCommonResponse(saveOrUpdateVO);
                if (error != null) return error;
            }
        }
//        Long projectId = saveOrUpdateVO.getProjectId();
//        if (projectId!= null){
//            LambdaQueryWrapper<TecRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
//            queryWrapper.eq(TecRegisterEntity::getProjectId,projectId);
//            queryWrapper.eq(TecRegisterEntity::getDr,0);
//            int count = service.count(queryWrapper);
//            if (count > 0){
//                return CommonResponse.error("该项目已存在新技术登记单据，不可重复新增！");
//            }
//        }
    	TecRegisterEntity entity = BeanMapper.map(saveOrUpdateVO, TecRegisterEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.getTecRegisterContentList().forEach(tecRegisterContentEntity -> {
                    tecRegisterContentEntity.setCode(billCode.getData());
                });
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	TecRegisterVO vo = BeanMapper.map(entity, TecRegisterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    private CommonResponse<TecRegisterVO> getCommonResponse(TecRegisterVO saveOrUpdateVO) {
        Long projectId = saveOrUpdateVO.getProjectId();
        if (projectId!= null){
            LambdaQueryWrapper<TecRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(TecRegisterEntity::getProjectId,projectId);
            queryWrapper.eq(TecRegisterEntity::getDr,0);
            int count = service.count(queryWrapper);
            if (count > 0){
                return CommonResponse.error("该项目已存在新技术登记单据，不可重复新增！");
            }
        }
        return null;
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TecRegisterVO> queryDetail(Long id) {
    	TecRegisterEntity entity = service.selectById(id);
    	TecRegisterVO vo = BeanMapper.map(entity, TecRegisterVO.class);
        Integer billState = entity.getBillState();
        BillStateEnum enumByStateCode = BillStateEnum.getEnumByStateCode(billState);
        if (enumByStateCode != BillStateEnum.COMMITED_STATE && enumByStateCode != BillStateEnum.PASSED_STATE){
            return CommonResponse.success("查询详情数据成功！",vo);
        }

        Long projectId = entity.getProjectId();
        if (projectId == null){
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        LambdaQueryWrapper<TecTrackEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TecTrackEntity::getProjectId,projectId);
        queryWrapper.in(TecTrackEntity::getBillState,Arrays.asList(1,3));
        queryWrapper.orderByDesc(TecTrackEntity::getTrackDate,TecTrackEntity::getCreateTime);

        List<TecTrackEntity> list = tecTrackService.list(queryWrapper);
        List<TecTrackVO> tecTrackVOS = BeanMapper.mapList(list, TecTrackVO.class);
        if (CollectionUtils.isEmpty(list)){
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        vo.setReviewStatus(tecTrackVOS);

        List<TecRegisterContentEntity> tecRegisterContentList = entity.getTecRegisterContentList();
        if (CollectionUtils.isEmpty(tecRegisterContentList)){
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        List<Long>trackIds=list.stream().map(TecTrackEntity::getId).collect(Collectors.toList());
        List<Long>ids=tecRegisterContentList.stream().map(TecRegisterContentEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<TecTrackContentEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(TecTrackContentEntity::getRegisterContentId,ids);
        wrapper.in(TecTrackContentEntity::getTecTrackId,trackIds);
        wrapper.eq(TecTrackContentEntity::getRegisterId,entity.getId());
        List<TecTrackContentEntity> tecTrackContentEntities = tecTrackContentService.list(wrapper);
        List<TecTrackContentVO> tecTrackContentVOS = BeanMapper.mapList(tecTrackContentEntities, TecTrackContentVO.class);
        Map<Long, TecTrackContentVO> map=new HashMap<>();
        //trackIds的排名
        Map<Long,Integer> score=new HashMap<>();
        for (int i = 0; i <trackIds.size() ; i++) {
            score.put(trackIds.get(i),i);
        }

        for (TecTrackContentVO tecTrackContentVO: tecTrackContentVOS){
            Long registerContentId = tecTrackContentVO.getRegisterContentId();
            Long tecTrackId = tecTrackContentVO.getTecTrackId();
            if (!map.containsKey(registerContentId)){
                map.put(registerContentId,tecTrackContentVO);
                continue;
            }
            TecTrackContentVO tecTrackContentVO1 = map.get(registerContentId);
            if (score.get(tecTrackId) < score.get(tecTrackContentVO1.getTecTrackId())){
                map.put(registerContentId,tecTrackContentVO);
            }
        }
        List<TecRegisterContentVO> tecRegisterContentVOS = BeanMapper.mapList(tecRegisterContentList, TecRegisterContentVO.class);
        for (TecRegisterContentVO tecRegisterContentVO : tecRegisterContentVOS){
            Long registerContentId = tecRegisterContentVO.getId();
            if (map.containsKey(registerContentId)){
                TecTrackContentVO tecTrackContentVO = map.get(registerContentId);
                tecRegisterContentVO.setReviewResult(tecTrackContentVO.getApplySituation());
            }
        }
        vo.setTecRegisterContentList(tecRegisterContentVOS);
        return CommonResponse.success("查询详情数据成功！",vo);


    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TecRegisterVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TecRegisterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TecRegisterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TecRegisterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","unitName","employeeName","departmentName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        IPage<TecRegisterEntity> page = service.queryPage(param,false);
        List<TecRegisterEntity> records = page.getRecords();
        List<TecRegisterVO> tecRegisterVOS = BeanMapper.mapList(records, TecRegisterVO.class);
        extracted(records, tecRegisterVOS);


        IPage<TecRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(tecRegisterVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private void extracted(List<TecRegisterEntity> records, List<TecRegisterVO> tecRegisterVOS) {
        List<Long>ids= records.stream().map(TecRegisterEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaQueryWrapper<TecRegisterContentEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(TecRegisterContentEntity::getTecRegisterId,ids);
        List<TecRegisterContentEntity> list = tecRegisterContentService.list(queryWrapper);
        Map<Long, List<TecRegisterContentEntity>> resultMap = list.stream()
                .collect(Collectors.groupingBy(TecRegisterContentEntity::getTecRegisterId));
        tecRegisterVOS.forEach(tecRegisterVO -> {
            Long id = tecRegisterVO.getId();
            if (resultMap.containsKey(id)){
                List<TecRegisterContentEntity> tecRegisterContentEntities = resultMap.get(id);
                tecRegisterContentEntities.forEach(tecRegisterContentEntity -> {
                    String tecName = tecRegisterContentEntity.getTecName();
                    if (StringUtils.isNotEmpty(tecName)){
                        if (StringUtils.isEmpty(tecRegisterVO.getNewTecnologyName())){
                            tecRegisterVO.setNewTecnologyName(tecName);
                        }else{
                            tecRegisterVO.setNewTecnologyName(tecRegisterVO.getNewTecnologyName()+","+tecName);
                        }
                    }
                });
            }
        });
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","unitName","employeeName","departmentName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TecRegisterEntity> list = service.queryList(param);
        List<TecRegisterVO> tecRegisterVOS = BeanMapper.mapList(list, TecRegisterVO.class);
        extracted(list,tecRegisterVOS);
        //todo:字段翻译等等
        tecRegisterVOS.forEach(item->{
            Integer billState = item.getBillState();
            String description = BillStateEnum.getEnumByStateCode(billState).getDescription();
            item.setBillStateName(description);

        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", tecRegisterVOS);
        ExcelExport.getInstance().export("TecRegister-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTecRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TecRegisterVO>> refTecRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TecRegisterEntity> page = service.queryPage(param,false);
        IPage<TecRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TecRegisterVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
