/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.techmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.techmanagement.bean.DesignChangeDisclosureEntity;
import com.ejianc.business.techmanagement.bean.DesignChangeEntity;
import com.ejianc.business.techmanagement.service.IDesignChangeDisclosureService;
import com.ejianc.business.techmanagement.service.IDesignChangeService;
import com.ejianc.business.techmanagement.vo.DesignChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"designChange"})
public class DesignChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DESING-CHANGE";
    @Autowired
    private IDesignChangeService service;
    @Autowired
    private IDesignChangeDisclosureService designChangeDisclosureService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DesignChangeVO> saveOrUpdate(@RequestBody DesignChangeVO saveOrUpdateVO) {
        DesignChangeEntity entity = (DesignChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DesignChangeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setDisclosureState(0);
        }
        this.service.saveOrUpdate((Object)entity, false);
        DesignChangeVO vo = (DesignChangeVO)BeanMapper.map((Object)((Object)entity), DesignChangeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DesignChangeVO> queryDetail(Long id) {
        DesignChangeEntity entity = (DesignChangeEntity)((Object)this.service.selectById(id));
        DesignChangeVO vo = (DesignChangeVO)BeanMapper.map((Object)((Object)entity), DesignChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DesignChangeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DesignChangeVO designChangeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DesignChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("secondaryUnits");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("operatingDepartment");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DesignChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("secondaryUnits");
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("operatingDepartment");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.service.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), DesignChangeVO.class);
            list.forEach(e -> {
                e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
                e.setDisclosureStateName(0 == e.getDisclosureState() ? "\u672a\u4ea4\u5e95" : "\u5df2\u4ea4\u5e95");
                e.setChangeTypeName(0 == e.getChangeType() ? "\u8bbe\u8ba1\u53d8\u66f4" : "\u5de5\u7a0b\u6d3d\u5546");
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("DesignChange-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refDesignChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DesignChangeVO>> refDesignChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("changeName");
        fuzzyFields.add("changeType");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"projectId")) {
            Long projectId = _con.getLongValue("projectId");
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            List list = this.designChangeDisclosureService.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List ids = list.stream().map(DesignChangeDisclosureEntity::getDesignChangeId).collect(Collectors.toList());
                param.getParams().put("id", new Parameter("not_in", ids));
                param.getParams().put("dr", new Parameter("ne", (Object)1));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DesignChangeVO.class));
        pageData.getRecords().forEach(e -> e.setChangeTypeName(0 == e.getChangeType() ? "\u8bbe\u8ba1\u53d8\u66f4" : "\u5de5\u7a0b\u6d3d\u5546"));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

