/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.techmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.techmanagement.bean.SchemeEntity;
import com.ejianc.business.techmanagement.service.ISchemeService;
import com.ejianc.business.techmanagement.vo.SchemeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scheme"})
public class SchemeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SCHEME";
    @Autowired
    private ISchemeService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SchemeVO> saveOrUpdate(@RequestBody SchemeVO saveOrUpdateVO) {
        List<SchemeEntity> codeData;
        SchemeEntity entity = (SchemeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SchemeEntity.class));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity.getCode()}) && (codeData = this.service.queryByCode(entity.getCode(), entity.getId())) != null && codeData.size() > 0) {
            throw new BusinessException("\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            if (null == entity.getCode()) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0L) {
                SchemeEntity uniqueBean = (SchemeEntity)((Object)this.service.selectById(entity.getParentId()));
                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
        } else {
            SchemeEntity schemeEntity = (SchemeEntity)((Object)this.service.selectById(entity.getId()));
            schemeEntity.setName(saveOrUpdateVO.getName());
            schemeEntity.setCode(saveOrUpdateVO.getCode());
            schemeEntity.setDescription(saveOrUpdateVO.getDescription());
            schemeEntity.setCodePlan(saveOrUpdateVO.getCodePlan());
            schemeEntity.setSequence(saveOrUpdateVO.getSequence());
            entity = schemeEntity;
            this.service.update((Wrapper)((UpdateWrapper)new UpdateWrapper().like((Object)"inner_code", (Object)entity.getInnerCode())).set((Object)"code_plan", (Object)entity.getCodePlan()));
        }
        this.service.saveOrUpdate((Object)entity, false);
        SchemeVO vo = (SchemeVO)BeanMapper.map((Object)this.service.selectById(entity.getId()), SchemeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SchemeVO> queryDetail(Long id) {
        SchemeEntity entity = (SchemeEntity)((Object)this.service.selectById(id));
        SchemeVO vo = (SchemeVO)BeanMapper.map((Object)((Object)entity), SchemeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                List<SchemeVO> children = this.service.queryListByPid(id);
                if (children == null || children.size() <= 0) continue;
                for (SchemeVO child : children) {
                    if (ids.contains(child.getId())) continue;
                    return CommonResponse.error((String)("\u65b9\u6848\u3010" + child.getName() + "\u3011\u4e0b\u6709\u5b50\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
                }
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        List<SchemeEntity> dataList = this.service.querySchemeList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("isLeaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("name", "code"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Scheme-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSchemeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SchemeVO>> refSchemeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("name", "code"));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SchemeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySchemeTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SchemeVO> querySchemeTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        List<SchemeVO> dataList = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("name", searchText);
            }
            if (pid != null) {
                params.put("parentId", pid);
            } else if (StringUtils.isNotEmpty((CharSequence)condition)) {
                Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
                if (null != conditionMap.get("pid")) {
                    params.put("parentId", conditionMap.get("pid").toString());
                } else {
                    params.put("noParentId", true);
                }
            } else {
                params.put("noParentId", true);
            }
            dataList = this.service.queryListEntityTree(params);
            dataList.forEach(l -> {
                if (!l.getIsLeaf().booleanValue()) {
                    l.setChildren(new ArrayList());
                    l.setIsParent(Boolean.valueOf(true));
                } else {
                    l.setIsParent(Boolean.valueOf(false));
                }
            });
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                return dataList;
            }
            return SchemeController.createTreeDataVO(dataList);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6240\u6709\u6a21\u5757\u6811\u5f02\u5e38: ", (Throwable)e);
            return null;
        }
    }

    public static List<SchemeVO> createTreeDataVO(List<SchemeVO> list) {
        ArrayList<SchemeVO> resp = new ArrayList<SchemeVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SchemeVO> listMap = new HashMap<String, SchemeVO>();
        for (SchemeVO orgEntity : list) {
            listMap.put(orgEntity.getId().toString(), orgEntity);
        }
        for (int i = 0; i < list.size(); ++i) {
            SchemeVO orgEntity;
            orgEntity = list.get(i);
            String parentId = orgEntity.getParentId() != null && orgEntity.getParentId() > 0L ? orgEntity.getParentId().toString() : "";
            SchemeVO parent = (SchemeVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(orgEntity);
                    continue;
                }
                ArrayList<SchemeVO> children = new ArrayList<SchemeVO>();
                children.add(orgEntity);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(orgEntity.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((SchemeVO)listMap.get(rootId));
        }
        return resp;
    }

    @RequestMapping(value={"/queryListNewTree"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryListNewTree(@RequestBody QueryParam queryParam) {
        List<SchemeVO> dataList = null;
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (paramMap.containsKey("name")) {
            params.put("name", ((Parameter)paramMap.get("name")).getValue());
        }
        if (paramMap.containsKey("code")) {
            params.put("code", ((Parameter)paramMap.get("code")).getValue());
        }
        if (paramMap.containsKey("parentId")) {
            params.put("parentId", ((Parameter)paramMap.get("parentId")).getValue());
        }
        dataList = this.service.queryListEntityTree(params);
        dataList.forEach(l -> {
            if (!l.getIsLeaf().booleanValue()) {
                l.setChildren(new ArrayList());
                l.setIsParent(Boolean.valueOf(true));
            } else {
                l.setIsParent(Boolean.valueOf(false));
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", SchemeController.createTreeDataVO(dataList));
        return CommonResponse.success((Object)jsonObject);
    }
}

