/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.techmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.techmanagement.bean.TecMeterEntity;
import com.ejianc.business.techmanagement.service.ITecMeterContentService;
import com.ejianc.business.techmanagement.service.ITecMeterService;
import com.ejianc.business.techmanagement.vo.TecMeterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.sql.Date;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"tecMeter"})
public class TecMeterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITecMeterContentService tecMeterContentService;
    private static final String BILL_CODE = "TECHNOLOGY-MEASUREMENT-INSTRUMENT";
    @Autowired
    private ITecMeterService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TecMeterVO> saveOrUpdate(@RequestBody TecMeterVO saveOrUpdateVO) {
        TecMeterEntity entity = (TecMeterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TecMeterEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        TecMeterVO vo = (TecMeterVO)BeanMapper.map((Object)((Object)entity), TecMeterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TecMeterVO> queryDetail(Long id) {
        TecMeterEntity entity = (TecMeterEntity)((Object)this.service.selectById(id));
        TecMeterVO vo = (TecMeterVO)BeanMapper.map((Object)((Object)entity), TecMeterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TecMeterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TecMeterVO tecMeterVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TecMeterVO>> queryList(@RequestBody QueryParam param) {
        Parameter state = (Parameter)param.getParams().get("state");
        if (state != null) {
            if (state.getValue().equals("0")) {
                param.getParams().put("validDate", new Parameter("gt", (Object)new java.util.Date()));
            } else {
                param.getParams().put("validDate", new Parameter("le", (Object)new java.util.Date()));
            }
            param.getParams().remove("state");
            if (!param.getParams().containsKey("billState")) {
                param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
            }
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "unitName", "instrumentName", "instrumentCode"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        List records = page.getRecords();
        records.forEach(tecMeterEntity -> this.computeAndSetState((TecMeterEntity)((Object)tecMeterEntity)));
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TecMeterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void computeAndSetState(TecMeterEntity tecMeterEntity) {
        Integer billState = tecMeterEntity.getBillState();
        if (!Objects.equals(billState, BillStateEnum.COMMITED_STATE.getBillStateCode()) && !Objects.equals(billState, BillStateEnum.PASSED_STATE.getBillStateCode())) {
            tecMeterEntity.setState(null);
            tecMeterEntity.setStateCode(0);
            return;
        }
        Date validDate = new Date(tecMeterEntity.getValidDate().getTime());
        LocalDate validLocalDate = validDate.toLocalDate();
        LocalDate now = LocalDate.now();
        long daysBetween = ChronoUnit.DAYS.between(now, validLocalDate);
        if (daysBetween >= 0L) {
            if (daysBetween <= 30L) {
                tecMeterEntity.setState("\u672a\u5230\u671f\uff08\u5269\u4f59" + daysBetween + "\u5929\uff09");
                tecMeterEntity.setStateCode(1);
            } else {
                tecMeterEntity.setState("\u672a\u5230\u671f");
                tecMeterEntity.setStateCode(2);
            }
        } else {
            tecMeterEntity.setState("\u5df2\u5230\u671f\uff08\u5df2\u8fc7" + -daysBetween + "\u5929\uff09");
            tecMeterEntity.setStateCode(3);
        }
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Parameter state = (Parameter)param.getParams().get("state");
        if (state != null) {
            if (state.getValue().equals("0")) {
                param.getParams().put("validDate", new Parameter("gt", (Object)new java.util.Date()));
            } else {
                param.getParams().put("validDate", new Parameter("le", (Object)new java.util.Date()));
            }
            param.getParams().remove("state");
            if (!param.getParams().containsKey("billState")) {
                param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
            }
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "unitName", "instrumentName", "instrumentCode"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        list.forEach(this::computeAndSetState);
        List tecMeterVOS = BeanMapper.mapList((Iterable)list, TecMeterVO.class);
        tecMeterVOS.forEach(item -> {
            Integer billState = item.getBillState();
            String description = BillStateEnum.getEnumByStateCode((Integer)billState).getDescription();
            item.setBillStateName(description);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", tecMeterVOS);
        ExcelExport.getInstance().export("TecMeter-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTecMeterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TecMeterVO>> refTecMeterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TecMeterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

