package com.ejianc.business.constructor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.constructor.vo.YearTechnologyIndexPlanZiVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 年度科技指标计划
 * 
 * @author generator
 * 
 */
public class YearTechnologyIndexPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long projectId; // 项目
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date year; // 年份
    private Long departmentId; // 单位
    private String departmentName; // 单位名称
    
    private List<YearTechnologyIndexPlanZiVO> yearTechnologyIndexPlanZiList = new ArrayList<>(); // 年度科技指标计划子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getYear() {
        return year;
    }

    public void setYear(Date year) {
        this.year = year;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    
     public List<YearTechnologyIndexPlanZiVO> getYearTechnologyIndexPlanZiList() {
        return yearTechnologyIndexPlanZiList;
     }

     public void setYearTechnologyIndexPlanZiList(List<YearTechnologyIndexPlanZiVO> yearTechnologyIndexPlanZiList) {
        this.yearTechnologyIndexPlanZiList = yearTechnologyIndexPlanZiList;
     }
}
