package com.ejianc.business.constructor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 年度科技指标计划子表
 * 
 * @author generator
 * 
 */
public class YearTechnologyIndexPlanZiVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long zhuId; // 主表id
    private Long yjlbId; // 业绩类别id
    private String yjlbCode; // 业绩类别名称
    private String yjlbName; // 业绩类别名称
    private String yearTechnologyIndexPlanName; // 名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 计划完成日期
    private Long personLiableId; // 责任人
    private String personLiableName; // 责任人名称
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getZhuId() {
        return zhuId;
    }

    public void setZhuId(Long zhuId) {
        this.zhuId = zhuId;
    }
    @ReferSerialTransfer(referCode="companypfm_yjlb")
    public Long getYjlbId() {
        return yjlbId;
    }
    @ReferDeserialTransfer
    public void setYjlbId(Long yjlbId) {
        this.yjlbId = yjlbId;
    }
    public String getYjlbCode() {
        return yjlbCode;
    }

    public void setYjlbCode(String yjlbCode) {
        this.yjlbCode = yjlbCode;
    }
    public String getYjlbName() {
        return yjlbName;
    }

    public void setYjlbName(String yjlbName) {
        this.yjlbName = yjlbName;
    }
    public String getYearTechnologyIndexPlanName() {
        return yearTechnologyIndexPlanName;
    }

    public void setYearTechnologyIndexPlanName(String yearTechnologyIndexPlanName) {
        this.yearTechnologyIndexPlanName = yearTechnologyIndexPlanName;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getPersonLiableId() {
        return personLiableId;
    }
    @ReferDeserialTransfer
    public void setPersonLiableId(Long personLiableId) {
        this.personLiableId = personLiableId;
    }
    public String getPersonLiableName() {
        return personLiableName;
    }

    public void setPersonLiableName(String personLiableName) {
        this.personLiableName = personLiableName;
    }
    
}
