/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.constructor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.bean.XmshfaEntity;
import com.ejianc.business.constructor.service.IXmshfaService;
import com.ejianc.business.constructor.vo.XmshfaVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"xmshfa"})
public class XmshfaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "jsgl_xmshfa";
    @Autowired
    private IXmshfaService service;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<XmshfaVO> saveOrUpdate(@RequestBody XmshfaVO saveOrUpdateVO) {
        XmshfaEntity entity = (XmshfaEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, XmshfaEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        entity.setTags("xmshfa");
        entity.setDocsource(1);
        this.service.saveOrUpdate((Object)entity, false);
        XmshfaVO vo = (XmshfaVO)BeanMapper.map((Object)((Object)entity), XmshfaVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<XmshfaVO> queryDetail(Long id) {
        XmshfaEntity entity = (XmshfaEntity)((Object)this.service.selectById(id));
        XmshfaVO vo = (XmshfaVO)BeanMapper.map((Object)((Object)entity), XmshfaVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<XmshfaVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (XmshfaVO xmshfaVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<XmshfaVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("famc");
        fuzzyFields.add("falxName");
        fuzzyFields.add("gcxmmcName");
        fuzzyFields.add("sgdwName");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), XmshfaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("famc");
        fuzzyFields.add("falxName");
        fuzzyFields.add("gcxmmcName");
        fuzzyFields.add("sgdwName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List vos = new ArrayList();
        if (ListUtil.isNotEmpty((List)list)) {
            vos = BeanMapper.mapList((Iterable)list, XmshfaVO.class);
            for (XmshfaVO vo : vos) {
                if (vo.getJlsq() != null) {
                    switch (vo.getJlsq()) {
                        case 0: {
                            vo.setJlsqName("\u662f");
                            break;
                        }
                        case 1: {
                            vo.setJlsqName("\u5426");
                        }
                    }
                }
                if (vo.getDocsource() != null) {
                    switch (vo.getDocsource()) {
                        case 0: {
                            vo.setDocsourceName("\u5df2\u4e0a\u4f20");
                            break;
                        }
                        case 1: {
                            vo.setDocsourceName("\u672a\u4e0a\u4f20");
                        }
                    }
                }
                if (vo.getGd() == null) continue;
                switch (vo.getGd()) {
                    case 0: {
                        vo.setGdName("\u5df2\u5f52\u6863");
                        break;
                    }
                    case 1: {
                        vo.setGdName("\u672a\u5f52\u6863");
                    }
                }
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", vos);
        ExcelExport.getInstance().export("Xmshfa-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refXmshfaData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<XmshfaVO>> refXmshfaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), XmshfaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<XmshfaVO> update(@RequestBody XmshfaVO updateVO) {
        XmshfaEntity sfhsfaEntity = (XmshfaEntity)((Object)this.service.selectById(updateVO.getId()));
        sfhsfaEntity.setBilltype(updateVO.getBilltype());
        sfhsfaEntity.setFileid(updateVO.getFileid());
        sfhsfaEntity.setFilename(updateVO.getFilename());
        sfhsfaEntity.setFilesize(updateVO.getFilesize());
        sfhsfaEntity.setFilepath(updateVO.getFilepath());
        sfhsfaEntity.setOnlinepath(updateVO.getOnlinepath());
        sfhsfaEntity.setSuperviseuserid(updateVO.getSuperviseuserid());
        sfhsfaEntity.setSuperviseusername(updateVO.getSuperviseusername());
        sfhsfaEntity.setSupervisetime(updateVO.getSupervisetime());
        sfhsfaEntity.setDocsource(updateVO.getDocsource());
        sfhsfaEntity.setSourceid(updateVO.getSourceid());
        sfhsfaEntity.setOrgidfield(updateVO.getOrgidfield());
        sfhsfaEntity.setProjectidfield(updateVO.getProjectidfield());
        sfhsfaEntity.setDetailpageurl(updateVO.getDetailpageurl());
        sfhsfaEntity.setBillcodefield(updateVO.getBillcodefield());
        sfhsfaEntity.setFiletype(updateVO.getFiletype());
        if (updateVO.getGd().equals(0)) {
            sfhsfaEntity.setGd(0);
        }
        this.service.updateById((Object)sfhsfaEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }
}

