package com.ejianc.business.tender.stuff.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.tender.stuff.vo.StuffDocumentDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentRecordVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSchemeVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffBidVO;
import com.ejianc.business.tender.stuff.vo.StuffBidDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffBidSupplierVO;

/**
 * 招标文件主表
 * 
 * @author generator
 * 
 */
@ApiModel("招标文件主表")
public class StuffDocumentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标立项主键")
    private java.lang.Long inviteId;
    @ApiModelProperty("招标公告主键")
    private java.lang.Long noticeId;
    @ApiModelProperty("单据编号")
    private java.lang.String billCode;
    @ApiModelProperty("文件名称")
    private java.lang.String documentName;
    @ApiModelProperty("项目ID")
    private java.lang.Long projectId;
    @ApiModelProperty("项目名称")
    private java.lang.String projectName;
    @ApiModelProperty("招标联系人")
    private java.lang.Long employeeId;
    @ApiModelProperty("招标联系人名称")
    private java.lang.String employeeName;
    @ApiModelProperty("招标联系人电话")
    private java.lang.String employeeMobile;
    @ApiModelProperty("备注")
    private java.lang.String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private java.lang.Integer billState;
    @ApiModelProperty("计价方式(0-固定单价,1-浮动单价,2-固定总额)")
    private java.lang.Integer valueType;
    @ApiModelProperty("项目编号")
    private java.lang.String projectCode;
    @ApiModelProperty("组织")
    private java.lang.Long orgId;
    @ApiModelProperty("组织名称")
    private java.lang.String orgName;
    @ApiModelProperty("父级组织")
    private java.lang.Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private java.lang.String parentOrgName;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private java.lang.Integer purchaseType;
    @ApiModelProperty("项目联系人")
    private java.lang.String projectLinkName;
    @ApiModelProperty("项目联系人电话")
    private java.lang.String projectLinkPhone;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("报价开始时间")
    private java.util.Date offerStartTime;
    @ApiModelProperty("报价结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date offerEndTime;
    @ApiModelProperty("是否允许多品牌报价,0-是,1-否")
    private java.lang.Integer brandFlag;
    @ApiModelProperty("是否发布,0-是,1-否")
    private java.lang.Integer publishFlag;
    @ApiModelProperty("是否开标,0-是,1-否")
    private java.lang.Integer bidFlag;
    @ApiModelProperty("招标单位ID")
    private java.lang.Long unitId;
    @ApiModelProperty("招标单位名称")
    private java.lang.String unitName;
    @ApiModelProperty("文件内容")
    private java.lang.String documentContent;
    @ApiModelProperty(" 招标方式")
    private java.lang.Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)
    @ApiModelProperty("招标文件物料详情表")
    private List<StuffDocumentDetailVO> stuffDocumentDetailList = new ArrayList<>();
    @ApiModelProperty("招标文件物料详情表(报价详情用)")
    private List<StuffDocumentDetailVO> stuffDocumentDetailSellList = new ArrayList<>();
    @ApiModelProperty("招标文件截止日期变更记录表")
    private List<StuffDocumentRecordVO> stuffDocumentRecordList = new ArrayList<>();
    @ApiModelProperty("招标文件方案表")
    private List<StuffDocumentSchemeVO> stuffDocumentSchemeList = new ArrayList<>();
    @ApiModelProperty("招标文件报价表")
    private List<StuffDocumentSellVO> stuffDocumentSellList = new ArrayList<>();
    @ApiModelProperty("招标文件供应商标")
    private List<StuffDocumentSupplierVO> stuffDocumentSupplierList = new ArrayList<>();
    @ApiModelProperty("招标文件供应商标方案报价表(界面设计器避键值免重复设计)")
    private List<StuffDocumentSupplierVO> stuffDocumentSupplierSchemeList = new ArrayList<>();
    @ApiModelProperty("招标文件供应商标方案报价表(界面设计器避键值免重复设计)")
    private List<StuffDocumentExpertVO> expertVOList = new ArrayList<>();
    @ApiModelProperty("开标时间")
    private java.util.Date bidTime;
    @ApiModelProperty("是否下一步,0-是,1-否")
    private java.lang.Integer nextFlag;
    private java.lang.String purchaseId; // 采购方式ID
    private java.lang.String purchaseName; // 采购方式名称
    private Long sourceId;
    private List<String> fileNames;
    @ApiModelProperty("报名供应商情况")
    private List<StuffNoticeSupplierVO> stuffDocumentSupplierDetail = new ArrayList<>();
    private java.lang.Integer floatingType; // 浮动方式
    private String settlementClause; // 结算条款

    public String getSettlementClause() {
        return settlementClause;
    }

    public void setSettlementClause(String settlementClause) {
        this.settlementClause = settlementClause;
    }

    public Integer getFloatingType() {
        return floatingType;
    }

    public void setFloatingType(Integer floatingType) {
        this.floatingType = floatingType;
    }

    public List<StuffNoticeSupplierVO> getStuffDocumentSupplierDetail() {
        return stuffDocumentSupplierDetail;
    }

    public void setStuffDocumentSupplierDetail(List<StuffNoticeSupplierVO> stuffDocumentSupplierDetail) {
        this.stuffDocumentSupplierDetail = stuffDocumentSupplierDetail;
    }

    public List<StuffDocumentExpertVO> getExpertVOList() {
        return expertVOList;
    }

    public void setExpertVOList(List<StuffDocumentExpertVO> expertVOList) {
        this.expertVOList = expertVOList;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public List<String> getFileNames() {
        return fileNames;
    }

    public void setFileNames(List<String> fileNames) {
        this.fileNames = fileNames;
    }

    public List<StuffDocumentDetailVO> getStuffDocumentDetailSellList() {
        return stuffDocumentDetailSellList;
    }

    public void setStuffDocumentDetailSellList(List<StuffDocumentDetailVO> stuffDocumentDetailSellList) {
        this.stuffDocumentDetailSellList = stuffDocumentDetailSellList;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public Integer getNextFlag() {
        return nextFlag;
    }

    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }

    public Date getBidTime() {
        return bidTime;
    }

    public void setBidTime(Date bidTime) {
        this.bidTime = bidTime;
    }

    public Integer getTenderType() {
        return tenderType;
    }

    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }

    public List<StuffDocumentSupplierVO> getStuffDocumentSupplierSchemeList() {
        return stuffDocumentSupplierSchemeList;
    }

    public void setStuffDocumentSupplierSchemeList(List<StuffDocumentSupplierVO> stuffDocumentSupplierSchemeList) {
        this.stuffDocumentSupplierSchemeList = stuffDocumentSupplierSchemeList;
    }

    public String getDocumentContent() {
        return documentContent;
    }

    public void setDocumentContent(String documentContent) {
        this.documentContent = documentContent;
    }

    /**
     * 招标立项主键
     */
    public java.lang.Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(java.lang.Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 招标公告主键
     */
    public java.lang.Long getNoticeId() {
        return noticeId;
    }

    /**
     * 招标公告主键
     */
    public void setNoticeId(java.lang.Long noticeId) {
        this.noticeId = noticeId;
    }
    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 文件名称
     */
    public java.lang.String getDocumentName() {
        return documentName;
    }

    /**
     * 文件名称
     */
    public void setDocumentName(java.lang.String documentName) {
        this.documentName = documentName;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode = "project-set")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 招标联系人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public java.lang.String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(java.lang.String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public java.lang.Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(java.lang.Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 项目编号
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public java.lang.Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(java.lang.Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public java.lang.String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(java.lang.String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public java.lang.Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(java.lang.Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 项目联系人
     */
    public java.lang.String getProjectLinkName() {
        return projectLinkName;
    }

    /**
     * 项目联系人
     */
    public void setProjectLinkName(java.lang.String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }
    /**
     * 项目联系人电话
     */
    public java.lang.String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    /**
     * 项目联系人电话
     */
    public void setProjectLinkPhone(java.lang.String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }
    /**
     * 报价开始时间
     */
    public java.util.Date getOfferStartTime() {
        return offerStartTime;
    }

    /**
     * 报价开始时间
     */
    public void setOfferStartTime(java.util.Date offerStartTime) {
        this.offerStartTime = offerStartTime;
    }
    /**
     * 报价结束时间
     */
    public java.util.Date getOfferEndTime() {
        return offerEndTime;
    }

    /**
     * 报价结束时间
     */
    public void setOfferEndTime(java.util.Date offerEndTime) {
        this.offerEndTime = offerEndTime;
    }
    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public java.lang.Integer getBrandFlag() {
        return brandFlag;
    }

    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public void setBrandFlag(java.lang.Integer brandFlag) {
        this.brandFlag = brandFlag;
    }
    /**
     * 是否发布,0-是,1-否
     */
    public java.lang.Integer getPublishFlag() {
        return publishFlag;
    }

    /**
     * 是否发布,0-是,1-否
     */
    public void setPublishFlag(java.lang.Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    /**
     * 是否开标,0-是,1-否
     */
    public java.lang.Integer getBidFlag() {
        return bidFlag;
    }

    /**
     * 是否开标,0-是,1-否
     */
    public void setBidFlag(java.lang.Integer bidFlag) {
        this.bidFlag = bidFlag;
    }
    /**
     * 招标单位ID
     */
    public java.lang.Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    public void setUnitId(java.lang.Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public java.lang.String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(java.lang.String unitName) {
        this.unitName = unitName;
    }

    public List<StuffDocumentDetailVO> getStuffDocumentDetailList() {
        return stuffDocumentDetailList;
    }

    public void setStuffDocumentDetailList(List<StuffDocumentDetailVO> stuffDocumentDetailList) {
        this.stuffDocumentDetailList = stuffDocumentDetailList;
    }

    public List<StuffDocumentRecordVO> getStuffDocumentRecordList() {
        return stuffDocumentRecordList;
    }

    public void setStuffDocumentRecordList(List<StuffDocumentRecordVO> stuffDocumentRecordList) {
        this.stuffDocumentRecordList = stuffDocumentRecordList;
    }

    public List<StuffDocumentSchemeVO> getStuffDocumentSchemeList() {
        return stuffDocumentSchemeList;
    }

    public void setStuffDocumentSchemeList(List<StuffDocumentSchemeVO> stuffDocumentSchemeList) {
        this.stuffDocumentSchemeList = stuffDocumentSchemeList;
    }

    public List<StuffDocumentSellVO> getStuffDocumentSellList() {
        return stuffDocumentSellList;
    }

    public void setStuffDocumentSellList(List<StuffDocumentSellVO> stuffDocumentSellList) {
        this.stuffDocumentSellList = stuffDocumentSellList;
    }

    public List<StuffDocumentSupplierVO> getStuffDocumentSupplierList() {
        return stuffDocumentSupplierList;
    }

    public void setStuffDocumentSupplierList(List<StuffDocumentSupplierVO> stuffDocumentSupplierList) {
        this.stuffDocumentSupplierList = stuffDocumentSupplierList;
    }
}
