package com.ejianc.business.tender.buildmaterial.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 筑材网工作交接
 * 
 * @author generator
 * 
 */
public class PublishTenderVO {
    private static final long serialVersionUID = 1L;
    private String additionalRemarks; // 补充说明,f
    private Integer bidType; // 招标类型: 1.材料采购、3.设备租赁 f

    private Integer bidWay; //招标方式: 1.公开、2，邀请（定向），默认为公开 f
    /**
     * 接入业务标识: 可以是接入系统中的数据主键或其他唯一业务标识，不可重复，是此后对此数据进行变更，识别的标识性字段 t
     */
    private String bizKey;

    /**
     * 招标联系人: 招标联系人和联系方式，如：[’张三’,’13999999999’] t
     */
    private String[] contactPerson;


    /**
     * 报价截止时间: 报价截止时间，精确到秒 yyyy-mm-dd HH:mm:ss t
     */
    private String dateExpired;


    /**
     * 	交付地点: 采购标的的交付地址，需要按筑材网的省市区三级行政单位按数组形式提交，如：[”江苏”,”南通市”,”通州区”,”川姜镇菜市场”] t
     */
    private String[] deliveryAddress;

    /**
     * 	邀请供应商: 指定邀请投标的供应商名,如：[”上海申捷管业科技有限公司”,”上海久源经贸发展有限公司”] f
     */
    private String[] inviteSuppliers;

    private Integer invoiceRequire; // 发票要求: 1.增值税专用发票、2.增值税普通发票、3.普通发票，默认为1.增值税专用发票 f


    /**
     * 	预估总价: 大致的招标预算(必须为大于1000的整数，且只保留前2位有效数值，剩余位数以0代替) t
     */
    private Integer moneyEstimated;

    /**
     * 	付款约定: 文字表述结算方式和支付方式等信息 f
     */
    private String paymentAgreement;



    /**
     * 	项目名称: 招标项目，必须和筑材网存在的项目名一致	t
     */
    private String projectName;

    /**
     * 	期望交付日期: 交付日期，精确到日 yyyy-mm-dd t
     */
    private String receivingDateExpect;


    /**
     * 招标发起人: 筑材网账号名 t
     */
    private String username;


    /**
     * 	招标技术联系人: 如：[’张三’,’13999999999’] f
     */
    private String[] techContactPerson;

    /**
     *是否含税: 默认为“是”，表含税
     */
    private Boolean taxInclude;

    private List<PublishTenderAttachmentsVO> attachments = new ArrayList<>();//招标附件: 详见招标附件字段,t

    private List<PublishTenderProductsVO> products = new ArrayList<>();//招标附件: 详见招标附件字段,t


    public String getAdditionalRemarks() {
        return additionalRemarks;
    }

    public void setAdditionalRemarks(String additionalRemarks) {
        this.additionalRemarks = additionalRemarks;
    }

    public Integer getBidType() {
        return bidType;
    }

    public void setBidType(Integer bidType) {
        this.bidType = bidType;
    }

    public Integer getBidWay() {
        return bidWay;
    }

    public void setBidWay(Integer bidWay) {
        this.bidWay = bidWay;
    }

    public String getBizKey() {
        return bizKey;
    }

    public void setBizKey(String bizKey) {
        this.bizKey = bizKey;
    }

    public String[] getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String[] contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getDateExpired() {
        return dateExpired;
    }

    public void setDateExpired(String dateExpired) {
        this.dateExpired = dateExpired;
    }

    public String[] getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(String[] deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public String[] getInviteSuppliers() {
        return inviteSuppliers;
    }

    public void setInviteSuppliers(String[] inviteSuppliers) {
        this.inviteSuppliers = inviteSuppliers;
    }

    public Integer getInvoiceRequire() {
        return invoiceRequire;
    }

    public void setInvoiceRequire(Integer invoiceRequire) {
        this.invoiceRequire = invoiceRequire;
    }

    public Integer getMoneyEstimated() {
        return moneyEstimated;
    }

    public void setMoneyEstimated(Integer moneyEstimated) {
        this.moneyEstimated = moneyEstimated;
    }

    public String getPaymentAgreement() {
        return paymentAgreement;
    }

    public void setPaymentAgreement(String paymentAgreement) {
        this.paymentAgreement = paymentAgreement;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getReceivingDateExpect() {
        return receivingDateExpect;
    }

    public void setReceivingDateExpect(String receivingDateExpect) {
        this.receivingDateExpect = receivingDateExpect;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String[] getTechContactPerson() {
        return techContactPerson;
    }

    public void setTechContactPerson(String[] techContactPerson) {
        this.techContactPerson = techContactPerson;
    }

    public Boolean getTaxInclude() {
        return taxInclude;
    }

    public void setTaxInclude(Boolean taxInclude) {
        this.taxInclude = taxInclude;
    }

    public List<PublishTenderAttachmentsVO> getAttachments() {
        return attachments;
    }

    public void setAttachments(List<PublishTenderAttachmentsVO> attachments) {
        this.attachments = attachments;
    }

    public List<PublishTenderProductsVO> getProducts() {
        return products;
    }

    public void setProducts(List<PublishTenderProductsVO> products) {
        this.products = products;
    }
}
