package com.ejianc.business.tender.stuff.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 招标文件供应商标
 * 
 * @author generator
 * 
 */
@ApiModel("招标文件供应商标")
public class StuffDocumentSupplierSellVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("供应商租户主键")
    private String supplierTenantId;
    @ApiModelProperty("供应商ID")
    private Long supplierId;
    @ApiModelProperty("供应商name")
    private String supplierName;
    @ApiModelProperty("报价时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date offerTime;
    @ApiModelProperty("招标立项主键")
    private Long inviteId;
    @ApiModelProperty("联系人")
    private String linkName;
    @ApiModelProperty("联系电话")
    private String linkMobile;
    @ApiModelProperty("发票说明")
    private String taxMemo;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private Integer purchaseType;
    @ApiModelProperty("招标文件方案表")
    private List<StuffDocumentSchemeVO> stuffDocumentSchemeList = new ArrayList<>();
    @ApiModelProperty("多轮报详情")
    private List<StuffTalkVO> stuffTalkVOList = new ArrayList<>();
    @ApiModelProperty("附件名称")
    private String fileName;
    @ApiModelProperty("附件主键")
    private Long attachId;
    @ApiModelProperty("浮动方式")
    private java.lang.Integer floatingType; // 浮动方式
    private Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    public Integer getFloatingType() {
        return floatingType;
    }

    public void setFloatingType(Integer floatingType) {
        this.floatingType = floatingType;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getAttachId() {
        return attachId;
    }

    public void setAttachId(Long attachId) {
        this.attachId = attachId;
    }

    public String getSupplierTenantId() {
        return supplierTenantId;
    }

    public void setSupplierTenantId(String supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public List<StuffTalkVO> getStuffTalkVOList() {
        return stuffTalkVOList;
    }

    public void setStuffTalkVOList(List<StuffTalkVO> stuffTalkVOList) {
        this.stuffTalkVOList = stuffTalkVOList;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getLinkMobile() {
        return linkMobile;
    }

    public void setLinkMobile(String linkMobile) {
        this.linkMobile = linkMobile;
    }

    public String getTaxMemo() {
        return taxMemo;
    }

    public void setTaxMemo(String taxMemo) {
        this.taxMemo = taxMemo;
    }

    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getOfferTime() {
        return offerTime;
    }

    public void setOfferTime(Date offerTime) {
        this.offerTime = offerTime;
    }

    public List<StuffDocumentSchemeVO> getStuffDocumentSchemeList() {
        return stuffDocumentSchemeList;
    }

    public void setStuffDocumentSchemeList(List<StuffDocumentSchemeVO> stuffDocumentSchemeList) {
        this.stuffDocumentSchemeList = stuffDocumentSchemeList;
    }
}
