package com.ejianc.business.tender.sub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.List;

/**
 * 招标公告主表
 * 
 * @author generator
 * 
 */
public class SubNoticeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long inviteId; // 招标ID
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private Long unitId; // 招标单位ID
    private String unitName; // 招标单位名称
    private String noticeName; // 公告名称
    private Long employeeId; // 招标联系人
    private String employeeName; // 招标联系人名称
    private String employeeMobile; // 招标联系人电话
    private Integer publishFlag;
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private java.util.Date noticeStartTime; // 报名开始时间
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private java.util.Date noticeEndTime; // 报名截止时间
    private String memo; // 备注
    private String noticeContent; // 公告内容
    private Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
    private Integer billState; // 单据状态（审批必须字段）
    private String billCode; // 单据编号
    private Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    private Long subType; // 分包类型（0-专业分包，1-劳务分包）

    private List<SubNoticeDetailVO> noticeDetail = new ArrayList<>(); // 材料招标公告采购清单表
    private List<SubNoticeChangeVO> noticeChangeDetail = new ArrayList<>(); // 材料招标公告变更记录表
    private List<SubNoticeSupplierVO> noticeSupplierDetail = new ArrayList<>(); // 材料招标立项供应商表
    private Integer priceShowFlag; // 招标控制价是否显示0否1是
    private String subDescribe; // 分包范围及作业内容简述
    private String settlementClause; // 结算条款

    public String getSettlementClause() {
        return settlementClause;
    }

    public void setSettlementClause(String settlementClause) {
        this.settlementClause = settlementClause;
    }

    public String getSubDescribe() {
        return subDescribe;
    }

    public void setSubDescribe(String subDescribe) {
        this.subDescribe = subDescribe;
    }

    public Integer getPriceShowFlag() {
        return priceShowFlag;
    }

    public void setPriceShowFlag(Integer priceShowFlag) {
        this.priceShowFlag = priceShowFlag;
    }
    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public Integer getPublishFlag() {
        return publishFlag;
    }

    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }

    /**
     * 招标ID
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标ID
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public Long getSubType() {
        return subType;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 招标单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 公告名称
     */
    public String getNoticeName() {
        return noticeName;
    }

    /**
     * 公告名称
     */
    public void setNoticeName(String noticeName) {
        this.noticeName = noticeName;
    }
    /**
     * 招标联系人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 报名开始时间
     */
    public java.util.Date getNoticeStartTime() {
        return noticeStartTime;
    }

    /**
     * 报名开始时间
     */
    public void setNoticeStartTime(java.util.Date noticeStartTime) {
        this.noticeStartTime = noticeStartTime;
    }
    /**
     * 报名截止时间
     */
    public java.util.Date getNoticeEndTime() {
        return noticeEndTime;
    }

    /**
     * 报名截止时间
     */
    public void setNoticeEndTime(java.util.Date noticeEndTime) {
        this.noticeEndTime = noticeEndTime;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 公告内容
     */
    public String getNoticeContent() {
        return noticeContent;
    }

    /**
     * 公告内容
     */
    public void setNoticeContent(String noticeContent) {
        this.noticeContent = noticeContent;
    }
    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public List<SubNoticeDetailVO> getNoticeDetail() {
        return noticeDetail;
    }

    public void setNoticeDetail(List<SubNoticeDetailVO> noticeDetail) {
        this.noticeDetail = noticeDetail;
    }

    public List<SubNoticeChangeVO> getNoticeChangeDetail() {
        return noticeChangeDetail;
    }

    public void setNoticeChangeDetail(List<SubNoticeChangeVO> noticeChangeDetail) {
        this.noticeChangeDetail = noticeChangeDetail;
    }

    public List<SubNoticeSupplierVO> getNoticeSupplierDetail() {
        return noticeSupplierDetail;
    }

    public void setNoticeSupplierDetail(List<SubNoticeSupplierVO> noticeSupplierDetail) {
        this.noticeSupplierDetail = noticeSupplierDetail;
    }
}
