package com.ejianc.business.tender.other.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 中标公告表
 * 
 * @author generator
 * 
 */
@ApiModel("中标公告表")
public class OtherWinnoticeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标立项主键")
    private Long inviteId;
    @ApiModelProperty("定标主键")
    private Long picketageId;
    @ApiModelProperty("标题")
    private String titleName;
    @ApiModelProperty("招标名称")
    private String inviteName;
    @ApiModelProperty("招标单位ID")
    private Long unitId;
    @ApiModelProperty("招标单位名称")
    private String unitName;
    @ApiModelProperty("中标日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date winDate;
    @ApiModelProperty("招标联系人")
    private Long employeeId;
    @ApiModelProperty("招标联系人名称")
    private String employeeName;
    @ApiModelProperty("招标联系人电话")
    private String employeeMobile;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private Integer purchaseType;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("是否发布,0-是,1-否")
    private Integer publishFlag;
    @ApiModelProperty("是否下一步,0-是,1-否")
    private Integer nextFlag;
    @ApiModelProperty("展示截止日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date stopDate;
    @ApiModelProperty("备注")
    private String memo;
    @TableField(value="line_type_name")
    private String lineTypeName; // 材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
    @TableField(value="tender_type_name")
    private String tenderTypeName; //招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)

    private Integer signFlag; // 是否签章0:是，1：否
    @ApiModelProperty("附件名称")
    private String fileName;
    @ApiModelProperty("附件主键")
    private Long attachId;
    private String filePath;

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getAttachId() {
        return attachId;
    }

    public void setAttachId(Long attachId) {
        this.attachId = attachId;
    }
    public Integer getSignFlag() {
        return signFlag;
    }

    public void setSignFlag(Integer signFlag) {
        this.signFlag = signFlag;
    }
    public String getLineTypeName() {
        return lineTypeName;
    }

    public void setLineTypeName(String lineTypeName) {
        this.lineTypeName = lineTypeName;
    }

    public String getTenderTypeName() {
        return tenderTypeName;
    }

    public void setTenderTypeName(String tenderTypeName) {
        this.tenderTypeName = tenderTypeName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getStopDate() {
        return stopDate;
    }

    public void setStopDate(Date stopDate) {
        this.stopDate = stopDate;
    }

    List<OtherPicketageSupplierVO> picketageSupplierList = new ArrayList<OtherPicketageSupplierVO>();

    public Integer getPublishFlag() {
        return publishFlag;
    }

    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }

    public Integer getNextFlag() {
        return nextFlag;
    }

    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }

    public List<OtherPicketageSupplierVO> getPicketageSupplierList() {
        return picketageSupplierList;
    }

    public void setPicketageSupplierList(List<OtherPicketageSupplierVO> picketageSupplierList) {
        this.picketageSupplierList = picketageSupplierList;
    }

    /**
     * 招标立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 定标主键
     */
    public Long getPicketageId() {
        return picketageId;
    }

    /**
     * 定标主键
     */
    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }
    /**
     * 标题
     */
    public String getTitleName() {
        return titleName;
    }

    /**
     * 标题
     */
    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }
    /**
     * 招标名称
     */
    public String getInviteName() {
        return inviteName;
    }

    /**
     * 招标名称
     */
    public void setInviteName(String inviteName) {
        this.inviteName = inviteName;
    }
    /**
     * 招标单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 中标日期
     */
    public Date getWinDate() {
        return winDate;
    }

    /**
     * 中标日期
     */
    public void setWinDate(Date winDate) {
        this.winDate = winDate;
    }
    /**
     * 招标联系人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
