package com.ejianc.business.tender.expert.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tender.stuff.vo.StuffDocumentDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSupplierVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料专家评标主表
 * 
 * @author generator
 * 
 */
public class ExpertEvaluatingVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long templateId; // 模板Id
    private String templateName; // 模板名称
    private String evaluationName; // 评标名称
    private Long employeeId; // 招标联系人
    private String employeeName; // 招标联系人名称
    private String employeeMobile; // 招标联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date startTime; // 评标开始日期
    private String memo; // 备注
    private Long inviteId; // 招标ID
    private Long documentId; // 招标文件主键
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private String type; // 招标类型
    private Integer purchaseType; // 采购方式
    private Integer gatherStatus; // 汇总状态(0-待汇总,1-已汇总)
    private String gatherReason; // 汇总原因
    private String bidNum ; //评标人数
    private Integer inviteType; // 招标类型
    private Integer distinctionFlag; // 是否区分商务/技术（0-是，1-否）
    private Long subType; // 分包类型 ,0-专业分包,1-劳务分包(分包线专用)
    private Long unitId; // 招标单位ID
    private String unitName; // 招标单位名称
    private Integer evaluationState; //
    private java.math.BigDecimal tenderMoney; // 招标金额


    private List stuffDocumentSupplierSchemeList = new ArrayList<>();//按供应商查看报价
    private List stuffDocumentDetailSellList = new ArrayList<>();//按材料查看报价
    private List scoreResult = new ArrayList<>();
    private java.lang.Integer floatingType; // 浮动方式

    public Integer getFloatingType() {
        return floatingType;
    }

    public void setFloatingType(Integer floatingType) {
        this.floatingType = floatingType;
    }
    public BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    public void setTenderMoney(BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }

    public Integer getEvaluationState() {
        return evaluationState;
    }

    public void setEvaluationState(Integer evaluationState) {
        this.evaluationState = evaluationState;
    }

    public Long getSubType() {
        return subType;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }

    public Integer getDistinctionFlag() {
        return distinctionFlag;
    }

    public void setDistinctionFlag(Integer distinctionFlag) {
        this.distinctionFlag = distinctionFlag;
    }

    public Integer getInviteType() {
        return inviteType;
    }

    public void setInviteType(Integer inviteType) {
        this.inviteType = inviteType;
    }

    public String getBidNum() {
        return bidNum;
    }

    public void setBidNum(String bidNum) {
        this.bidNum = bidNum;
    }

    public List getStuffDocumentSupplierSchemeList() {
        return stuffDocumentSupplierSchemeList;
    }

    public void setStuffDocumentSupplierSchemeList(List stuffDocumentSupplierSchemeList) {
        this.stuffDocumentSupplierSchemeList = stuffDocumentSupplierSchemeList;
    }

    public List getStuffDocumentDetailSellList() {
        return stuffDocumentDetailSellList;
    }

    public void setStuffDocumentDetailSellList(List stuffDocumentDetailSellList) {
        this.stuffDocumentDetailSellList = stuffDocumentDetailSellList;
    }

    public List getScoreResult() {
        return scoreResult;
    }

    public void setScoreResult(List scoreResult) {
        this.scoreResult = scoreResult;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private List<ExpertEvaluatingDetailVO> stuffEvaluationDetailEntities = new ArrayList<>(); // 材料专家评标专家子表

    public String getGatherReason() {
        return gatherReason;
    }

    public void setGatherReason(String gatherReason) {
        this.gatherReason = gatherReason;
    }

    /**
     * 采购方式
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 模板Id
     */
    @ReferSerialTransfer(referCode="evaluation_template")
    public Long getTemplateId() {
        return templateId;
    }

    /**
     * 模板Id
     */
    @ReferDeserialTransfer
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
    /**
     * 模板名称
     */
    public String getTemplateName() {
        return templateName;
    }

    /**
     * 模板名称
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
    /**
     * 评标名称
     */
    public String getEvaluationName() {
        return evaluationName;
    }

    /**
     * 评标名称
     */
    public void setEvaluationName(String evaluationName) {
        this.evaluationName = evaluationName;
    }
    /**
     * 招标联系人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 评标开始日期
     */
    public java.util.Date getStartTime() {
        return startTime;
    }

    /**
     * 评标开始日期
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 招标ID
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标ID
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public Integer getGatherStatus() {
        return gatherStatus;
    }

    public void setGatherStatus(Integer gatherStatus) {
        this.gatherStatus = gatherStatus;
    }

    /**
     * 招标文件主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
     /**
      * 材料专家评标专家子表
      */
     public List<ExpertEvaluatingDetailVO> getStuffEvaluationDetailEntities() {
        return stuffEvaluationDetailEntities;
     }

     /**
      * 材料专家评标专家子表
      */
     public void setStuffEvaluationDetailEntities(List<ExpertEvaluatingDetailVO> stuffEvaluationDetailVos) {
        this.stuffEvaluationDetailEntities = stuffEvaluationDetailVos;
     }
}
