package com.ejianc.business.tender.sub.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;


/**
 * 招标文件供应商标
 * 
 * @author generator
 * 
 */
@ApiModel("招标文件供应商标")
public class SubDocumentSupplierVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标文件主键")
    private Long documentId;
    @ApiModelProperty("保证金金额")
    private java.math.BigDecimal depositMoney;
    @ApiModelProperty("保证金日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date depositDate;
    @ApiModelProperty("保证金是否缴纳,0-是,1-否")
    private Integer depositFlag;
    @ApiModelProperty("报名费金额")
    private java.math.BigDecimal registerMoney;
    @ApiModelProperty("报名费是否缴纳,0-是,1-否")
    private Integer registerFlag;
    @ApiModelProperty("报名日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date registerDate;
    @ApiModelProperty("标书费是否缴纳,0-是,1-否")
    private Integer tenderFlag;
    @ApiModelProperty("标书费金额")
    private java.math.BigDecimal tenderMoney;
    @ApiModelProperty("标书日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date tenderDate;
    @ApiModelProperty("报价时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date offerTime;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("供应商租户主键")
    private Long supplierTenantId;
    @ApiModelProperty("供应商ID")
    private Long supplierId;
    @ApiModelProperty("供应商name")
    private String supplierName; // 供应商name
    @ApiModelProperty("方案金额汇总")
    private String schemeMoney;
    @ApiModelProperty("联系人")
    private String linkName;
    @ApiModelProperty("联系电话")
    private String linkMobile;
    @ApiModelProperty("发票说明")
    private String taxMemo;
    @ApiModelProperty("供应商租户来源主键")
    private String sourceSupplierTenantId;
    @ApiModelProperty("洽商轮数")
    private Integer talkNum;
    @ApiModelProperty("附件名称")
    private String fileName;
    @ApiModelProperty("附件主键")
    private Long attachId;
    private Long teamId; // 班组ID
    private String teamCode; // 班组code
    private String teamName; // 班组名称
    private Integer isMobile;//手机端报价标识
    private String taxPayerIdentifier;


    public String getTaxPayerIdentifier() {
        return taxPayerIdentifier;
    }

    public void setTaxPayerIdentifier(String taxPayerIdentifier) {
        this.taxPayerIdentifier = taxPayerIdentifier;
    }

    public Integer getIsMobile() {
        return isMobile;
    }

    public void setIsMobile(Integer isMobile) {
        this.isMobile = isMobile;
    }
    public Long getTeamId() {
        return teamId;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }


    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getAttachId() {
        return attachId;
    }

    public void setAttachId(Long attachId) {
        this.attachId = attachId;
    }

    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSourceSupplierTenantId() {
        return sourceSupplierTenantId;
    }

    public void setSourceSupplierTenantId(String sourceSupplierTenantId) {
        this.sourceSupplierTenantId = sourceSupplierTenantId;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getLinkMobile() {
        return linkMobile;
    }

    public void setLinkMobile(String linkMobile) {
        this.linkMobile = linkMobile;
    }

    public String getTaxMemo() {
        return taxMemo;
    }

    public void setTaxMemo(String taxMemo) {
        this.taxMemo = taxMemo;
    }

    private List<SubDocumentSellVO> subDocumentSellVOList  = new ArrayList<>();

    public List<SubDocumentSellVO> getSubDocumentSellVOList() {
        return subDocumentSellVOList;
    }

    public void setSubDocumentSellVOList(List<SubDocumentSellVO> subDocumentSellVOList) {
        this.subDocumentSellVOList = subDocumentSellVOList;
    }

    public String getSchemeMoney() {
        return schemeMoney;
    }

    public void setSchemeMoney(String schemeMoney) {
        this.schemeMoney = schemeMoney;
    }

    /**
     * 招标文件主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 保证金金额
     */
    public java.math.BigDecimal getDepositMoney() {
        return depositMoney;
    }

    /**
     * 保证金金额
     */
    public void setDepositMoney(java.math.BigDecimal depositMoney) {
        this.depositMoney = depositMoney;
    }
    /**
     * 保证金日期
     */
    public java.util.Date getDepositDate() {
        return depositDate;
    }

    /**
     * 保证金日期
     */
    public void setDepositDate(java.util.Date depositDate) {
        this.depositDate = depositDate;
    }
    /**
     * 保证金是否缴纳,0-是,1-否
     */
    public Integer getDepositFlag() {
        return depositFlag;
    }

    /**
     * 保证金是否缴纳,0-是,1-否
     */
    public void setDepositFlag(Integer depositFlag) {
        this.depositFlag = depositFlag;
    }
    /**
     * 报名费金额
     */
    public java.math.BigDecimal getRegisterMoney() {
        return registerMoney;
    }

    /**
     * 报名费金额
     */
    public void setRegisterMoney(java.math.BigDecimal registerMoney) {
        this.registerMoney = registerMoney;
    }
    /**
     * 报名费是否缴纳,0-是,1-否
     */
    public Integer getRegisterFlag() {
        return registerFlag;
    }

    /**
     * 报名费是否缴纳,0-是,1-否
     */
    public void setRegisterFlag(Integer registerFlag) {
        this.registerFlag = registerFlag;
    }
    /**
     * 报名日期
     */
    public java.util.Date getRegisterDate() {
        return registerDate;
    }

    /**
     * 报名日期
     */
    public void setRegisterDate(java.util.Date registerDate) {
        this.registerDate = registerDate;
    }
    /**
     * 标书费是否缴纳,0-是,1-否
     */
    public Integer getTenderFlag() {
        return tenderFlag;
    }

    /**
     * 标书费是否缴纳,0-是,1-否
     */
    public void setTenderFlag(Integer tenderFlag) {
        this.tenderFlag = tenderFlag;
    }
    /**
     * 标书费金额
     */
    public java.math.BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 标书费金额
     */
    public void setTenderMoney(java.math.BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 标书日期
     */
    public java.util.Date getTenderDate() {
        return tenderDate;
    }

    /**
     * 标书日期
     */
    public void setTenderDate(java.util.Date tenderDate) {
        this.tenderDate = tenderDate;
    }
    /**
     * 标书日期
     */
    public java.util.Date getOfferTime() {
        return offerTime;
    }

    /**
     * 标书日期
     */
    public void setOfferTime(java.util.Date offerTime) {
        this.offerTime = offerTime;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 供应商租户主键
     */
    public Long getSupplierTenantId() {
        return supplierTenantId;
    }

    /**
     * 供应商租户主键
     */
    public void setSupplierTenantId(Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    /**
     * 供应商ID
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商ID
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }



    
}
