/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.expert.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.expert.bean.ExpertEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingDetailService;
import com.ejianc.business.tender.expert.service.IExpertFieldDetailService;
import com.ejianc.business.tender.expert.service.IExpertService;
import com.ejianc.business.tender.expert.service.IRandomRuleService;
import com.ejianc.business.tender.expert.vo.ExpertExportVO;
import com.ejianc.business.tender.expert.vo.ExpertVO;
import com.ejianc.business.tender.expert.vo.RandomExpertVO;
import com.ejianc.business.tender.expert.vo.RandomRuleVO;
import com.ejianc.business.tender.expert.vo.RandomSupplierExpertVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"expert"})
public class ExpertController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IEmployeeApi employeeApi;
    private static final String BILL_CODE = "EXPERT_CODE";
    private static final String EXPERT_CODE = "BT211110000000001";
    @Autowired
    private IExpertService service;
    @Autowired
    private IRandomRuleService randomRuleService;
    @Autowired
    private IExpertEvaluatingDetailService IExpertEvaluatingDetailService;
    @Autowired
    private IExpertFieldDetailService expertFieldDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExpertVO> saveOrUpdate(@RequestBody ExpertVO saveorUpdateVO) {
        ExpertVO vo = this.service.saveOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/startUpdate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExpertVO> startUpdate(@RequestParam Long id, Integer state) {
        ExpertEntity expertEntity = (ExpertEntity)((Object)this.service.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertEvaluatingDetailEntity::getExpertId, (Object)expertEntity.getExpertId());
        lambda.in(ExpertEvaluatingDetailEntity::getEvaluationState, new Object[]{0, 3});
        List list = this.IExpertEvaluatingDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u5355\u636e\u88ab\u5f15\u7528\u4e0d\u80fd\u8c03\u6574\u72b6\u6001\uff01");
        }
        expertEntity.setState(state);
        this.service.saveOrUpdate((Object)expertEntity, false);
        ExpertVO vo = (ExpertVO)BeanMapper.map((Object)((Object)expertEntity), ExpertVO.class);
        return CommonResponse.success((String)"\u542f\u7528\u505c\u7528\u72b6\u6001\u8c03\u6574\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/bidEvaluation"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> bidEvaluation(@RequestParam Long id) {
        Boolean aBoolean = this.service.bidEvaluation(id);
        return CommonResponse.success((String)"\u662f\u5426\u5f85\u8bc4\u6807\uff01", (Object)aBoolean);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExpertVO> queryDetail(Long id) {
        ExpertEntity entity = (ExpertEntity)((Object)this.service.selectById(id));
        ExpertVO vo = (ExpertVO)BeanMapper.map((Object)((Object)entity), ExpertVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpertVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.expertFieldDetailService.removes(vos.stream().map(ExpertVO::getExpertId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExpertVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("expertName");
        fuzzyFields.add("mobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fieldName");
        fuzzyFields.add("postName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("unitId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpertVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("expertName");
        fuzzyFields.add("mobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fieldName");
        fuzzyFields.add("postName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("unitId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList ExpertExportVOS = new ArrayList();
        list.forEach(val -> {
            ExpertExportVO ExpertExportVO2 = (ExpertExportVO)BeanMapper.map((Object)val, ExpertExportVO.class);
            ExpertExportVO2.setEmployeeTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)val.getEmployeeTime()));
            switch (val.getState()) {
                case 0: {
                    ExpertExportVO2.setState("\u542f\u7528");
                    break;
                }
                case 1: {
                    ExpertExportVO2.setState("\u505c\u7528");
                }
            }
            switch (val.getBillState()) {
                case 0: {
                    ExpertExportVO2.setBillState("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    ExpertExportVO2.setBillState("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    ExpertExportVO2.setBillState("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    ExpertExportVO2.setBillState("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    ExpertExportVO2.setBillState("\u5ba1\u6279\u9a73\u56de");
                    break;
                }
                case 5: {
                    ExpertExportVO2.setBillState("\u5ba1\u6279\u4e2d");
                }
            }
            ExpertExportVOS.add(ExpertExportVO2);
        });
        HashMap beans = new HashMap();
        beans.put("records", ExpertExportVOS);
        ExcelExport.getInstance().export("expert.xlsx", beans, response);
    }

    @RequestMapping(value={"/refExpertData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExpertVO>> refExpertData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("expertName");
        param.getFuzzyFields().add("mobile");
        param.getFuzzyFields().add("unitName");
        param.getFuzzyFields().add("fieldName");
        param.getFuzzyFields().add("postName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("state", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", billStates));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpertVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/randomSelect"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ExpertVO>> randomSelect(@RequestParam Integer expertNum, String fieldNames) {
        List<ExpertVO> expertVOS = this.service.randomSelect(expertNum, fieldNames);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", expertVOS);
    }

    @RequestMapping(value={"/randomSelectTwo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ExpertVO>> randomSelectTwo(@RequestBody RandomExpertVO randomExpertVO) {
        List<ExpertVO> expertVOS = this.service.randomSelectTwo(randomExpertVO.getExpertNum(), randomExpertVO.getExpertVOS(), randomExpertVO.getInviteId());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", expertVOS);
    }

    @RequestMapping(value={"/randomSelectPlus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ExpertVO>> test(@RequestBody RandomExpertVO randomExpertVO) {
        List<ExpertVO> expertVOS = this.service.randomSelectPlus(randomExpertVO.getExpertNum(), randomExpertVO.getExpertVOS(), randomExpertVO.getInviteId(), randomExpertVO.getInviteType());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", expertVOS);
    }

    @RequestMapping(value={"/checkOutPlus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<String>> checkOutPlus(@RequestBody RandomExpertVO randomExpertVO) {
        List<String> expertVOS = this.service.checkOutPlus(randomExpertVO.getExpertVOS(), randomExpertVO.getInviteId(), randomExpertVO.getInviteType());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", expertVOS);
    }

    @RequestMapping(value={"/getRandomNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RandomRuleVO> getRandomNum(@RequestParam Integer inviteType) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)new RandomRuleVO());
    }

    @RequestMapping(value={"/randomExpertForSupplier"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ExpertVO>> randomExpertForSupplier(@RequestBody RandomSupplierExpertVO randomExpertVO) {
        List<ExpertVO> expertVOS = this.service.randomExpertForSupplier(randomExpertVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", expertVOS);
    }

    @RequestMapping(value={"/checkForSupplier"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<String>> checkForSupplier(@RequestBody RandomSupplierExpertVO randomExpertVO) {
        List<String> expertVOS = this.service.checkForSupplier(randomExpertVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", expertVOS);
    }

    @RequestMapping(value={"/checkout"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<String>> checkout(@RequestBody RandomExpertVO randomExpertVO) {
        List<String> checkout = this.service.checkout(randomExpertVO.getExpertVOS(), randomExpertVO.getInviteId());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", checkout);
    }

    @RequestMapping(value={"/manualSelect"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExpertVO>> manualSelect(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String fieldNames, String searchObject, String searchText) {
        IPage<ExpertVO> expertVOIPage = this.service.manualSelect(pageNumber, pageSize, fieldNames, searchObject, searchText);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", expertVOIPage);
    }

    @RequestMapping(value={"/updateUnitName"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse updateUnitName(@RequestParam Long id, @RequestParam Long expertId) {
        EmployeeVO employeeVO = (EmployeeVO)this.employeeApi.queryEmployeByUserId(expertId).getData();
        ExpertVO expertVO = (ExpertVO)this.queryDetail(id).getData();
        expertVO.setUnitId(employeeVO.getOrgId());
        expertVO.setUnitName(employeeVO.getOrgName());
        expertVO.setDeptId(employeeVO.getDeptId());
        expertVO.setDeptName(employeeVO.getDeptName());
        expertVO.setExpertName(employeeVO.getName());
        expertVO.setEmployeeType(employeeVO.getEmployeeType());
        this.saveOrUpdate(expertVO);
        return CommonResponse.success((String)"\u66f4\u65b0\u6240\u5c5e\u9879\u76ee\u6210\u529f!");
    }

    @RequestMapping(value={"/initEmployeeType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> initEmployeeType(HttpServletRequest request) {
        String param = request.getParameter("param");
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        LambdaQueryWrapper expertLambda = Wrappers.lambdaQuery();
        expertLambda.in(ExpertEntity::getBillState, new Object[]{1, 3});
        List list = this.service.list((Wrapper)expertLambda);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u4e13\u5bb6\u4fe1\u606f\u662f\uff1a" + JSONObject.toJSONString((Object)list));
        this.logger.info("\u83b7\u53d6\u5230\u7684\u4e13\u5bb6\u53c2\u6570-\u662f\uff1a" + JSONObject.toJSONString(list.stream().map(ExpertEntity::getExpertId).collect(Collectors.toList())));
        List employeeVOList = (List)this.employeeApi.getJustByIds(list.stream().map(ExpertEntity::getExpertId).collect(Collectors.toList())).getData();
        this.logger.info("\u83b7\u53d6\u5230\u7684\u4eba\u5458\u4fe1\u606f\u662f\uff1a" + JSONObject.toJSONString((Object)employeeVOList));
        Map<Long, Integer> map = employeeVOList.stream().filter(item -> null != item.getEmployeeType()).collect(Collectors.toMap(BaseVO::getId, EmployeeVO::getEmployeeType));
        ArrayList upList = new ArrayList();
        list.forEach(e -> {
            if (map.containsKey(e.getExpertId()) && e.getEmployeeType() != map.get(e.getExpertId())) {
                e.setEmployeeType((Integer)map.get(e.getExpertId()));
                upList.add(e);
            }
        });
        if (CollectionUtils.isNotEmpty(upList)) {
            this.logger.info("\u9700\u8981\u66f4\u65b0\u7684list\uff1a" + JSONObject.toJSONString(upList));
            this.service.updateBatchById(upList);
        }
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f");
    }
}

