/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.report.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.report.mapper.ReportMapper;
import com.ejianc.business.tender.report.service.IReportService;
import com.ejianc.business.tender.report.vo.BidDataVO;
import com.ejianc.business.tender.report.vo.ReportVO;
import com.ejianc.business.tender.report.vo.SupplierReportVO;
import com.ejianc.business.tender.util.MathUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reportService")
public class ReportServiceImpl
implements IReportService {
    @Autowired
    private ReportMapper reportMapper;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherPicketageRefsupplierService otherPicketageRefsupplierService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Map<String, Object> queryData(QueryParam param) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<ReportVO> list = this.reportMapper.refPurchaseAcceptanceData((QueryWrapper<Object>)BaseServiceImpl.changeToQueryWrapper((QueryParam)param), (IPage<ReportVO>)page);
        List<ReportVO> list1 = this.reportMapper.refPurchaseAcceptanceAllData((QueryWrapper<Object>)BaseServiceImpl.changeToQueryWrapper((QueryParam)param));
        BigDecimal sumTaxMoney = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list1)) {
            this.logger.info("\u62db\u6807\u7edf\u8ba1\u6570\u636e:{}", (Object)JSONObject.toJSONString(list1));
            for (ReportVO reportVO : list1) {
                sumTaxMoney = MathUtil.safeAdd(sumTaxMoney, reportVO.getTaxMoney());
            }
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", pageData);
        map.put("sumTaxMoney", sumTaxMoney);
        return map;
    }

    @Override
    public IPage<SupplierReportVO> querySupplierReportData(QueryParam param, Long supplierId) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<SupplierReportVO> list = this.reportMapper.querySupplierReportData((QueryWrapper<Object>)BaseServiceImpl.changeToQueryWrapper((QueryParam)param), (IPage<SupplierReportVO>)page, supplierId);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }

    @Override
    public BigDecimal queryMoney(Integer tenderType, String tenderTypeName, String firstDayOfMonth, String lastDayOfMonth) {
        BigDecimal otherMoney = BigDecimal.ZERO;
        LambdaQueryWrapper publicOtherInviteWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)publicOtherInviteWrapper.eq(OtherInviteEntity::getEstablishType, (Object)1)).in(OtherInviteEntity::getBillState, new Object[]{1, 3})).eq(BaseEntity::getDr, (Object)0)).in(OtherInviteEntity::getOrgId, (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()))).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid())).eq(OtherInviteEntity::getTenderType, (Object)tenderType);
        if (StringUtils.isNotEmpty((CharSequence)firstDayOfMonth)) {
            publicOtherInviteWrapper.between(OtherInviteEntity::getCreateDate, (Object)firstDayOfMonth, (Object)lastDayOfMonth);
        }
        LambdaQueryWrapper publicOtherPicketageWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)publicOtherPicketageWrapper.eq(OtherPicketageEntity::getTenderTypeName, (Object)tenderTypeName)).eq(BaseEntity::getDr, (Object)0)).in(OtherPicketageEntity::getOrgId, (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()))).eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid())).in(OtherPicketageEntity::getBillState, new Object[]{1, 3});
        if (StringUtils.isNotEmpty((CharSequence)firstDayOfMonth)) {
            publicOtherPicketageWrapper.between(OtherPicketageEntity::getPicketageTime, (Object)firstDayOfMonth, (Object)lastDayOfMonth);
        }
        List publicOtherInviteIdList = this.otherInviteService.list((Wrapper)publicOtherInviteWrapper).stream().map(BaseEntity::getId).collect(Collectors.toList());
        List publicOtherPicketageIdList = this.otherPicketageService.list((Wrapper)publicOtherPicketageWrapper).stream().map(BaseEntity::getId).collect(Collectors.toList());
        publicOtherInviteIdList.addAll(publicOtherPicketageIdList);
        if (CollectionUtils.isNotEmpty(publicOtherInviteIdList)) {
            LambdaQueryWrapper publicOtherPicketageRefSupplierWrapper = new LambdaQueryWrapper();
            publicOtherPicketageRefSupplierWrapper.in(OtherPicketageRefsupplierEntity::getPicketageId, publicOtherInviteIdList);
            otherMoney = this.otherPicketageRefsupplierService.list((Wrapper)publicOtherPicketageRefSupplierWrapper).stream().filter(e -> e.getMoneyTax() != null).map(OtherPicketageRefsupplierEntity::getMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.logger.info("\u5176\u4ed6\u6570\u636e\u6761\u6570:{}", (Object)publicOtherInviteIdList.size());
        }
        this.logger.info("\u5408\u8ba1\u603b\u91d1\u989d:{}", (Object)otherMoney);
        return otherMoney;
    }

    public static Date getFirstDayOfMonth(boolean flag) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf1 = new SimpleDateFormat("MM");
        String format = sdf1.format(new Date());
        int month = Integer.parseInt(format);
        if (flag) {
            calendar.add(1, -1);
        }
        calendar.set(2, month - 1);
        int firstDay = calendar.getActualMinimum(5);
        calendar.set(5, firstDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDayDate = sdf.format(calendar.getTime()) + " 00:00:00";
        return sdf.parse(firstDayDate);
    }

    public static Date getLastDayOfMonth(boolean flag) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf1 = new SimpleDateFormat("MM");
        String format = sdf1.format(new Date());
        int month = Integer.parseInt(format);
        if (flag) {
            calendar.add(1, -1);
        }
        calendar.set(2, month - 1);
        int lastDay = 0;
        lastDay = month == 2 ? calendar.getLeastMaximum(5) : calendar.getActualMaximum(5);
        calendar.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String lastDayDate = sdf.format(calendar.getTime()) + " 23:59:59";
        return sdf.parse(lastDayDate);
    }

    @Override
    public Map queryBidData(QueryParam param) throws ParseException {
        BidDataVO bidDataVO = new BidDataVO();
        HashMap<String, BigDecimal> bidDataVOMap = new HashMap<String, BigDecimal>();
        List<ReportVO> list = this.reportMapper.refPurchaseAcceptanceAllData((QueryWrapper<Object>)BaseServiceImpl.changeToQueryWrapper((QueryParam)param));
        BigDecimal publicTenderMoney = ReportServiceImpl.calculateMoney(list, "0", null, null);
        bidDataVO.setPublicTenderMoney(publicTenderMoney);
        bidDataVOMap.put("publicTenderMoney", publicTenderMoney);
        BigDecimal inviteTenderMoney = ReportServiceImpl.calculateMoney(list, "1", null, null);
        bidDataVO.setInviteTenderMoney(inviteTenderMoney);
        bidDataVOMap.put("inviteTenderMoney", inviteTenderMoney);
        BigDecimal inquiryTenderMoney = ReportServiceImpl.calculateMoney(list, "2", null, null);
        bidDataVO.setInquiryTenderMoney(inquiryTenderMoney);
        bidDataVOMap.put("inquiryTenderMoney", inquiryTenderMoney);
        BigDecimal urgentTenderMoney = ReportServiceImpl.calculateMoney(list, "5", null, null);
        bidDataVO.setUrgentTenderMoney(urgentTenderMoney);
        bidDataVOMap.put("urgentTenderMoney", urgentTenderMoney);
        bidDataVOMap.put("otherTenderMoney", ReportServiceImpl.calculateMoney(list, "3", null, null).add(ReportServiceImpl.calculateMoney(list, "4", null, null)));
        BidDataVO nowMonth = new BidDataVO();
        Date firstDayOfMonth = ReportServiceImpl.getFirstDayOfMonth(false);
        Date lastDayOfMonth = ReportServiceImpl.getLastDayOfMonth(false);
        this.logger.info("\u672c\u671f\u65e5\u671f\u5f00\u59cb\u65f6\u95f4-{}", (Object)firstDayOfMonth);
        this.logger.info("\u672c\u671f\u65e5\u671f\u7ed3\u675f\u65f6\u95f4-{}", (Object)lastDayOfMonth);
        nowMonth.setPublicTenderMoney(ReportServiceImpl.calculateMoney(list, "0", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setInviteTenderMoney(ReportServiceImpl.calculateMoney(list, "1", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setInquiryTenderMoney(ReportServiceImpl.calculateMoney(list, "2", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setUrgentTenderMoney(ReportServiceImpl.calculateMoney(list, "5", firstDayOfMonth, lastDayOfMonth));
        nowMonth.setOtherTenderMoney(ReportServiceImpl.calculateMoney(list, "3", firstDayOfMonth, lastDayOfMonth).add(ReportServiceImpl.calculateMoney(list, "4", firstDayOfMonth, lastDayOfMonth)));
        BidDataVO oldMonth = new BidDataVO();
        Date oldFirstDayOfMonth = ReportServiceImpl.getFirstDayOfMonth(true);
        Date oldLastDayOfMonth = ReportServiceImpl.getLastDayOfMonth(true);
        this.logger.info("\u540c\u671f\u65e5\u671f\u5f00\u59cb\u65f6\u95f4-{}", (Object)oldFirstDayOfMonth);
        this.logger.info("\u540c\u671f\u65e5\u671f\u7ed3\u675f\u65f6\u95f4-{}", (Object)oldLastDayOfMonth);
        oldMonth.setPublicTenderMoney(ReportServiceImpl.calculateMoney(list, "0", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setInviteTenderMoney(ReportServiceImpl.calculateMoney(list, "1", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setInquiryTenderMoney(ReportServiceImpl.calculateMoney(list, "2", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setUrgentTenderMoney(ReportServiceImpl.calculateMoney(list, "5", oldFirstDayOfMonth, oldLastDayOfMonth));
        oldMonth.setOtherTenderMoney(ReportServiceImpl.calculateMoney(list, "3", oldFirstDayOfMonth, oldLastDayOfMonth).add(ReportServiceImpl.calculateMoney(list, "4", oldFirstDayOfMonth, oldLastDayOfMonth)));
        BidDataVO rate = new BidDataVO();
        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setPublicTenderRate(BigDecimal.ZERO);
        } else {
            rate.setPublicTenderRate(nowMonth.getPublicTenderMoney().subtract(oldMonth.getPublicTenderMoney()).divide(oldMonth.getPublicTenderMoney(), 2, 4));
        }
        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setInviteTenderRate(BigDecimal.ZERO);
        } else {
            rate.setInviteTenderRate(nowMonth.getInviteTenderMoney().subtract(oldMonth.getInviteTenderMoney()).divide(oldMonth.getInviteTenderMoney(), 2, 4));
        }
        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setInquiryTenderRate(BigDecimal.ZERO);
        } else {
            rate.setInquiryTenderRate(nowMonth.getInquiryTenderMoney().subtract(oldMonth.getInquiryTenderMoney()).divide(oldMonth.getInquiryTenderMoney(), 2, 4));
        }
        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setUrgentTenderRate(BigDecimal.ZERO);
        } else if (BigDecimal.ZERO.compareTo(oldMonth.getUrgentTenderMoney()) == 0) {
            rate.setUrgentTenderRate(BigDecimal.ZERO);
        } else {
            rate.setUrgentTenderRate(nowMonth.getUrgentTenderMoney().subtract(oldMonth.getUrgentTenderMoney()).divide(oldMonth.getUrgentTenderMoney(), 2, 4));
        }
        if (oldMonth.getPublicTenderMoney().compareTo(BigDecimal.ZERO) == 0) {
            rate.setOtherTenderRate(BigDecimal.ZERO);
        } else {
            rate.setOtherTenderRate(nowMonth.getOtherTenderMoney().subtract(oldMonth.getOtherTenderMoney()).divide(oldMonth.getOtherTenderMoney(), 2, 4));
        }
        bidDataVOMap.put("nowMonth", (BigDecimal)nowMonth);
        bidDataVOMap.put("oldMonth", (BigDecimal)oldMonth);
        bidDataVOMap.put("rate", (BigDecimal)rate);
        return bidDataVOMap;
    }

    public static BigDecimal calculateMoney(List<ReportVO> list, String tenderTypeName, Date firstDayOfMonth, Date lastDayOfMonth) {
        List list1 = firstDayOfMonth != null && lastDayOfMonth != null ? list.stream().filter(item -> item.getTenderTypeName() != null && item.getTenderTypeName().equals(tenderTypeName) && !item.getCreateDate().after(lastDayOfMonth) && !item.getCreateDate().before(firstDayOfMonth)).collect(Collectors.toList()) : list.stream().filter(item -> item.getTenderTypeName() != null && item.getTenderTypeName().equals(tenderTypeName)).collect(Collectors.toList());
        BigDecimal sumTaxMoney = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list1)) {
            for (ReportVO reportVO : list1) {
                sumTaxMoney = MathUtil.safeAdd(sumTaxMoney, reportVO.getTaxMoney());
            }
        }
        return sumTaxMoney;
    }
}

