/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.other.bean.OtherAdviceEntity;
import com.ejianc.business.tender.other.bean.OtherBidEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.mapper.OtherAdviceMapper;
import com.ejianc.business.tender.other.service.IOtherAdviceService;
import com.ejianc.business.tender.other.service.IOtherBidService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherAdviceSupplierPushVO;
import com.ejianc.business.tender.other.vo.OtherAdviceVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="otherAdviceService")
public class OtherAdviceServiceImpl
extends BaseServiceImpl<OtherAdviceMapper, OtherAdviceEntity>
implements IOtherAdviceService {
    @Autowired
    private IOtherInviteService otherInviteService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private final String OPERATE = "STUFF_ADVICE_SYNC";
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000004";
    @Autowired
    private IOtherBidService otherBidService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        OtherAdviceEntity otherAdviceEntity = (OtherAdviceEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            otherAdviceEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            otherAdviceEntity.setSignFlag(1);
        }
        if (status == 4) {
            otherAdviceEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(otherAdviceEntity.getId());
            cv.setContractName(otherAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)otherAdviceEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        OtherAdviceEntity otherAdviceEntity = (OtherAdviceEntity)((Object)super.selectById((Serializable)id));
        otherAdviceEntity.setSendFlag(0);
        super.updateById((Object)otherAdviceEntity);
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherAdviceEntity.getInviteId()));
        OtherAdviceSupplierPushVO otherAdviceSupplierPushVO = (OtherAdviceSupplierPushVO)BeanMapper.map((Object)((Object)otherAdviceEntity), OtherAdviceSupplierPushVO.class);
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg());
        }
        otherAdviceSupplierPushVO.setSystemId((String)ejcCloudSystemCode.getData());
        otherAdviceSupplierPushVO.setSourceType("\u4e91\u5357\u5efa\u6295\u6750\u6599\u4e2d\u6807\u901a\u77e5\u4e66");
        otherAdviceSupplierPushVO.setSourceId(otherAdviceEntity.getId().toString());
        otherAdviceSupplierPushVO.setBidTitle(otherAdviceEntity.getTitleName());
        otherAdviceSupplierPushVO.setSourceProjectId(otherAdviceEntity.getProjectId() != null ? otherAdviceEntity.getProjectId().toString() : null);
        otherAdviceSupplierPushVO.setSourceOrgId(otherAdviceEntity.getOrgId().toString());
        otherAdviceSupplierPushVO.setSourceUnitId(otherAdviceEntity.getUnitId().toString());
        otherAdviceSupplierPushVO.setType(CommonUtils.getGysType(5));
        otherAdviceSupplierPushVO.setTenderType(otherInviteEntity.getTenderType());
        otherAdviceSupplierPushVO.setBidDate(otherAdviceEntity.getNoticeDate());
        otherAdviceSupplierPushVO.setMoney(otherAdviceEntity.getMoney());
        otherAdviceSupplierPushVO.setMoneyTax(otherAdviceEntity.getMoneyTax());
        String dataInfo = JSONObject.toJSONString((Object)otherAdviceSupplierPushVO);
        boolean b = this.pushBillToSupCenter(dataInfo, otherAdviceEntity.getSupplierId(), otherAdviceEntity.getId(), BILL_TYPE, "/ejc-supbid-web/openapi/bid/saveBid", otherAdviceEntity.getTitleName());
        if (!b) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25!");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, String url, String sourceName) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + sourceId.toString();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"STUFF_ADVICE_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "STUFF_ADVICE_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", datInfo);
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(sourceId, null, "tenderAdvice", null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)supplierId, (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url, paramMap, supplierId.toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, sourceId, billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{sourceId, supplierId, syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u9a8c\u6536\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)sourceId, (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{sourceId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "STUFF_ADVICE_SYNC");
        }
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public List<OtherAdviceVO> queryAdviceList(Long id) {
        OtherBidEntity otherBidEntity = (OtherBidEntity)((Object)this.otherBidService.selectById(id));
        LambdaQueryWrapper lambdaAdvice = Wrappers.lambdaQuery();
        lambdaAdvice.eq(OtherAdviceEntity::getInviteId, (Object)otherBidEntity.getInviteId());
        List list = super.list((Wrapper)lambdaAdvice);
        List otherAdviceVOS = BeanMapper.mapList((Iterable)list, OtherAdviceVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)otherAdviceVOS)) {
            List data;
            List attachIds = otherAdviceVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess() && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                Map attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                for (OtherAdviceVO otherAdviceVO : otherAdviceVOS) {
                    AttachmentVO attachmentVO = (AttachmentVO)attacMap.get(otherAdviceVO.getId());
                    if (attachmentVO == null) continue;
                    otherAdviceVO.setAttachId(attachmentVO.getId());
                    otherAdviceVO.setFileName(attachmentVO.getFileName());
                    otherAdviceVO.setFilePath(attachmentVO.getFilePath());
                }
            }
        }
        return otherAdviceVOS;
    }
}

