/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.expert.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.expert.bean.ExpertRepetitionEntity;
import com.ejianc.business.tender.expert.service.IExpertRepetitionService;
import com.ejianc.business.tender.expert.vo.ExpertRepetitionVO;
import com.ejianc.business.tender.other.service.IOtherDocumentSupplierService;
import com.ejianc.business.tender.other.vo.OtherDocumentSupplierVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"expertRepetition"})
public class ExpertRepetitionController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "EXPERT_REPETITION_RULE";
    @Autowired
    private IExpertRepetitionService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> saveOrUpdate(@RequestBody ExpertRepetitionVO saveOrUpdateVO) {
        ExpertRepetitionVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> queryDetail(Long id) {
        ExpertRepetitionEntity entity = (ExpertRepetitionEntity)((Object)this.service.selectById(id));
        ExpertRepetitionVO vo = (ExpertRepetitionVO)BeanMapper.map((Object)((Object)entity), ExpertRepetitionVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/repetitionSell"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> repetitionSell(@RequestBody ExpertRepetitionVO vo) {
        ExpertRepetitionVO expertRepetitionVO = this.service.repetitionSell(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)expertRepetitionVO);
    }

    @ApiOperation(value="\u53d1\u5e03\u63a5\u53e3")
    @RequestMapping(value={"/publish"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> publish(@RequestParam Long id) throws Exception {
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01", (Object)this.service.publish(id));
    }

    @ApiOperation(value="\u5f00\u59cb\u8bc4\u6807\u63a5\u53e3")
    @RequestMapping(value={"/startScore"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> startScore(@RequestParam Long id) throws Exception {
        String s = this.service.startScore(id);
        return CommonResponse.success((String)"\u5f00\u59cb\u8bc4\u6807\u6210\u529f\uff01", (Object)s);
    }

    @RequestMapping(value={"/publishRepetition"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> publishRepetition(@RequestBody ExpertRepetitionVO vo) {
        ExpertRepetitionVO expertRepetitionVO = this.service.repetitionSell(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)expertRepetitionVO);
    }

    @RequestMapping(value={"/queryCollectDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExpertRepetitionVO> queryCollectDetail(Long id) {
        ExpertRepetitionVO vo = this.service.queryCollectDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpertRepetitionVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ExpertRepetitionVO expertRepetitionVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExpertRepetitionVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("repetiterId", new Parameter("eq", (Object)this.sessionManager.getUserContext().getEmployeeId()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpertRepetitionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ExpertRepetition-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refExpertSupplierData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OtherDocumentSupplierVO>> refExpertSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.getFuzzyFields().add("supplierName");
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Integer inviteType = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            Integer talkNum = 0;
            if (_con.containsKey((Object)"talkNum")) {
                talkNum = Integer.parseInt(_con.get((Object)"talkNum").toString());
                param.getParams().put("talkNum", new Parameter("eq", (Object)talkNum));
            }
            Long documentId = null;
            if (_con.containsKey((Object)"documentId")) {
                documentId = Long.parseLong(_con.get((Object)"documentId").toString());
                param.getParams().put("documentId", new Parameter("eq", (Object)documentId));
            }
            if (_con.containsKey((Object)"inviteType")) {
                inviteType = Integer.parseInt(_con.get((Object)"inviteType").toString());
            }
        }
        if (inviteType == 5) {
            IPage page = this.otherDocumentSupplierService.queryPage(param, false);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OtherDocumentSupplierVO.class));
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        return null;
    }
}

