/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.expert.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEntity;
import com.ejianc.business.tender.expert.bean.ExpertFieldDetailEntity;
import com.ejianc.business.tender.expert.mapper.ExpertFieldDetailMapper;
import com.ejianc.business.tender.expert.service.IExpertFieldDetailService;
import com.ejianc.business.tender.expert.service.IExpertService;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="expertFieldDetailService")
public class ExpertFieldDetailServiceImpl
extends BaseServiceImpl<ExpertFieldDetailMapper, ExpertFieldDetailEntity>
implements IExpertFieldDetailService {
    @Autowired
    private IExpertFieldDetailService service;
    @Autowired
    private IExpertService expertService;

    @Override
    public void saveOrUpdate(Long expertId, String fieldName) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertFieldDetailEntity::getExpertId, (Object)expertId);
        List list = this.service.list((Wrapper)lambda);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            this.service.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
        String[] split = fieldName.split("\u3001");
        ArrayList<ExpertFieldDetailEntity> expertFieldDetailEntities = new ArrayList<ExpertFieldDetailEntity>();
        for (String s : split) {
            ExpertFieldDetailEntity expertFieldDetailEntity = new ExpertFieldDetailEntity();
            expertFieldDetailEntity.setExpertId(expertId);
            expertFieldDetailEntity.setFieldName(s);
            expertFieldDetailEntities.add(expertFieldDetailEntity);
        }
        this.service.saveOrUpdateBatch(expertFieldDetailEntities, expertFieldDetailEntities.size(), false);
    }

    @Override
    public void removes(List<Long> expertIds) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(ExpertFieldDetailEntity::getExpertId, expertIds);
        lambda.eq(BaseEntity::getDr, (Object)0);
        List list = this.service.list((Wrapper)lambda);
        this.service.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
    }

    @Override
    public List<Long> queryExpertIds(String fieldNames) {
        Object[] split = fieldNames.split("\u3001");
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(ExpertFieldDetailEntity::getFieldName, split);
        List list = this.service.list((Wrapper)lambda);
        List<Long> expertIds = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            expertIds = list.stream().map(ExpertFieldDetailEntity::getExpertId).distinct().collect(Collectors.toList());
        }
        return expertIds;
    }

    @Override
    public List<String> queryExpertIdsTwo(String fieldNames) {
        Object[] split = fieldNames.split("\u3001");
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(ExpertFieldDetailEntity::getFieldName, split);
        List list = this.service.list((Wrapper)lambda);
        List<String> collect1 = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            List collect = list.stream().map(ExpertFieldDetailEntity::getExpertId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper expertLambda = Wrappers.lambdaQuery();
            expertLambda.in(ExpertEntity::getExpertId, collect);
            expertLambda.in(ExpertEntity::getBillState, new Object[]{1, 3});
            expertLambda.eq(ExpertEntity::getState, (Object)0);
            expertLambda.eq(ExpertEntity::getEmployeeType, (Object)1);
            List expertEntityList = this.expertService.list((Wrapper)expertLambda);
            List collect2 = expertEntityList.stream().map(ExpertEntity::getExpertId).distinct().collect(Collectors.toList());
            collect1 = collect2.stream().map(x -> x + "").distinct().collect(Collectors.toList());
        }
        return collect1;
    }
}

