/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.expert.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tender.expert.bean.ExpertEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordScoreEntity;
import com.ejianc.business.tender.expert.bean.TemplateDetailEntity;
import com.ejianc.business.tender.expert.mapper.ExpertEvaluatingMapper;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.mapper.ExpertRecordScoreMapper;
import com.ejianc.business.tender.expert.mapper.TemplateDetailMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingDetailService;
import com.ejianc.business.tender.expert.service.IExpertRecordScoreService;
import com.ejianc.business.tender.expert.service.IExpertRecordService;
import com.ejianc.business.tender.expert.service.IExpertRecordTotalService;
import com.ejianc.business.tender.expert.service.IExpertService;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingDetailVO;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingVO;
import com.ejianc.business.tender.expert.vo.ExpertRecordScoreVO;
import com.ejianc.business.tender.expert.vo.ExpertRecordVO;
import com.ejianc.business.tender.other.bean.OtherDocumentSchemeEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.mapper.OtherDocumentSchemeMapper;
import com.ejianc.business.tender.other.mapper.OtherDocumentSupplierMapper;
import com.ejianc.business.tender.other.service.IOtherDocumentSchemeService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="expertRecordService")
public class ExpertRecordServiceImpl
extends BaseServiceImpl<ExpertRecordMapper, ExpertRecordEntity>
implements IExpertRecordService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;
    @Autowired
    OtherDocumentSchemeMapper otherDocumentSchemeMapper;
    @Autowired
    OtherDocumentSupplierMapper otherDocumentSupplierMapper;
    @Autowired
    TemplateDetailMapper templateDetailMapper;
    @Autowired
    ExpertRecordScoreMapper scoreMapper;
    @Autowired
    ExpertEvaluatingMapper evaluationMapper;
    @Autowired
    private IExpertRecordScoreService recordScoreService;
    @Autowired
    private IExpertRecordService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IExpertRecordTotalService totalService;
    @Autowired
    private IExpertService expertService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IExpertEvaluatingDetailService expertEvaluatingDetailService;

    @Override
    public List<TemplateDetailEntity> selectTemplateList(Long templateId) {
        return this.templateDetailMapper.selectTemplateList(templateId);
    }

    @Override
    public Integer selectExist(Long employeeId, Long evaluationId) {
        return ((ExpertRecordMapper)this.baseMapper).selectCount((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"evaluation_id", (Object)evaluationId)).eq((Object)"employee_id", (Object)employeeId)).eq((Object)"dr", (Object)0));
    }

    @Override
    public List<ExpertRecordVO> selectDetail() {
        return ((ExpertRecordMapper)this.baseMapper).selectDetail();
    }

    @Override
    public List<ExpertRecordScoreEntity> selectScore(Long id) {
        return this.scoreMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"record_id", (Object)id)).eq((Object)"dr", (Object)0)).isNotNull((Object)"scoring_template_detail_id"));
    }

    @Override
    public ExpertEvaluatingEntity selectEvaluation(Long id) {
        return (ExpertEvaluatingEntity)((Object)this.evaluationMapper.selectById(id));
    }

    @Override
    public List<ExpertRecordVO> selectBySupplier(Long employeeId, Long documentId) {
        return ((ExpertRecordMapper)this.baseMapper).selectBySupplier(employeeId, documentId);
    }

    @Override
    public List<List<ExpertRecordVO>> saveOrUpdateList(List<List<Map>> supplierDetail) {
        Boolean flag = true;
        ArrayList<List<ExpertRecordVO>> supplierDetail1 = new ArrayList<List<ExpertRecordVO>>();
        for (List<Map> stuffRecordVOList : supplierDetail) {
            ArrayList<ExpertRecordVO> expertRecordVOS = new ArrayList<ExpertRecordVO>();
            for (Map stuffRecordVO : stuffRecordVOList) {
                ExpertRecordVO expertRecordVO1 = (ExpertRecordVO)JSON.parseObject((String)JSON.toJSONString((Object)stuffRecordVO), (TypeReference)new TypeReference<ExpertRecordVO>(){}, (Feature[])new Feature[0]);
                ExpertRecordEntity entity = (ExpertRecordEntity)((Object)BeanMapper.map((Object)expertRecordVO1, ExpertRecordEntity.class));
                this.service.saveOrUpdate((Object)entity, false);
                ExpertRecordVO vo = (ExpertRecordVO)BeanMapper.map((Object)((Object)entity), ExpertRecordVO.class);
                ArrayList<ExpertRecordScoreVO> expertRecordScoreVOS = new ArrayList<ExpertRecordScoreVO>();
                if (this.recordScoreService.selectById(((ExpertRecordScoreVO)expertRecordVO1.getExpertRecordScoreVos().get(0)).getId()) != null) {
                    flag = false;
                }
                for (ExpertRecordScoreVO expertRecordScoreVo : expertRecordVO1.getExpertRecordScoreVos()) {
                    if (flag.booleanValue()) {
                        expertRecordScoreVo.setId(null);
                        expertRecordScoreVo.setCreateTime(null);
                        expertRecordScoreVo.setUpdateTime(null);
                    }
                    ExpertRecordScoreEntity entity0 = (ExpertRecordScoreEntity)((Object)BeanMapper.map((Object)expertRecordScoreVo, ExpertRecordScoreEntity.class));
                    entity0.setRecordId(vo.getId());
                    this.recordScoreService.saveOrUpdate((Object)entity0, false);
                    ExpertRecordScoreVO expertRecordScoreVO = (ExpertRecordScoreVO)BeanMapper.map((Object)((Object)entity0), ExpertRecordScoreVO.class);
                    ArrayList<Object> expertRecordScoreVOS1 = new ArrayList<Object>();
                    for (ExpertRecordScoreVO expertRecordScoreVo1 : expertRecordScoreVo.getExpertRecordScoreVOList()) {
                        if (flag.booleanValue()) {
                            expertRecordScoreVo1.setId(null);
                            expertRecordScoreVo1.setCreateTime(null);
                            expertRecordScoreVo1.setUpdateTime(null);
                        }
                        expertRecordScoreVo1.setRecordId(vo.getId());
                        expertRecordScoreVo1.setScoringTemplateDetailParentId(expertRecordScoreVo.getScoringTemplateDetailParentId() == null ? null : expertRecordScoreVo.getScoringTemplateDetailParentId());
                        ExpertRecordScoreEntity entity1 = (ExpertRecordScoreEntity)((Object)BeanMapper.map((Object)expertRecordScoreVo1, ExpertRecordScoreEntity.class));
                        this.recordScoreService.saveOrUpdate((Object)entity1, false);
                        expertRecordScoreVOS1.add(BeanMapper.map((Object)((Object)entity1), ExpertRecordScoreVO.class));
                    }
                    expertRecordScoreVO.setExpertRecordScoreVOList(expertRecordScoreVOS1);
                    expertRecordScoreVOS.add(expertRecordScoreVO);
                }
                vo.setStuffRecordScoreVos(expertRecordScoreVOS);
                expertRecordVOS.add(vo);
            }
            supplierDetail1.add(expertRecordVOS);
        }
        return supplierDetail1;
    }

    @Override
    public Map<String, Object> querySupplierList(Long documentId, Long templateId, Long id) throws InvocationTargetException, IllegalAccessException {
        String employeeName = this.sessionManager.getUserContext().getEmployeeName();
        Long employeeId = this.sessionManager.getUserContext().getEmployeeId();
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        ArrayList<ArrayList<Object>> lists = new ArrayList<ArrayList<Object>>();
        ExpertEvaluatingEntity evaluationDetail = this.service.selectEvaluation(id);
        ExpertEvaluatingVO expertEvaluatingVO = (ExpertEvaluatingVO)BeanMapper.map((Object)((Object)evaluationDetail), ExpertEvaluatingVO.class);
        ExpertEvaluatingDetailEntity evaluatingDetailEntity = (ExpertEvaluatingDetailEntity)((Object)this.expertEvaluatingDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"expert_id", (Object)employeeId)).eq((Object)"evaluation_id", (Object)id)).get(0));
        ExpertEvaluatingDetailVO expertEvaluatingDetailVO = (ExpertEvaluatingDetailVO)BeanMapper.map((Object)((Object)evaluatingDetailEntity), ExpertEvaluatingDetailVO.class);
        switch (evaluationDetail.getInviteType()) {
            case 5: {
                OtherDocumentVO sellDetail5 = this.otherDocumentService.queryDetailNum(documentId);
                detailMap.put("sellDetail", sellDetail5);
                OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(evaluationDetail.getInviteId()));
                expertEvaluatingVO.setTenderMoney(otherInviteEntity.getTenderMoney());
            }
        }
        detailMap.put("evaluationDetail", expertEvaluatingVO);
        detailMap.put("expertEvaluatingDetailVO", expertEvaluatingDetailVO);
        List historyList = this.totalService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"employee_id", (Object)employeeId)).eq((Object)"evaluation_id", (Object)id));
        detailMap.put("historyList", historyList);
        if (this.service.selectExist(employeeId, id) == 0) {
            List<TemplateDetailEntity> templateList = this.service.selectTemplateList(templateId);
            ArrayList<ExpertRecordScoreVO> expertRecordScoreVOS = new ArrayList<ExpertRecordScoreVO>();
            if (evaluationDetail.getDistinctionFlag() == 0) {
                ExpertEntity expertEntity = (ExpertEntity)((Object)this.expertService.list((Wrapper)new QueryWrapper().eq((Object)"expert_id", (Object)employeeId)).get(0));
                if (CollectionUtils.isEmpty(templateList = templateList.stream().filter(t -> t.getScoringType().equals(expertEntity.getType())).collect(Collectors.toList())) && expertEntity.getType() == 2) {
                    templateList = this.service.selectTemplateList(templateId);
                }
            }
            for (TemplateDetailEntity templateDetail : templateList) {
                templateDetail.setCreateTime(null);
                templateDetail.setUpdateTime(null);
                ExpertRecordScoreVO stuffRecordScore = new ExpertRecordScoreVO();
                BeanUtils.copyProperties((Object)stuffRecordScore, (Object)((Object)templateDetail));
                stuffRecordScore.setScoringTemplateDetailParentId(templateDetail.getId());
                stuffRecordScore.setScoringTemplateDetailId(templateDetail.getId());
                stuffRecordScore.setId(null);
                List<TemplateDetailEntity> stuffRecordDetailList = this.service.selectTemplateDetail(templateDetail.getId());
                List list = BeanMapper.mapList(stuffRecordDetailList, ExpertRecordScoreVO.class);
                stuffRecordScore.setExpertRecordScoreVOList(list);
                expertRecordScoreVOS.add(stuffRecordScore);
            }
            if (evaluationDetail.getInviteType() == 5) {
                OtherDocumentSchemeEntity stuffDocumentSchemeEntity = (OtherDocumentSchemeEntity)((Object)this.otherDocumentSchemeService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)documentId)).orderByDesc((Object)"talk_num")).get(0));
                Integer talkNum = stuffDocumentSchemeEntity.getTalkNum();
                List<OtherDocumentSupplierEntity> supplierList = this.service.selectOtherSupplierList(documentId, talkNum);
                for (OtherDocumentSupplierEntity otherDocumentSupplierEntity : supplierList) {
                    ArrayList<ExpertRecordVO> recordVOList = new ArrayList<ExpertRecordVO>();
                    List<OtherDocumentSchemeEntity> schemeList = this.service.selectOtherSchemeList(otherDocumentSupplierEntity.getSupplierId(), documentId);
                    for (OtherDocumentSchemeEntity schemeEntity : schemeList) {
                        ExpertRecordVO expertRecordVO = new ExpertRecordVO();
                        expertRecordVO.setInviteId(evaluationDetail.getInviteId());
                        expertRecordVO.setTaxMemo(otherDocumentSupplierEntity.getTaxMemo());
                        expertRecordVO.setDocumentId(documentId);
                        expertRecordVO.setSupplierId(otherDocumentSupplierEntity.getSupplierId());
                        expertRecordVO.setSupplierName(otherDocumentSupplierEntity.getSupplierName());
                        expertRecordVO.setEmployeeId(employeeId);
                        expertRecordVO.setEmployeeName(employeeName);
                        expertRecordVO.setTemplateId(templateId);
                        expertRecordVO.setDocumentSchemeId(schemeEntity.getId());
                        expertRecordVO.setSchemeName(schemeEntity.getSchemeName());
                        expertRecordVO.setStuffRecordScoreVos(expertRecordScoreVOS);
                        expertRecordVO.setMoney(schemeEntity.getMoney());
                        expertRecordVO.setMoneyTax(schemeEntity.getMoneyTax());
                        expertRecordVO.setEvaluationId(id);
                        recordVOList.add(expertRecordVO);
                    }
                    lists.add(recordVOList);
                }
            }
            detailMap.put("supplierDetail", lists);
            return detailMap;
        }
        List recordEntityList = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"evaluation_id", (Object)id)).eq((Object)"employee_id", (Object)employeeId));
        List recordVOList = BeanMapper.mapList((Iterable)recordEntityList, ExpertRecordVO.class);
        HashMap addMap = new HashMap();
        ArrayList<String> scoringRubricsList = new ArrayList<String>();
        for (ExpertRecordVO expertRecordVO : recordVOList) {
            boolean addFlag = addMap.containsKey(expertRecordVO.getSupplierId());
            List recordVOList1 = addFlag ? (List)addMap.get(expertRecordVO.getSupplierId()) : new ArrayList();
            List<ExpertRecordScoreEntity> scoreVOList = this.service.selectScore(expertRecordVO.getId());
            List scoreVOList2 = BeanMapper.mapList(scoreVOList, ExpertRecordScoreVO.class);
            for (ExpertRecordScoreVO expertRecordScoreVO : scoreVOList2) {
                List<ExpertRecordScoreVO> scoreVOList3 = this.service.selectByParentId(expertRecordScoreVO.getScoringTemplateDetailParentId(), expertRecordVO.getId());
                expertRecordScoreVO.setExpertRecordScoreVOList(scoreVOList3);
            }
            expertRecordVO.setStuffRecordScoreVos(scoreVOList2);
            recordVOList1.add(expertRecordVO);
            if (addFlag) continue;
            addMap.put(expertRecordVO.getSupplierId(), recordVOList1);
        }
        for (Map.Entry entry : addMap.entrySet()) {
            lists.add((ArrayList<Object>)entry.getValue());
        }
        if (CollectionUtils.isNotEmpty(lists)) {
            for (ExpertRecordVO expertRecordVO : (List)lists.get(0)) {
                for (ExpertRecordScoreVO expertRecordScoreVo : expertRecordVO.getExpertRecordScoreVos()) {
                    for (ExpertRecordScoreVO recordScoreVO : expertRecordScoreVo.getExpertRecordScoreVOList()) {
                        scoringRubricsList.add(recordScoreVO.getScoringRubrics());
                        this.logger.info("\u8bc4\u5206\u6807\u51c6\u6392\u5217\u987a\u5e8f==================" + JSONObject.toJSONString(scoringRubricsList));
                    }
                }
            }
        }
        for (List list : lists) {
            for (ExpertRecordVO recordVO : list) {
                for (ExpertRecordScoreVO expertRecordScoreVo : recordVO.getExpertRecordScoreVos()) {
                    List scoreVOList = expertRecordScoreVo.getExpertRecordScoreVOList();
                    ArrayList scoreVOList1 = new ArrayList();
                    Map map = scoreVOList.stream().collect(Collectors.toMap(ExpertRecordScoreVO::getScoringRubrics, Function.identity()));
                    for (String s : scoringRubricsList) {
                        if (!map.containsKey(s)) continue;
                        scoreVOList1.add(map.get(s));
                    }
                    expertRecordScoreVo.getExpertRecordScoreVOList().clear();
                    expertRecordScoreVo.setExpertRecordScoreVOList(scoreVOList1);
                    this.logger.info("\u6392\u5217\u540e\u7684\u6570\u636e" + JSONObject.toJSONString(scoreVOList1));
                }
            }
        }
        detailMap.put("supplierDetail", lists);
        return detailMap;
    }

    @Override
    public List<TemplateDetailEntity> selectTemplateDetail(Long parentId) {
        return this.templateDetailMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)parentId)).eq((Object)"dr", (Object)0));
    }

    @Override
    public List<ExpertRecordScoreVO> selectByParentId(Long scoringTemplateDetailParentId, Long recordId) {
        return BeanMapper.mapList((Iterable)this.recordScoreService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"scoring_template_detail_parent_id", (Object)scoringTemplateDetailParentId)).eq((Object)"record_id", (Object)recordId)).isNull((Object)"scoring_template_detail_id")).orderBy(true, true, (Object[])new String[]{"scoring_rubrics"})), ExpertRecordScoreVO.class);
    }

    @Override
    public List<List<ExpertRecordVO>> queryDetail(Long evaluationId, Long expertId) {
        ArrayList<List<ExpertRecordVO>> lists = new ArrayList<List<ExpertRecordVO>>();
        List recordEntityList = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"evaluation_id", (Object)evaluationId)).eq((Object)"employee_id", (Object)expertId));
        List recordVOList = BeanMapper.mapList((Iterable)recordEntityList, ExpertRecordVO.class);
        HashMap addMap = new HashMap();
        for (ExpertRecordVO expertRecordVO : recordVOList) {
            boolean addFlag = addMap.containsKey(expertRecordVO.getSupplierId());
            List recordVOList1 = addFlag ? (List)addMap.get(expertRecordVO.getSupplierId()) : new ArrayList();
            List<ExpertRecordScoreEntity> scoreVOList = this.service.selectScore(expertRecordVO.getId());
            List scoreVOList2 = BeanMapper.mapList(scoreVOList, ExpertRecordScoreVO.class);
            for (ExpertRecordScoreVO expertRecordScoreVO : scoreVOList2) {
                List<ExpertRecordScoreVO> scoreVOList3 = this.service.selectByParentId(expertRecordScoreVO.getScoringTemplateDetailParentId(), expertRecordVO.getId());
                expertRecordScoreVO.setExpertRecordScoreVOList(scoreVOList3);
            }
            expertRecordVO.setStuffRecordScoreVos(scoreVOList2);
            recordVOList1.add(expertRecordVO);
            if (addFlag) continue;
            addMap.put(expertRecordVO.getSupplierId(), recordVOList1);
        }
        for (Map.Entry entry : addMap.entrySet()) {
            lists.add((List<ExpertRecordVO>)entry.getValue());
        }
        return lists;
    }

    @Override
    public List<OtherDocumentSupplierEntity> selectOtherSupplierList(Long documentId, Integer talkNum) {
        return this.otherDocumentSupplierMapper.selectOtherSupplierList(documentId, talkNum);
    }

    @Override
    public List<OtherDocumentSchemeEntity> selectOtherSchemeList(Long id, Long supplierId) {
        return this.otherDocumentSchemeMapper.selectOtherSchemeList(id, supplierId);
    }
}

