/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherInviteVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/otherInviteFileUpdate/"})
public class OtherInviteFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOtherInviteService otherInviteService;

    @PostMapping(value={"updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(updateData.getLong("billId")));
        otherInviteEntity.setContractFileId(updateData.getLong("fileId"));
        otherInviteEntity.setContractFileHighlightId(updateData.getLong("fileId"));
        otherInviteEntity.setContractFilePath(updateData.getString("fileOnlinePath"));
        otherInviteEntity.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        otherInviteEntity.setContractFileSyncFlag(true);
        this.otherInviteService.saveOrUpdate((Object)otherInviteEntity, false);
        resp.put("message", (Object)"\u62db\u6807\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)otherInviteEntity);
        return CommonResponse.success((String)"\u62db\u6807\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getBillDataJson"})
    public CommonResponse<OtherInviteVO> getBillDataJson(@RequestParam Long id) {
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(id));
        OtherInviteVO vo = (OtherInviteVO)BeanMapper.map((Object)((Object)otherInviteEntity), OtherInviteVO.class);
        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if (CollectionUtils.isNotEmpty((Collection)vo.getOtherDetailRecord())) {
            vo.getOtherDetailRecord().forEach(item -> {
                item.setRateStr(priceFmt.format(null != item.getRate() ? item.getRate() : BigDecimal.ZERO));
                item.setMoneyTaxStr(mnyFmt.format(null != item.getMoneyTax() ? item.getMoneyTax() : BigDecimal.ZERO));
            });
        }
        return CommonResponse.success((Object)vo);
    }
}

