/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMsgUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MSG_TYPE_NOTICE = "notice";

    public void sendSysMsg(List<String> userList, String subject, String content, IPushMessageApi pushMessageApi) {
        ArrayList<String> messageTypeList = new ArrayList<String>();
        messageTypeList.add("sys");
        this.sendMsg(messageTypeList, userList, MSG_TYPE_NOTICE, subject, content, null, null, null, pushMessageApi);
    }

    public void sendMsgByMsgType(List<String> messageTypeList, List<String> userList, String subject, String content, IPushMessageApi pushMessageApi) {
        this.sendMsg(messageTypeList, userList, MSG_TYPE_NOTICE, subject, content, null, null, null, pushMessageApi);
    }

    public void sendMsg(List<String> messageTypeList, List<String> userList, String msgType, String subject, String content, String cgddAgentid, String cgddSecret, String url, IPushMessageApi pushMessageApi) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageTypeList.contains("sys")) {
            channel.add("sys");
        }
        if (messageTypeList.contains("dingding")) {
            channel.add("dingding");
        }
        String[] receivers = userList.toArray(new String[0]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageTypeList.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", (Object)cgddAgentid);
            weixineeParams.put("secret", (Object)cgddSecret);
            weixineeParams.put("msgtype", (Object)"textcard");
            weixineeParams.put("title", (Object)"\u6d88\u606f\u63d0\u9192");
            weixineeParams.put("description", (Object)subject);
            weixineeParams.put("url", (Object)url);
            weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
            parameter.setWeixineeParams(weixineeParams);
        }
        if (messageTypeList.contains("dingding")) {
            JSONObject dingdingParams = new JSONObject();
            dingdingParams.put("title", (Object)subject);
            String ddcontent = subject;
            dingdingParams.put("content", (Object)ddcontent);
            parameter.setDingdingParams(dingdingParams);
        }
        try {
            this.logger.info("\u6d88\u606f\u53d1\u9001\u53c2\u6570---------------->{}", (Object)JSON.toJSONString((Object)parameter));
            CommonResponse result = pushMessageApi.pushMessage(parameter);
            this.logger.info("\u6d88\u606f\u53d1\u9001\u7ed3\u679c---------------->{}", (Object)JSONObject.toJSONString((Object)result));
            if (result.isSuccess()) {
                this.logger.info("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

