/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.expert.controller;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordHistoryEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordScoreHistoryEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordTotalEntity;
import com.ejianc.business.tender.expert.bean.ExpertRepetitionEntity;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingDetailService;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.expert.service.IExpertRecordHistoryService;
import com.ejianc.business.tender.expert.service.IExpertRecordScoreHistoryService;
import com.ejianc.business.tender.expert.service.IExpertRecordScoreService;
import com.ejianc.business.tender.expert.service.IExpertRecordService;
import com.ejianc.business.tender.expert.service.IExpertRecordTotalService;
import com.ejianc.business.tender.expert.service.IExpertRepetitionService;
import com.ejianc.business.tender.expert.vo.CollectVO;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingDetailScoreVO;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingDetailVO;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingVO;
import com.ejianc.business.tender.expert.vo.ExpertRecordVO;
import com.ejianc.business.tender.expert.vo.ExpertRepetitionVO;
import com.ejianc.business.tender.expert.vo.ProgressSheetVO;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherTalkEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentSchemeService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherTalkService;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"stuffEvaluation"})
public class ExpertEvaluatingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "EXPERT_EVALUATION";
    @Autowired
    private IExpertEvaluatingService service;
    @Autowired
    private IExpertRepetitionService expertRepetitionService;
    @Autowired
    private IExpertEvaluatingDetailService detailService;
    @Autowired
    private IExpertEvaluatingDetailService evaluatingDetailService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IExpertRecordService expertRecordService;
    @Autowired
    private IExpertRecordScoreService expertRecordScoreService;
    @Autowired
    private IExpertRecordHistoryService expertRecordHistoryService;
    @Autowired
    private IExpertRecordScoreHistoryService expertRecordScoreHistoryService;
    @Autowired
    private IExpertRecordTotalService totalService;
    @Autowired
    private IOtherTalkService otherTalkService;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExpertEvaluatingVO> saveOrUpdate(@RequestBody ExpertEvaluatingVO saveorUpdateVO) {
        ExpertEvaluatingEntity entity = (ExpertEvaluatingEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ExpertEvaluatingEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ExpertEvaluatingVO vo = (ExpertEvaluatingVO)BeanMapper.map((Object)((Object)entity), ExpertEvaluatingVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExpertEvaluatingVO> queryDetail(Long id) {
        ExpertEvaluatingEntity entity = (ExpertEvaluatingEntity)((Object)this.service.selectById(id));
        ExpertEvaluatingVO vo = (ExpertEvaluatingVO)BeanMapper.map((Object)((Object)entity), ExpertEvaluatingVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveEvaluation"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExpertEvaluatingVO> saveEvaluation(@RequestParam Long documentId) {
        ExpertEvaluatingVO vo = this.service.saveEvaluation(documentId);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/stateCheckout"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> stateCheckout(@RequestParam Long inviteId) {
        this.service.stateCheckout(inviteId);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryScoreDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ExpertEvaluatingDetailScoreVO>> queryScoreDetail(@RequestParam Long inviteId, Long evaluationId) {
        List<ExpertEvaluatingDetailScoreVO> vo = this.service.queryScoreDetail(inviteId, evaluationId);
        if (CollectionUtils.isNotEmpty(vo)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8bc4\u6807\u7ed3\u679c\u6210\u529f\uff01", vo);
        }
        return CommonResponse.success((String)"\u6682\u65f6\u65e0\u4eba\u8bc4\u6807\uff01", vo);
    }

    @RequestMapping(value={"/queryExpertDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryExpertDetail(@RequestBody ExpertEvaluatingDetailScoreVO vo) {
        Map<String, Object> map = this.service.queryExpertDetail(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpertEvaluatingVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpertEvaluatingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StuffEvaluation-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refStuffEvaluationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> refStuffEvaluationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpertEvaluatingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryPendingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> queryPendingList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page();
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        Integer evaluationState = 0;
        Integer evaluationState1 = 3;
        List<ExpertEvaluatingVO> pageData = this.service.queryPendingList((Page<ExpertEvaluatingVO>)page, param.getSearchText(), evaluationState, evaluationState1, ((Parameter)param.getParams().get("employeeId")).getValue().toString());
        pageData.forEach(expertEvaluatingVO -> expertEvaluatingVO.setType(CommonUtils.getTypeName(expertEvaluatingVO.getInviteType())));
        page.setRecords(pageData);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryApprovedList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> queryApprovedList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page();
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        Integer evaluationState = 1;
        Integer evaluationState1 = null;
        List<ExpertEvaluatingVO> pageData = this.service.queryPendingList((Page<ExpertEvaluatingVO>)page, param.getSearchText(), evaluationState, evaluationState1, ((Parameter)param.getParams().get("employeeId")).getValue().toString());
        pageData.forEach(expertEvaluatingVO -> expertEvaluatingVO.setType(CommonUtils.getTypeName(expertEvaluatingVO.getInviteType())));
        page.setRecords(pageData);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryExpiredList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> queryExpiredList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page();
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        Integer evaluationState = 2;
        Integer evaluationState1 = null;
        List<ExpertEvaluatingVO> pageData = this.service.queryPendingList((Page<ExpertEvaluatingVO>)page, param.getSearchText(), evaluationState, evaluationState1, ((Parameter)param.getParams().get("employeeId")).getValue().toString());
        pageData.forEach(expertEvaluatingVO -> expertEvaluatingVO.setType(CommonUtils.getTypeName(expertEvaluatingVO.getInviteType())));
        page.setRecords(pageData);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryGatherList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExpertEvaluatingVO>> queryGatherList(@RequestBody QueryParam param) {
        Page page = new Page();
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        List<ExpertEvaluatingVO> pageData = this.service.queryGatherList((Page<ExpertEvaluatingVO>)page, param.getSearchText(), (Integer)((Parameter)param.getParams().get("gatherStatus")).getValue(), this.sessionManager.getUserContext().getEmployeeId());
        for (ExpertEvaluatingVO evaluatingVO : pageData) {
            Integer bidNum = 0;
            List detailList = this.detailService.list((Wrapper)new QueryWrapper().eq((Object)"evaluation_id", (Object)evaluatingVO.getId()));
            for (ExpertEvaluatingDetailEntity detailEntity : detailList) {
                if (detailEntity.getEvaluationState() != 1) continue;
                Integer n = bidNum;
                Integer n2 = bidNum = Integer.valueOf(bidNum + 1);
            }
            evaluatingVO.setBidNum(bidNum + "/" + detailList.size());
            evaluatingVO.setType(CommonUtils.getTypeName(evaluatingVO.getInviteType()));
        }
        page.setRecords(pageData);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/reject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse reject(@RequestBody ExpertEvaluatingDetailVO detailVO) {
        Long expertId = detailVO.getExpertId();
        Long evaluationId = detailVO.getEvaluationId();
        List recordList = this.expertRecordService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"evaluation_id", (Object)evaluationId)).eq((Object)"employee_id", (Object)expertId));
        ExpertRecordTotalEntity totalEntity = (ExpertRecordTotalEntity)((Object)BeanMapper.map(recordList.get(0), ExpertRecordTotalEntity.class));
        totalEntity.setRejectTime((Date)new DateTime());
        totalEntity.setRejectReason(detailVO.getRejectReason());
        totalEntity.setEvaluationTime(detailVO.getEvaluationTime());
        this.totalService.saveOrUpdate((Object)totalEntity);
        List repetitionEntityList = this.expertRepetitionService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"invite_id", (Object)((ExpertRecordEntity)((Object)recordList.get(0))).getInviteId())).eq((Object)"bid_flag", (Object)0)).orderByDesc((Object)"talk_num"));
        if (repetitionEntityList.size() > 0) {
            throw new BusinessException("\u5df2\u5f00\u542f\u4e8c\u6b21\u62a5\u4ef7");
        }
        for (Object recordEntity : recordList) {
            List recordScoreList = this.expertRecordScoreService.list((Wrapper)new QueryWrapper().eq((Object)"record_id", (Object)recordEntity.getId()));
            List recordScoreHistoryList = BeanMapper.mapList((Iterable)recordScoreList, ExpertRecordScoreHistoryEntity.class);
            for (ExpertRecordScoreHistoryEntity scoreHistoryEntity : recordScoreHistoryList) {
                this.expertRecordScoreHistoryService.saveOrUpdate((Object)scoreHistoryEntity);
                this.expertRecordScoreService.removeById(scoreHistoryEntity.getId());
            }
        }
        List expertRecordHistoryList = BeanMapper.mapList((Iterable)recordList, ExpertRecordHistoryEntity.class);
        for (ExpertRecordHistoryEntity expertRecordHistoryEntity : expertRecordHistoryList) {
            expertRecordHistoryEntity.setTotalId(totalEntity.getId());
            this.expertRecordHistoryService.saveOrUpdate((Object)expertRecordHistoryEntity);
            this.expertRecordService.removeById(expertRecordHistoryEntity.getId());
        }
        this.detailService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"evaluation_state", (Object)3)).eq((Object)"expert_id", (Object)expertId)).eq((Object)"evaluation_id", (Object)evaluationId));
        ExpertEvaluatingEntity expertEvaluating = (ExpertEvaluatingEntity)((Object)this.service.selectById(evaluationId));
        List<ExpertEvaluatingDetailEntity> evaluationList = expertEvaluating.getStuffEvaluationDetailEntities();
        String leaderName = "";
        if (CollectionUtils.isNotEmpty(evaluationList)) {
            leaderName = evaluationList.stream().filter(t -> t.getLeader() == 0).map(ExpertEvaluatingDetailEntity::getExpertName).collect(Collectors.joining());
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("dingding");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(expertId + "");
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        String formUrl = frontendBaseHost + "ejc-tender-frontend/#/bidRecordList";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String name = expertEvaluating.getPurchaseType() == 0 ? expertEvaluating.getProjectName() : expertEvaluating.getOrgName();
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u4e13\u5bb6:>----------" + sender);
        String subject = "\u60a8\u5bf9" + name + "\u7684\u8bc4\u6807\u7ed3\u679c\u88ab\u672c\u6b21\u8bc4\u6807\u7ec4\u957f[" + leaderName + "]\u9a73\u56de\uff0c\u8bf7\u5c3d\u5feb\u91cd\u65b0\u8bc4\u6807\uff0c\u907f\u514d\u6ca1\u6709\u5b8c\u6210\u672c\u6b21\u8bc4\u6807\u4efb\u52a1\u3002";
        String content = "\u60a8\u5bf9" + name + "\u7684\u8bc4\u6807\u7ed3\u679c\u88ab\u672c\u6b21\u8bc4\u6807\u7ec4\u957f[" + leaderName + "]\u9a73\u56de\uff0c\u8bf7\u5c3d\u5feb\u91cd\u65b0\u8bc4\u6807\uff0c\u907f\u514d\u6ca1\u6709\u5b8c\u6210\u672c\u6b21\u8bc4\u6807\u4efb\u52a1\u3002<a href=" + '\"' + formUrl + '\"' + ">\u8bf7\u5c3d\u5feb\u8bc4\u6807</a>";
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7684\u5185\u5bb9:>----------" + content);
        new SendMsgUtils().sendMsgByMsgType(messageType, sender, subject, content, this.pushMessageApi);
        return CommonResponse.success((String)"\u9a73\u56de\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/rejectDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> rejectDetail(Long id) {
        ExpertEvaluatingDetailEntity detailVO = (ExpertEvaluatingDetailEntity)((Object)this.evaluatingDetailService.selectById(id));
        Long expertId = detailVO.getExpertId();
        Long evaluationId = detailVO.getEvaluationId();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("expertDetail", (Object)detailVO);
        ExpertEvaluatingDetailVO expertEvaluatingDetailVO = (ExpertEvaluatingDetailVO)BeanMapper.map((Object)((Object)detailVO), ExpertEvaluatingDetailVO.class);
        data.put("expertEvaluatingDetailVO", expertEvaluatingDetailVO);
        List historyList = this.totalService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"employee_id", (Object)expertId)).eq((Object)"evaluation_id", (Object)evaluationId));
        data.put("historyList", historyList);
        if (detailVO.getEvaluationState() == 1) {
            List<List<ExpertRecordVO>> lists = this.expertRecordService.queryDetail(evaluationId, expertId);
            data.put("supplierDetail", lists);
        } else {
            List<Object> lists = new ArrayList();
            if (historyList.size() > 0) {
                lists = this.expertRecordHistoryService.queryDetail(((ExpertRecordTotalEntity)((Object)historyList.get(historyList.size() - 1))).getId(), evaluationId, expertId);
            }
            data.put("supplierDetail", lists);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", data);
    }

    @RequestMapping(value={"/collect"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse collect(@RequestBody CollectVO collectVO) {
        this.service.collect(collectVO);
        return CommonResponse.success((String)"\u8bc4\u6807\u6c47\u603b\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryCollectDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExpertEvaluatingVO> queryCollectDetail(Long id) {
        ExpertEvaluatingEntity entity = (ExpertEvaluatingEntity)((Object)this.service.selectById(id));
        ExpertEvaluatingVO vo = (ExpertEvaluatingVO)BeanMapper.map((Object)((Object)entity), ExpertEvaluatingVO.class);
        Integer bidNum = 0;
        for (ExpertEvaluatingDetailVO detailEntity : vo.getStuffEvaluationDetailEntities()) {
            if (detailEntity.getEvaluationState() != 1) continue;
            Integer n = bidNum;
            Integer n2 = bidNum = Integer.valueOf(bidNum + 1);
        }
        vo.setBidNum(bidNum + "/" + vo.getStuffEvaluationDetailEntities().size());
        Integer num = 0;
        if (bidNum < vo.getStuffEvaluationDetailEntities().size()) {
            vo.setEvaStatus(Integer.valueOf(0));
        } else if (bidNum.intValue() == vo.getStuffEvaluationDetailEntities().size()) {
            LambdaQueryWrapper lambdaRepetition = Wrappers.lambdaQuery();
            lambdaRepetition.eq(ExpertRepetitionEntity::getEvaluatingId, (Object)entity.getId());
            lambdaRepetition.eq(ExpertRepetitionEntity::getBidFlag, (Object)0);
            ExpertRepetitionEntity expertRepetitionServiceOne = (ExpertRepetitionEntity)((Object)this.expertRepetitionService.getOne((Wrapper)lambdaRepetition));
            if (expertRepetitionServiceOne != null) {
                vo.setEvaStatus(Integer.valueOf(1));
            } else {
                vo.setEvaStatus(Integer.valueOf(2));
            }
        }
        LambdaQueryWrapper lambdaRepetition2 = Wrappers.lambdaQuery();
        lambdaRepetition2.eq(ExpertRepetitionEntity::getInviteId, (Object)entity.getInviteId());
        lambdaRepetition2.eq(ExpertRepetitionEntity::getBidFlag, (Object)1);
        lambdaRepetition2.orderByAsc(ExpertRepetitionEntity::getTalkNum);
        List expertRepetitionEntityList2 = this.expertRepetitionService.list((Wrapper)lambdaRepetition2);
        if (CollectionUtils.isNotEmpty((Collection)expertRepetitionEntityList2)) {
            vo.setTalkNum(((ExpertRepetitionEntity)((Object)expertRepetitionEntityList2.get(0))).getTalkNum());
        } else {
            vo.setTalkNum(Integer.valueOf(0));
        }
        LambdaQueryWrapper lambdaRepetition = Wrappers.lambdaQuery();
        lambdaRepetition.eq(ExpertRepetitionEntity::getInviteId, (Object)entity.getInviteId());
        lambdaRepetition.eq(ExpertRepetitionEntity::getBidFlag, (Object)1);
        List expertRepetitionEntityList = this.expertRepetitionService.list((Wrapper)lambdaRepetition);
        List expertRepetitionVOS = null;
        if (CollectionUtils.isNotEmpty((Collection)expertRepetitionEntityList)) {
            expertRepetitionVOS = BeanMapper.mapList((Iterable)expertRepetitionEntityList, ExpertRepetitionVO.class);
        }
        vo.setRepetitionVOList(expertRepetitionVOS);
        List repetitionEntityList = this.expertRepetitionService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"invite_id", (Object)entity.getInviteId())).eq((Object)"publish_flag", (Object)1)).orderByDesc((Object)"talk_num"));
        if (repetitionEntityList.size() > 0) {
            num = ((ExpertRepetitionEntity)((Object)repetitionEntityList.get(0))).getTalkNum();
        }
        if (entity.getInviteType() == 5) {
            List talkEntityList = this.otherTalkService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"invite_id", (Object)entity.getInviteId())).orderByDesc((Object)"talk_num"));
            if (talkEntityList.size() > 0) {
                num = ((OtherTalkEntity)((Object)talkEntityList.get(0))).getTalkNum();
            }
            OtherDocumentVO stuffDocumentVO = this.otherDocumentService.queryDetail1(vo.getDocumentId(), num);
            vo.setScoreResult(this.service.queryScoreDetail(entity.getInviteId(), entity.getId()));
            vo.setStuffDocumentDetailSellList(stuffDocumentVO.getOtherDocumentDetailSellList());
            vo.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getOtherDocumentSupplierSchemeList());
            OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(vo.getInviteId()));
            vo.setTenderMoney(otherInviteEntity.getTenderMoney());
            vo.setTenderType(otherInviteEntity.getTenderType());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryProgressSheet"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProgressSheetVO>> queryProgressSheet(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("expertName");
        fuzzyFields.add("mobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fieldName");
        fuzzyFields.add("typeName");
        fuzzyFields.add("gradeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time_c", "desc");
        param.setOrderMap(orderMap);
        param.getParams().put("unitId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ProgressSheetVO> list = this.service.queryProgressSheet(wrapper, (Page<ProgressSheetVO>)page);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExportSheet"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportSheet(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("expertName");
        fuzzyFields.add("mobile");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fieldName");
        fuzzyFields.add("typeName");
        fuzzyFields.add("gradeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        param.getParams().put("unitId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time_c", "desc");
        param.setOrderMap(orderMap);
        List<ProgressSheetVO> list = this.service.queryProgressSheet(wrapper, (Page<ProgressSheetVO>)page);
        HashMap<String, List<ProgressSheetVO>> beans = new HashMap<String, List<ProgressSheetVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("sheet-expert.xlsx", beans, response);
    }
}

