/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.expert.controller;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordEntity;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingDetailService;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.expert.service.IExpertRecordScoreService;
import com.ejianc.business.tender.expert.service.IExpertRecordService;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingDetailVO;
import com.ejianc.business.tender.expert.vo.ExpertRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"expertRecord"})
@Api(value="\u8bc4\u6807\u8bb0\u5f55\u8868", tags={"\u8bc4\u6807\u8bb0\u5f55\u8868"})
public class ExpertRecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IExpertRecordService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExpertRecordScoreService recordScoreService;
    @Autowired
    private IExpertEvaluatingService evaluatingService;
    @Autowired
    private IExpertEvaluatingDetailService expertEvaluatingDetailService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, Object>> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody Map<String, Object> detail) {
        List supplierDetail = (List)detail.get("supplierDetail");
        if (null != detail.get("expertEvaluatingDetailVO")) {
            ObjectMapper objectMapper = new ObjectMapper();
            ExpertEvaluatingDetailVO expertEvaluatingDetailVO = (ExpertEvaluatingDetailVO)objectMapper.convertValue(detail.get("expertEvaluatingDetailVO"), ExpertEvaluatingDetailVO.class);
            ExpertEvaluatingDetailEntity evaluatingDetailEntity = (ExpertEvaluatingDetailEntity)((Object)this.expertEvaluatingDetailService.selectById(expertEvaluatingDetailVO.getId()));
            evaluatingDetailEntity.setMemo(expertEvaluatingDetailVO.getMemo());
            this.expertEvaluatingDetailService.updateById((Object)evaluatingDetailEntity);
        }
        detail.put("supplierDetail", this.service.saveOrUpdateList(supplierDetail));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", detail);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExpertRecordVO> queryDetail(@RequestParam Long id) {
        ExpertRecordEntity entity = (ExpertRecordEntity)((Object)this.service.selectById(id));
        ExpertRecordVO vo = (ExpertRecordVO)BeanMapper.map((Object)((Object)entity), ExpertRecordVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpertRecordVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExpertRecordVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpertRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StuffRecord-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refStuffRecordData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExpertRecordVO>> refStuffRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpertRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySupplierList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> querySupplierList(@RequestParam Long documentId, @RequestParam Long templateId, @RequestParam Long id) throws InvocationTargetException, IllegalAccessException {
        Map<String, Object> detailMap = this.service.querySupplierList(documentId, templateId, id);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", detailMap);
    }

    @ApiOperation(value="\u63d0\u4ea4")
    @RequestMapping(value={"/submit"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse submit(@RequestBody List<ExpertRecordEntity> recordVOList) {
        for (ExpertRecordEntity recordEntity : recordVOList) {
            recordEntity.setFlag(1);
            this.service.saveOrUpdate((Object)recordEntity);
        }
        Integer evaluationState = 1;
        this.evaluatingService.updateState(evaluationState, recordVOList.get(0).getEvaluationId(), this.sessionManager.getUserContext().getEmployeeId(), new DateTime());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }
}

