/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherInviteDetailBidderEntity;
import com.ejianc.business.tender.other.bean.OtherInviteDetailRecordEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherDocumentSupplierService;
import com.ejianc.business.tender.other.service.IOtherInviteDetailRecordService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailBidderVO;
import com.ejianc.business.tender.other.vo.OtherInviteDetailRecordVO;
import com.ejianc.business.tender.other.vo.OtherInviteVO;
import com.ejianc.business.tender.other.vo.TenderStageEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"otherInvite"})
public class OtherInviteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "TENDER_OTHER";
    private static final String CONDITION_PROJECT_ID = "projectId";
    private static final String CONDITION_ORG_ID = "orgId";
    @Autowired
    private IOtherInviteService service;
    @Autowired
    private IOtherInviteDetailRecordService detailRecordService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IOtherPicketageService picketageService;
    @Autowired
    private IOtherPicketageRefsupplierService refsupplierService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IOtherDocumentService documentService;
    @Autowired
    private IOtherDocumentSupplierService documentSupplierService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OtherInviteVO> saveOrUpdate(@RequestBody OtherInviteVO saveorUpdateVO, HttpServletRequest req) {
        List inviteIdList;
        String authority = req.getHeader("authority");
        List otherInviteDetailList = saveorUpdateVO.getOtherDetailRecord();
        ArrayList<OtherInviteDetailBidderEntity> biddeotherityList = new ArrayList<OtherInviteDetailBidderEntity>();
        if (CollectionUtils.isNotEmpty((Collection)otherInviteDetailList)) {
            for (OtherInviteDetailRecordVO otherInviteDetailVO : otherInviteDetailList) {
                List bidderList;
                if (otherInviteDetailVO.getId() == null) {
                    long id = IdWorker.getId();
                    otherInviteDetailVO.setId(Long.valueOf(id));
                }
                if (!CollectionUtils.isNotEmpty((Collection)(bidderList = otherInviteDetailVO.getOtherDetailBidder()))) continue;
                for (OtherInviteDetailBidderVO bidderVO : bidderList) {
                    bidderVO.setInviteDetailId(otherInviteDetailVO.getId());
                    OtherInviteDetailBidderEntity biddeotherity = (OtherInviteDetailBidderEntity)((Object)BeanMapper.map((Object)bidderVO, OtherInviteDetailBidderEntity.class));
                    biddeotherityList.add(biddeotherity);
                }
            }
        }
        OtherInviteEntity entity = (OtherInviteEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OtherInviteEntity.class));
        if (CollectionUtils.isNotEmpty(biddeotherityList)) {
            entity.setOtherDetailBidder(biddeotherityList);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OtherInviteVO vo = (OtherInviteVO)BeanMapper.map((Object)((Object)entity), OtherInviteVO.class);
        List otherInviteDetailVOList = vo.getOtherDetailRecord();
        List otherInviteDetailBidderVOList = vo.getOtherDetailBidder();
        if (CollectionUtils.isNotEmpty((Collection)otherInviteDetailBidderVOList)) {
            Map<Long, List<OtherInviteDetailBidderVO>> bidderMap = otherInviteDetailBidderVOList.stream().collect(Collectors.groupingBy(OtherInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty((Collection)otherInviteDetailVOList)) {
                for (OtherInviteDetailRecordVO otherInviteDetailVO : otherInviteDetailVOList) {
                    List<OtherInviteDetailBidderVO> otherInviteDetailBidderVOS = bidderMap.get(otherInviteDetailVO.getId());
                    if (!CollectionUtils.isNotEmpty(otherInviteDetailBidderVOS)) continue;
                    otherInviteDetailVO.setOtherDetailBidder(otherInviteDetailBidderVOS);
                }
            }
        }
        if (entity.getEstablishType() == 1 && CollectionUtils.isNotEmpty(inviteIdList = entity.getOtherDetailRecord().stream().map(OtherInviteDetailRecordEntity::getPlanId).distinct().collect(Collectors.toList()))) {
            this.logger.info("\u4fee\u6539\u62db\u6807\u72b6\u6001id\uff0cinviteIdList={}", inviteIdList);
            UpdateWrapper wrapper = new UpdateWrapper();
            ((UpdateWrapper)wrapper.set((Object)"occupy_state", (Object)1)).in((Object)"id", inviteIdList);
            this.service.update((Wrapper)wrapper);
        }
        if (!this.processService.selectByBillId(entity.getId())) {
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(entity.getId());
            if (vo.getEstablishType() == 1) {
                processEntity.setBillName("\u5b9a\u6807\u7acb\u9879");
            } else {
                processEntity.setBillName("\u62db\u6807\u7acb\u9879");
            }
            processEntity.setTenderId(entity.getId());
            processEntity.setType(5);
            processEntity.setFrontendUrl("other/invite/card");
            this.processService.saveOrUpdate((Object)processEntity);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherInviteVO> queryDetail(Long id) {
        OtherInviteEntity entity = (OtherInviteEntity)((Object)this.service.selectById(id));
        OtherInviteVO vo = (OtherInviteVO)BeanMapper.map((Object)((Object)entity), OtherInviteVO.class);
        List otherInviteDetailVOList = vo.getOtherDetailRecord();
        List otherInviteDetailBidderVOList = vo.getOtherDetailBidder();
        if (CollectionUtils.isNotEmpty((Collection)otherInviteDetailBidderVOList)) {
            Map<Long, List<OtherInviteDetailBidderVO>> bidderMap = otherInviteDetailBidderVOList.stream().collect(Collectors.groupingBy(OtherInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty((Collection)otherInviteDetailVOList)) {
                for (OtherInviteDetailRecordVO otherInviteDetailVO : otherInviteDetailVOList) {
                    List<OtherInviteDetailBidderVO> otherInviteDetailBidderVOS = bidderMap.get(otherInviteDetailVO.getId());
                    if (!CollectionUtils.isNotEmpty(otherInviteDetailBidderVOS)) continue;
                    otherInviteDetailVO.setOtherDetailBidder(otherInviteDetailBidderVOS);
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherInviteVO> vos) {
        List idList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long inviteId : idList) {
            List inviteIdList;
            OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.service.selectById(inviteId));
            if (inviteEntity.getEstablishType() != 1 || !CollectionUtils.isNotEmpty(inviteIdList = this.detailRecordService.list((Wrapper)new LambdaQueryWrapper().eq(OtherInviteDetailRecordEntity::getInviteId, (Object)inviteId)).stream().map(OtherInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList()))) continue;
            UpdateWrapper wrapper = new UpdateWrapper();
            ((UpdateWrapper)wrapper.set((Object)"occupy_state", (Object)0)).in((Object)"id", inviteIdList);
            this.service.update((Wrapper)wrapper);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.processService.remove((Wrapper)new LambdaQueryWrapper().in(ProcessEntity::getBillId, (Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OtherInviteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("purchaseTypeName");
        fuzzyFields.add("tenderStage");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        if (null != isMyOrder && isMyOrder.getValue().toString().contains("0") && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().remove("employeeId");
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().put("employeeId", new Parameter("eq", (Object)Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().put("employeeId", new Parameter("ne", (Object)Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");
        Parameter tenderState = (Parameter)param.getParams().get("tenderState");
        Boolean enrollFinishFlag = false;
        Boolean quoteFinishFlag = false;
        if (null != tenderState) {
            if (tenderState.getValue().toString().equals("1") || tenderState.getValue().toString().equals("2")) {
                param.getParams().put("stopTime", new Parameter("gt", (Object)new Date()));
            } else if (tenderState.getValue().toString().equals("11")) {
                enrollFinishFlag = true;
                param.getParams().put("stopTime", new Parameter("lt", (Object)new Date()));
                param.getParams().put("tenderState", new Parameter("eq", (Object)1));
            } else if (tenderState.getValue().toString().equals("21")) {
                quoteFinishFlag = true;
                param.getParams().put("stopTime", new Parameter("lt", (Object)new Date()));
                param.getParams().put("tenderState", new Parameter("eq", (Object)2));
            }
        }
        param.getParams().put(CONDITION_ORG_ID, new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OtherInviteVO.class));
        Date newData = new Date();
        for (OtherInviteVO record : pageData.getRecords()) {
            switch (record.getTenderType()) {
                case 0: {
                    record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                    break;
                }
                case 1: {
                    record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                    break;
                }
                case 2: {
                    record.setTenderTypeName("\u8be2\u4ef7");
                    break;
                }
                case 3: {
                    record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                    break;
                }
                case 4: {
                    record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                    break;
                }
                case 5: {
                    record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                }
            }
            switch (record.getSignStatus()) {
                case 0: {
                    record.setSignStatusName("\u672a\u7b7e\u8ba2");
                    break;
                }
                case 1: {
                    record.setSignStatusName("\u90e8\u5206\u7b7e\u8ba2");
                    break;
                }
                case 2: {
                    record.setSignStatusName("\u5168\u90e8\u5df2\u7b7e");
                    break;
                }
                case 3: {
                    record.setSignStatusName("\u5df2\u5173\u95ed");
                }
            }
            if (null != record.getTenderState()) {
                if (enrollFinishFlag.booleanValue()) {
                    record.setTenderStateName("\u62a5\u540d\u622a\u6b62");
                } else if (quoteFinishFlag.booleanValue()) {
                    record.setTenderStateName("\u62a5\u4ef7\u622a\u6b62");
                } else {
                    switch (record.getTenderState()) {
                        case 1: {
                            if (null != record.getStopTime() && record.getStopTime().compareTo(newData) > 0) {
                                record.setTenderStateName("\u62a5\u540d\u4e2d");
                                break;
                            }
                            record.setTenderStateName("\u62a5\u540d\u622a\u6b62");
                            break;
                        }
                        case 2: {
                            if (null != record.getStopTime() && record.getStopTime().compareTo(newData) > 0) {
                                record.setTenderStateName("\u62a5\u4ef7\u4e2d");
                                break;
                            }
                            record.setTenderStateName("\u62a5\u4ef7\u622a\u6b62");
                            break;
                        }
                        case 3: {
                            record.setTenderStateName("\u4e13\u5bb6\u8bc4\u6807\u4e2d");
                            break;
                        }
                        case 4: {
                            record.setTenderStateName("\u4e13\u5bb6\u8bc4\u6807\u7ed3\u675f");
                        }
                    }
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        param.getParams().put(CONDITION_ORG_ID, new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = JSON.parseArray((String)JSON.toJSONString((Object)list), OtherInviteVO.class);
        for (OtherInviteVO otherInviteVO : voList) {
            List documentSupplierEntityList;
            switch (otherInviteVO.getTenderType()) {
                case 0: {
                    otherInviteVO.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                    break;
                }
                case 1: {
                    otherInviteVO.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                    break;
                }
                case 2: {
                    otherInviteVO.setTenderTypeName("\u8be2\u4ef7");
                    break;
                }
                case 3: {
                    otherInviteVO.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                    break;
                }
                case 4: {
                    otherInviteVO.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                    break;
                }
                case 5: {
                    otherInviteVO.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                }
            }
            otherInviteVO.setEstablishTypeName(otherInviteVO.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            otherInviteVO.setPurchaseTypeName(otherInviteVO.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            otherInviteVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)otherInviteVO.getBillState()).getDescription());
            otherInviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)otherInviteVO.getTenderStage()).getDescription());
            List documentEntityList = this.documentService.list((Wrapper)new LambdaQueryWrapper().eq(OtherDocumentEntity::getInviteId, (Object)otherInviteVO.getId()));
            if (!CollectionUtils.isNotEmpty((Collection)documentEntityList) || !CollectionUtils.isNotEmpty((Collection)(documentSupplierEntityList = this.documentSupplierService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OtherDocumentSupplierEntity::getDocumentId, (Object)((OtherDocumentEntity)((Object)documentEntityList.get(0))).getId())).groupBy((Object[])new SFunction[]{OtherDocumentSupplierEntity::getSupplierId}))))) continue;
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < documentSupplierEntityList.size(); ++j) {
                if (j == documentSupplierEntityList.size() - 1) {
                    sb.append(((OtherDocumentSupplierEntity)((Object)documentSupplierEntityList.get(j))).getSupplierName());
                    continue;
                }
                sb.append(((OtherDocumentSupplierEntity)((Object)documentSupplierEntityList.get(j))).getSupplierName() + ",");
            }
            otherInviteVO.setSupplierTenderName(sb.toString());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("\u6750\u6599\u7acb\u9879.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOtherInviteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OtherInviteVO>> refOtherInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("tenderPlatform", new Parameter("eq", (Object)2));
        param.getParams().put("occupyState", new Parameter("eq", (Object)0));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get((Object)CONDITION_ORG_ID).toString());
                CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
                OrgVO orgVO = (OrgVO)orgResp.getData();
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put(CONDITION_ORG_ID, new Parameter("eq", (Object)orgId));
                } else {
                    param.getParams().put(CONDITION_ORG_ID, new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                }
            }
            if (_con.containsKey((Object)"purchaseType")) {
                Integer purchaseType = _con.getInteger("purchaseType");
                param.getParams().put("purchaseType", new Parameter("eq", (Object)purchaseType));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OtherInviteVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List otherInviteVOList = pageData.getRecords();
            List idList = otherInviteVOList.stream().map(BaseVO::getId).map(String::valueOf).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("inviteId", new Parameter("in", idList));
            List detailEntityList = this.detailRecordService.queryList(detailParam);
            List detailVOList = BeanMapper.mapList((Iterable)detailEntityList, OtherInviteDetailRecordVO.class);
            HashMap detailMap = new HashMap();
            for (OtherInviteDetailRecordVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getInviteId())) {
                    ((List)detailMap.get(vo.getInviteId())).add(vo);
                    continue;
                }
                ArrayList<OtherInviteDetailRecordVO> mapList = new ArrayList<OtherInviteDetailRecordVO>();
                mapList.add(vo);
                detailMap.put(vo.getInviteId(), mapList);
            }
            otherInviteVOList.forEach(t -> t.setOtherDetailRecord((List)detailMap.get(t.getId())));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getAType"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> getAType(Long tenderId) {
        Map<String, Object> map = this.service.getAbolishType(tenderId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6d41/\u5e9f\u6807\u72b6\u6001\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/detailExcelExport"}, method={RequestMethod.GET})
    @ResponseBody
    public void detailExcelExport(Long id, HttpServletResponse response) {
        OtherInviteVO otherInviteVO = (OtherInviteVO)this.queryDetail(id).getData();
        List detailList = otherInviteVO.getOtherDetailRecord();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("otherInviteDetail.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadExcel"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"otherInvite-import.xlsx", (String)"\u5176\u4ed6\u62db\u6807\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/uploadExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<OtherInviteDetailRecordVO> successList = new ArrayList<OtherInviteDetailRecordVO>();
        ArrayList<OtherInviteDetailRecordVO> errorList = new ArrayList<OtherInviteDetailRecordVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                OtherInviteDetailRecordVO detailVO = new OtherInviteDetailRecordVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                detailVO.setMaterialTypeName((String)datas.get(0));
                detailVO.setMaterialName((String)datas.get(1));
                detailVO.setSpec((String)datas.get(2));
                detailVO.setUnit((String)datas.get(3));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    errorMessage.append("[\u6570\u91cf\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        detailVO.setNum(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u6570\u91cf\u683c\u5f0f\u9519\u8bef]");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    errorMessage.append("[\u62db\u6807\u63a7\u5236\u5355\u4ef7\uff08\u65e0\u7a0e\uff09\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        detailVO.setPrice(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u62db\u6807\u63a7\u5236\u5355\u4ef7\uff08\u65e0\u7a0e\uff09\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    errorMessage.append("[\u62db\u6807\u63a7\u5236\u5355\u4ef7\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        detailVO.setTaxPrice(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u62db\u6807\u63a7\u5236\u5355\u4ef7\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    errorMessage.append("[\u7a0e\u7387%\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        detailVO.setRate(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7a0e\u7387%\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                detailVO.setAddress((String)datas.get(8));
                try {
                    detailVO.setMoneyTax(new BigDecimal((String)datas.get(9)));
                }
                catch (Exception e) {
                    errorMessage.append("[\u62db\u6807\u63a7\u5236\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                }
                try {
                    detailVO.setMoney(new BigDecimal((String)datas.get(10)));
                }
                catch (Exception e) {
                    errorMessage.append("[\u62db\u6807\u63a7\u5236\u91d1\u989d(\u65e0\u7a0e)\u5fc5\u987b\u4e3a\u6570\u5b57]");
                }
                detailVO.setMemo((String)datas.get(11));
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    detailVO.setMoneyTax(ComputeUtil.safeMultiply((BigDecimal)detailVO.getTaxPrice(), (BigDecimal)detailVO.getNum()));
                    detailVO.setMoney(ComputeUtil.safeDiv((BigDecimal)detailVO.getMoneyTax(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)new BigDecimal(1), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailVO.getRate(), (BigDecimal)new BigDecimal(100)))));
                    detailVO.setPrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getTaxPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)new BigDecimal(1), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailVO.getRate(), (BigDecimal)new BigDecimal(100)))));
                    detailVO.setTax(ComputeUtil.safeSub((BigDecimal)detailVO.getMoneyTax(), (BigDecimal)detailVO.getMoney()));
                    successList.add(detailVO);
                    continue;
                }
                detailVO.setErrorMsg(String.valueOf(errorMessage));
                errorList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/closeSignStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse closeSignStatus(Long id) {
        OtherInviteEntity entity = (OtherInviteEntity)((Object)this.service.selectById(id));
        Long refId = null;
        Integer tenderStage = entity.getTenderStage();
        Integer establishType = entity.getEstablishType();
        if (!this.sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) throw new BusinessException("\u53ea\u6709\u62db\u6807\u7ecf\u529e\u4eba\u624d\u80fd\u5173\u95ed");
        if (entity.getSignStatus() != 0 && entity.getSignStatus() != 1) throw new BusinessException("\u4e0d\u7b26\u5408\u5173\u95ed\u6761\u4ef6");
        if (establishType == 0) {
            if (tenderStage == 5 || tenderStage == 13 || tenderStage == 14) {
                OtherPicketageEntity picketageEntity = (OtherPicketageEntity)((Object)this.picketageService.list((Wrapper)new QueryWrapper().eq((Object)"invite_id", (Object)id)).get(0));
                refId = picketageEntity.getId();
            }
        } else if (entity.getBillState() == 1 || entity.getBillState() == 3) {
            refId = id;
        }
        if (refId == null) throw new BusinessException("\u4e0d\u7b26\u5408\u5173\u95ed\u6761\u4ef6");
        this.logger.info("\u5b9a\u6807ID" + refId);
        List refsupplierList = this.refsupplierService.list((Wrapper)new QueryWrapper().eq((Object)"picketage_id", (Object)refId));
        if (!CollectionUtils.isNotEmpty((Collection)refsupplierList)) {
            throw new BusinessException("\u4e0d\u7b26\u5408\u5173\u95ed\u6761\u4ef6");
        }
        refsupplierList.forEach(t -> t.setSignStatus(TenderSignStatusEnum.\u5df2\u5173\u95ed.getCode()));
        this.refsupplierService.saveOrUpdateBatch(refsupplierList);
        entity.setSignStatus(TenderSignStatusEnum.\u5df2\u5173\u95ed.getCode());
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/judgeEmployee"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> judgeEmployee(Long inviteId) {
        boolean flag = false;
        OtherInviteEntity entity = (OtherInviteEntity)((Object)this.service.selectById(inviteId));
        if (this.sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            flag = true;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)flag);
    }
}

