/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSchemeEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSellEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherTalkDetailEntity;
import com.ejianc.business.tender.other.bean.OtherTalkEntity;
import com.ejianc.business.tender.other.bean.OtherTalkRecordDetailEntity;
import com.ejianc.business.tender.other.bean.OtherTalkRecordEntity;
import com.ejianc.business.tender.other.mapper.OtherTalkMapper;
import com.ejianc.business.tender.other.service.IOtherDocumentSchemeService;
import com.ejianc.business.tender.other.service.IOtherDocumentSellService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherDocumentSupplierService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherTalkDetailService;
import com.ejianc.business.tender.other.service.IOtherTalkRecordDetailService;
import com.ejianc.business.tender.other.service.IOtherTalkRecordService;
import com.ejianc.business.tender.other.service.IOtherTalkService;
import com.ejianc.business.tender.other.vo.OtherDocumentSellVO;
import com.ejianc.business.tender.other.vo.OtherDocumentSupplierTbVO;
import com.ejianc.business.tender.other.vo.OtherDocumentSupplierVO;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.business.tender.other.vo.OtherQuotationMaterialVO;
import com.ejianc.business.tender.other.vo.OtherQuotationSchemeVO;
import com.ejianc.business.tender.other.vo.OtherQuotationSupplierVO;
import com.ejianc.business.tender.other.vo.OtherSupplierSellVO;
import com.ejianc.business.tender.other.vo.OtherTalkDetailVO;
import com.ejianc.business.tender.other.vo.OtherTalkRecordVO;
import com.ejianc.business.tender.other.vo.OtherTalkVO;
import com.ejianc.business.tender.other.vo.SupplierReplenishVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.api.IidmWebEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.IEjcCloudDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="otherTalkService")
public class OtherTalkServiceImpl
extends BaseServiceImpl<OtherTalkMapper, OtherTalkEntity>
implements IOtherTalkService {
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IOtherTalkDetailService otherTalkDetailService;
    @Autowired
    private IOtherTalkRecordService otherTalkRecordService;
    @Autowired
    private IOtherTalkRecordDetailService otherTalkRecordDetailService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private IOtherDocumentSchemeService otherDocumentSchemeService;
    @Autowired
    private IEjcCloudDataPushService systemDataPushService;
    @Autowired
    private IidmWebEnterpriseApi idmWebEnterpriseApi;
    @Autowired
    private IProcessService processService;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000006";
    @Autowired
    private IAttachmentApi attachmentApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    @Transactional
    public OtherTalkVO publishTalk(Long id) {
        OtherTalkEntity otherTalkEntity = (OtherTalkEntity)((Object)super.selectById((Serializable)id));
        otherTalkEntity.setPublishFlag(0);
        super.updateById((Object)otherTalkEntity);
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherTalkEntity.getInviteId()));
        OtherDocumentSupplierTbVO otherDocumentSupplierTbVO = new OtherDocumentSupplierTbVO();
        otherDocumentSupplierTbVO.setSourceId(otherTalkEntity.getInviteId().toString());
        otherDocumentSupplierTbVO.setSourceType("\u4e91\u5357\u5efa\u6295\u6d3d\u5546\u8c08\u5224");
        otherDocumentSupplierTbVO.setNoticeType(Integer.valueOf(4));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(otherTalkEntity.getTalkStartTime());
        otherDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(otherTalkEntity.getTalkEndTime());
        otherDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        otherDocumentSupplierTbVO.setMemo(otherTalkEntity.getMemo());
        otherDocumentSupplierTbVO.setTalkMoney(otherTalkEntity.getTalkMoney());
        otherDocumentSupplierTbVO.setTalkNum(otherTalkEntity.getTalkNum());
        otherDocumentSupplierTbVO.setTenderName(otherTalkEntity.getTalkName());
        otherDocumentSupplierTbVO.setSystemId(((EnterpriseVO)this.idmWebEnterpriseApi.getEnterpriseByTenantId(InvocationInfoProxy.getTenantid()).getData()).getId().toString());
        String stringFb = JSONObject.toJSONString((Object)otherDocumentSupplierTbVO);
        this.logger.info("\u6d3d\u5546\u8c08\u5224\u53d1\u5e03" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        otherInviteEntity.setTenderState(TenderStateEnum.\u62a5\u4ef7\u4e2d.getCode());
        otherInviteEntity.setStopTime(otherTalkEntity.getTalkEndTime());
        this.otherInviteService.saveOrUpdate((Object)otherInviteEntity);
        return this.queryDetail(id);
    }

    @Override
    public OtherTalkVO extendTalk(OtherTalkDetailVO otherTalkDetailVO) {
        OtherTalkDetailEntity otherDocumentRecordEntity = (OtherTalkDetailEntity)((Object)BeanMapper.map((Object)otherTalkDetailVO, OtherTalkDetailEntity.class));
        this.otherTalkDetailService.save((Object)otherDocumentRecordEntity);
        OtherTalkEntity otherTalkEntity = (OtherTalkEntity)((Object)super.selectById((Serializable)otherTalkDetailVO.getTalkId()));
        otherTalkEntity.setTalkEndTime(otherTalkDetailVO.getNewTime());
        boolean b = super.updateById((Object)otherTalkEntity);
        OtherSupplierSellVO supplierSellVO = new OtherSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(otherTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(otherTalkDetailVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherTalkEntity.getInviteId()));
        inviteEntity.setStopTime(otherTalkEntity.getTalkEndTime());
        this.otherInviteService.saveOrUpdate((Object)inviteEntity);
        return this.queryDetail(otherTalkDetailVO.getTalkId());
    }

    @Override
    public OtherTalkVO saveTalk(Long documentId) {
        OtherTalkEntity entity = new OtherTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        OtherDocumentEntity documentEntity = (OtherDocumentEntity)((Object)this.otherDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.otherDocumentService.saveOrUpdate((Object)documentEntity);
        OtherDocumentEntity otherDocumentEntity = (OtherDocumentEntity)((Object)this.otherDocumentService.selectById(documentId));
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherDocumentEntity.getInviteId()));
        entity.setProjectCode(otherDocumentEntity.getProjectCode());
        entity.setInviteId(otherDocumentEntity.getInviteId());
        entity.setProjectId(otherDocumentEntity.getProjectId());
        entity.setProjectName(otherDocumentEntity.getProjectName());
        entity.setOrgId(otherDocumentEntity.getOrgId());
        entity.setOrgName(otherDocumentEntity.getOrgName());
        entity.setParentOrgId(otherDocumentEntity.getParentOrgId());
        entity.setParentOrgName(otherDocumentEntity.getParentOrgName());
        entity.setBrandFlag(otherDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(otherDocumentEntity.getPurchaseType());
        entity.setTalkName(otherInviteEntity.getTenderName());
        super.save((Object)entity);
        otherInviteEntity.setTenderStage(7);
        this.otherInviteService.updateById((Object)otherInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u6d3d\u5546\u8c08\u5224");
        processEntity.setTenderId(otherDocumentEntity.getInviteId());
        processEntity.setType(5);
        processEntity.setFrontendUrl("other/talkNegotiate");
        this.processService.saveOrUpdate((Object)processEntity);
        OtherTalkVO vo = (OtherTalkVO)BeanMapper.map((Object)((Object)entity), OtherTalkVO.class);
        OtherTalkVO otherTalkVO = this.queryDetail(vo.getId());
        return otherTalkVO;
    }

    @Override
    public OtherTalkVO queryDetail(Long id) {
        OtherTalkEntity otherTalkEntity = (OtherTalkEntity)((Object)super.selectById((Serializable)id));
        OtherTalkVO otherTalkVO = (OtherTalkVO)BeanMapper.map((Object)((Object)otherTalkEntity), OtherTalkVO.class);
        Integer talkNum = otherTalkEntity.getTalkNum();
        if (otherTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        OtherDocumentVO otherDocumentVO = this.otherDocumentService.queryDocDetail(otherTalkEntity.getBillId(), talkNum);
        otherTalkVO.setOtherDocumentDetailSellList(otherDocumentVO.getOtherDocumentDetailSellList());
        otherTalkVO.setOtherDocumentSupplierSchemeList(otherDocumentVO.getOtherDocumentSupplierSchemeList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(OtherDocumentSupplierEntity::getDocumentId, (Object)otherTalkEntity.getBillId());
        lambda.eq(OtherDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.otherDocumentSupplierService.list((Wrapper)lambda);
        List documentSupplierVOList = BeanMapper.mapList((Iterable)supplierList, OtherDocumentSupplierVO.class);
        otherTalkVO.setOtherDocumentSupplierList(documentSupplierVOList);
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(OtherTalkRecordEntity::getBillId, (Object)otherTalkEntity.getBillId());
        lambdaRecord.orderByAsc(OtherTalkRecordEntity::getTalkNum);
        List otherTalkRecordEntityList = this.otherTalkRecordService.list((Wrapper)lambdaRecord);
        List otherTalkRecordList = BeanMapper.mapList((Iterable)otherTalkRecordEntityList, OtherTalkRecordVO.class);
        otherTalkVO.setTalkRecordEntityList(otherTalkRecordList);
        return otherTalkVO;
    }

    @Override
    @Transactional
    public OtherTalkVO againSaveTalk(Long id) {
        OtherTalkEntity entity = new OtherTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        OtherTalkEntity otherTalkEntity = (OtherTalkEntity)((Object)super.selectById((Serializable)id));
        entity.setProjectCode(otherTalkEntity.getProjectCode());
        entity.setProjectId(otherTalkEntity.getProjectId());
        entity.setProjectName(otherTalkEntity.getProjectName());
        entity.setOrgId(otherTalkEntity.getOrgId());
        entity.setOrgName(otherTalkEntity.getOrgName());
        entity.setParentOrgId(otherTalkEntity.getParentOrgId());
        entity.setParentOrgName(otherTalkEntity.getParentOrgName());
        entity.setBrandFlag(otherTalkEntity.getBrandFlag());
        entity.setBillId(otherTalkEntity.getBillId());
        entity.setInviteId(otherTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(otherTalkEntity.getTalkNum() + 1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(otherTalkEntity.getPurchaseType());
        super.save((Object)entity);
        OtherTalkRecordEntity otherTalkRecordEntity = (OtherTalkRecordEntity)((Object)BeanMapper.map((Object)((Object)otherTalkEntity), OtherTalkRecordEntity.class));
        otherTalkRecordEntity.setTalkId(otherTalkEntity.getId());
        otherTalkRecordEntity.setId(null);
        this.otherTalkRecordService.save((Object)otherTalkRecordEntity);
        List<OtherTalkDetailEntity> otherTalkDetailList = otherTalkEntity.getOtherTalkDetailList();
        List otherTalkRecordDetailEntityList = BeanMapper.mapList(otherTalkDetailList, OtherTalkRecordDetailEntity.class);
        for (OtherTalkRecordDetailEntity otherTalkRecordDetailEntity : otherTalkRecordDetailEntityList) {
            otherTalkRecordDetailEntity.setId(null);
            otherTalkRecordDetailEntity.setRecordId(otherTalkRecordEntity.getId());
        }
        this.otherTalkRecordDetailService.saveBatch(otherTalkRecordDetailEntityList);
        super.removeById((Serializable)id, false);
        LambdaQueryWrapper lambdaProcess = Wrappers.lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId, (Object)id);
        lambdaProcess.eq(ProcessEntity::getTenderId, (Object)otherTalkEntity.getInviteId());
        ProcessEntity processEntity = (ProcessEntity)((Object)this.processService.getOne((Wrapper)lambdaProcess));
        processEntity.setBillId(entity.getId());
        this.processService.updateById((Object)processEntity);
        OtherTalkVO vo = (OtherTalkVO)BeanMapper.map((Object)((Object)entity), OtherTalkVO.class);
        this.addLastSell(otherTalkEntity.getTalkNum(), otherTalkEntity.getBillId());
        return this.queryDetail(entity.getId());
    }

    @Override
    public OtherTalkVO replenishSell(Long id) {
        OtherTalkEntity otherTalkEntity = (OtherTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = otherTalkEntity.getTalkNum();
        Long billId = otherTalkEntity.getBillId();
        this.addLastSell(talkNum, billId);
        return new OtherTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        OtherTalkEntity otherTalkEntity = (OtherTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = otherTalkEntity.getTalkNum();
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getDocumentId, (Object)otherTalkEntity.getBillId());
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.otherDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierFirst = Wrappers.lambdaQuery();
        lambdaSupplierFirst.eq(OtherDocumentSupplierEntity::getDocumentId, (Object)otherTalkEntity.getBillId());
        lambdaSupplierFirst.eq(OtherDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierListFirst = this.otherDocumentSupplierService.list((Wrapper)lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0) {
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        HashMap<String, Object> stringListMap = new HashMap<String, Object>();
        OtherTalkEntity otherTalkEntity = (OtherTalkEntity)((Object)((OtherTalkMapper)this.baseMapper).selectById(talkId));
        ArrayList<OtherQuotationMaterialVO> materialVOList = new ArrayList<OtherQuotationMaterialVO>();
        List<OtherDocumentSellEntity> otherDocumentSellEntities = this.otherDocumentSellService.selectMaterialType(otherTalkEntity.getBillId());
        Integer talkNum = otherDocumentSellEntities.get(0).getTalkNum();
        List sellEntityList = BeanMapper.mapList(otherDocumentSellEntities, OtherDocumentSellVO.class);
        Map<Long, List<OtherDocumentSellVO>> listMap = sellEntityList.stream().filter(map -> map.getDetailId() != null).collect(Collectors.groupingBy(OtherDocumentSellVO::getDetailId));
        for (Long materialTypeId : listMap.keySet()) {
            OtherQuotationMaterialVO materialVO = new OtherQuotationMaterialVO();
            List<OtherDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
            for (OtherDocumentSellVO sellVO : materialTypeList) {
                materialVO = (OtherQuotationMaterialVO)BeanMapper.map((Object)sellVO, OtherQuotationMaterialVO.class);
            }
            List otherQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, OtherQuotationSupplierVO.class);
            List supplierVOS = otherQuotationSupplierVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OtherQuotationSupplierVO>(Comparator.comparing(f -> f.getSupplierId()))), ArrayList::new));
            materialVO.setSupplierList(supplierVOS);
            Map<Long, List<OtherDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map -> map.getSupplierId() != null).collect(Collectors.groupingBy(OtherDocumentSellVO::getSupplierId));
            for (OtherQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                List<OtherDocumentSellVO> otherDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                for (OtherDocumentSellVO otherDocumentSellVO : otherDocumentSellVOS) {
                    supplierVO.setSupplierName(otherDocumentSellVO.getSupplierName());
                }
                List otherQuotationSchemeVOS = BeanMapper.mapList(otherDocumentSellVOS, OtherQuotationSchemeVO.class);
                List schemeVOS = otherQuotationSchemeVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OtherQuotationSchemeVO>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                supplierVO.setSchemeList(schemeVOS);
                Map<String, List<OtherDocumentSellVO>> schemeMap = otherDocumentSellVOS.stream().filter(map -> map.getSchemeName() != null).collect(Collectors.groupingBy(OtherDocumentSellVO::getSchemeName));
                for (OtherQuotationSchemeVO otherQuotationSchemeVO : supplierVO.getSchemeList()) {
                    List<OtherDocumentSellVO> priceList = schemeMap.get(otherQuotationSchemeVO.getSchemeName());
                    if (priceList.size() < talkNum + 1) {
                        OtherDocumentSellVO documentSellVO = new OtherDocumentSellVO();
                        documentSellVO.setPrice(BigDecimal.valueOf(-1L));
                        documentSellVO.setPriceTax(BigDecimal.valueOf(-1L));
                        documentSellVO.setMoney(BigDecimal.valueOf(-1L));
                        documentSellVO.setMoneyTax(BigDecimal.valueOf(-1L));
                        documentSellVO.setTalkNum(talkNum);
                        priceList.add(0, documentSellVO);
                    }
                    otherQuotationSchemeVO.setPriceList(priceList);
                }
            }
            materialVOList.add(materialVO);
        }
        stringListMap.put("MaterialTypeList", materialVOList);
        stringListMap.put("offerNum", otherDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public OtherTalkVO saveOrUpdates(OtherTalkVO saveorUpdateVO) {
        OtherTalkEntity entity = (OtherTalkEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OtherTalkEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        OtherTalkVO vo = (OtherTalkVO)BeanMapper.map((Object)((Object)entity), OtherTalkVO.class);
        OtherTalkVO otherTalkVO = this.queryDetail(vo.getId());
        return otherTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplier.eq(OtherDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.otherDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierLast = Wrappers.lambdaQuery();
        lambdaSupplierLast.eq(OtherDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplierLast.eq(OtherDocumentSupplierEntity::getTalkNum, (Object)(talkNum - 1));
        List supplierListLast = this.otherDocumentSupplierService.list((Wrapper)lambdaSupplierLast);
        List supplierPk = supplierList.stream().map(OtherDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List documentSupplieotherityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List documentSupplieotherityNewList = BeanMapper.mapList(documentSupplieotherityDataList, OtherDocumentSupplierEntity.class);
        if (documentSupplieotherityNewList.size() == 0) {
            return;
        }
        ArrayList<SupplierReplenishVO> replenishVOArrayList = new ArrayList<SupplierReplenishVO>();
        OtherDocumentEntity otherDocumentEntity = (OtherDocumentEntity)((Object)this.otherDocumentService.selectById(docId));
        for (OtherDocumentSupplierEntity otherDocumentSupplierEntity : documentSupplieotherityNewList) {
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(otherDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            supplierReplenishVO.setTenantId(Long.toString(otherDocumentSupplierEntity.getSupplierTenantId()));
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        this.logger.info("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636e:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateSupOffer, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636eresponse:" + stringCommonResponse.getMsg());
        }
        List supplierPkNew = documentSupplieotherityNewList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (OtherDocumentSupplierEntity otherDocumentSupplierEntity : documentSupplieotherityNewList) {
            otherDocumentSupplierEntity.setId(IdWorker.getId());
            otherDocumentSupplierEntity.setTalkNum(talkNum);
        }
        this.otherDocumentSupplierService.saveBatch(documentSupplieotherityNewList);
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(OtherDocumentSchemeEntity::getDocumentId, (Object)docId);
        lambdaScheme.eq(OtherDocumentSchemeEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaScheme.in(OtherDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List schemeList = this.otherDocumentSchemeService.list((Wrapper)lambdaScheme);
        List schemePkList = schemeList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (OtherDocumentSchemeEntity otherDocumentSchemeEntity : schemeList) {
            otherDocumentSchemeEntity.setId(IdWorker.getId());
            otherDocumentSchemeEntity.setTalkNum(talkNum);
            for (OtherDocumentSupplierEntity otherDocumentSupplierEntity : documentSupplieotherityNewList) {
                if (!otherDocumentSchemeEntity.getSupplierId().equals(otherDocumentSupplierEntity.getSupplierId())) continue;
                otherDocumentSchemeEntity.setDocumentSupplierId(otherDocumentSupplierEntity.getId());
            }
        }
        this.otherDocumentSchemeService.saveBatch(schemeList);
        for (OtherDocumentSupplierEntity otherDocumentSupplierEntity : documentSupplieotherityNewList) {
            for (OtherDocumentSupplierEntity otherDocumentSupplierLastEntity : supplierListLast) {
                CommonResponse responseCopy;
                if (!otherDocumentSupplierEntity.getSupplierId().equals(otherDocumentSupplierLastEntity.getSupplierId()) || (responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(otherDocumentSupplierLastEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType", otherDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType")).isSuccess()) continue;
                throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u9644\u4ef6\u590d\u5236\u5931\u8d25:" + responseCopy.getMsg());
            }
        }
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(OtherDocumentSellEntity::getDocumentId, (Object)docId);
        lambdaSell.eq(OtherDocumentSellEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaSell.in(OtherDocumentSellEntity::getSchemeId, schemePkList);
        List sellList = this.otherDocumentSellService.list((Wrapper)lambdaSell);
        for (OtherDocumentSellEntity otherDocumentSellEntity : sellList) {
            otherDocumentSellEntity.setId(null);
            otherDocumentSellEntity.setTalkNum(talkNum);
            for (OtherDocumentSchemeEntity otherDocumentSchemeEntity : schemeList) {
                if (!otherDocumentSellEntity.getSupplierId().equals(otherDocumentSchemeEntity.getSupplierId()) || !otherDocumentSellEntity.getSchemeName().equals(otherDocumentSchemeEntity.getSchemeName())) continue;
                otherDocumentSellEntity.setSchemeId(otherDocumentSchemeEntity.getId());
            }
        }
        this.otherDocumentSellService.saveBatch(sellList);
    }
}

